/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.maingraph;

import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.janusgraph.core.JanusGraph;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageServerErrorCode;
import org.odpi.openmetadata.governanceservers.openlineage.maingraph.MainGraphConnectorBase;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory.GraphFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.maingraph.MainGraphConnectorHelper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainGraphConnector
extends MainGraphConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(MainGraphConnector.class);
    private JanusGraph mainGraph;
    private MainGraphConnectorHelper helper;

    public void initializeGraphDB() throws OpenLineageException {
        String graphDB = this.connectionProperties.getConfigurationProperties().get("graphDB").toString();
        GraphFactory graphFactory = new GraphFactory();
        try {
            this.mainGraph = graphFactory.openGraph(graphDB, this.connectionProperties);
        }
        catch (JanusConnectorException error) {
            log.error("The Main graph could not be initialized due to an error", (Throwable)error);
            throw new OpenLineageException(500, error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction());
        }
        this.helper = new MainGraphConnectorHelper(this.mainGraph);
    }

    public LineageResponse lineage(Scope scope, String guid, String displayNameMustContain, boolean includeProcesses) throws OpenLineageException {
        String methodName = "MainGraphConnector.lineage";
        GraphTraversalSource g = this.mainGraph.traversal();
        try {
            g.V(new Object[0]).has("vertex--nodeID", (Object)guid).next();
        }
        catch (NoSuchElementException e) {
            log.debug("Requested element was not found", (Throwable)e);
            OpenLineageServerErrorCode errorCode = OpenLineageServerErrorCode.NODE_NOT_FOUND;
            throw new OpenLineageException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorCode.getFormattedErrorMessage(new String[0]), errorCode.getSystemAction(), errorCode.getUserAction());
        }
        String edgeLabel = includeProcesses ? "DataFlowWithProcess" : "DataFlowWithoutProcess";
        LineageVerticesAndEdges lineageVerticesAndEdges = null;
        switch (scope) {
            case SOURCE_AND_DESTINATION: {
                lineageVerticesAndEdges = this.helper.sourceAndDestination(edgeLabel, guid);
                break;
            }
            case END_TO_END: {
                lineageVerticesAndEdges = this.helper.endToEnd(edgeLabel, guid);
                break;
            }
            case ULTIMATE_SOURCE: {
                lineageVerticesAndEdges = this.helper.ultimateSource(edgeLabel, guid);
                break;
            }
            case ULTIMATE_DESTINATION: {
                lineageVerticesAndEdges = this.helper.ultimateDestination(edgeLabel, guid);
                break;
            }
            case GLOSSARY: {
                lineageVerticesAndEdges = this.helper.glossary(guid);
            }
        }
        if (!displayNameMustContain.isEmpty()) {
            this.helper.filterDisplayName(lineageVerticesAndEdges, displayNameMustContain);
        }
        return new LineageResponse(lineageVerticesAndEdges);
    }

    public Object getMainGraph() {
        return this.mainGraph;
    }

    public void disconnect() throws ConnectorCheckedException {
        this.mainGraph.close();
        super.disconnect();
    }
}

