/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.buffergraph;

import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphVertexMapper {
    private static final Logger log = LoggerFactory.getLogger(GraphVertexMapper.class);

    public void mapEntityToVertex(LineageEntity lineageEntity, Vertex vertex) {
        this.mapEntitySummaryToVertex(lineageEntity, vertex);
        Map instanceProperties = lineageEntity.getProperties();
        if (instanceProperties != null) {
            for (Map.Entry entry : instanceProperties.entrySet()) {
                String key = "vertex--InstanceProp" + (String)entry.getKey();
                vertex.property(key, entry.getValue());
            }
        }
    }

    public void mapEntitySummaryToVertex(LineageEntity lineageEntity, Vertex vertex) {
        vertex.property("vertex--guid", (Object)lineageEntity.getGuid());
        vertex.property("vertex--label", (Object)lineageEntity.getTypeDefName());
        vertex.property("vertex--version", (Object)lineageEntity.getVersion());
        if (lineageEntity.getCreatedBy() != null) {
            vertex.property("vertex--createdBy", (Object)lineageEntity.getCreatedBy());
        } else {
            this.removeProperty(vertex, "vertex--createdBy");
        }
        if (lineageEntity.getCreateTime() != null) {
            vertex.property("vertex--createTime", (Object)lineageEntity.getCreateTime());
        } else {
            this.removeProperty(vertex, "vertex--createTime");
        }
        if (lineageEntity.getUpdatedBy() != null) {
            vertex.property("vertex--updatedBy", (Object)lineageEntity.getUpdatedBy());
        } else {
            this.removeProperty(vertex, "vertex--updatedBy");
        }
        if (lineageEntity.getUpdateTime() != null) {
            vertex.property("vertex--updateTime", (Object)lineageEntity.getUpdateTime());
        } else {
            this.removeProperty(vertex, "vertex--updateTime");
        }
    }

    private void removeProperty(Vertex vertex, String qualifiedPropName) {
        VertexProperty vp = vertex.property(qualifiedPropName);
        if (vp != null) {
            vp.remove();
        }
    }
}

