/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.buffergraph;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.JanusGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainGraphMapper {
    private static final Logger log = LoggerFactory.getLogger(MainGraphMapper.class);
    private JanusGraph bufferGraph;
    private JanusGraph mainGraph;

    public MainGraphMapper() {
    }

    public MainGraphMapper(JanusGraph bufferGraph, JanusGraph mainGraph) {
        this.bufferGraph = bufferGraph;
        this.mainGraph = mainGraph;
    }

    public void checkBufferGraph(String columnInGuid, String columnOutGuid, Vertex process) {
        try {
            GraphTraversalSource bufferG = this.bufferGraph.traversal();
            Vertex columnInVertex = (Vertex)bufferG.V(new Object[0]).has("vertex--guid", (Object)columnInGuid).next();
            Vertex columnOutVertex = (Vertex)bufferG.V(new Object[0]).has("vertex--guid", (Object)columnOutGuid).next();
            this.bufferGraph.tx().commit();
            this.checkMainGraph(columnInVertex, columnOutVertex, process);
        }
        catch (Exception e) {
            log.error("Something went wrong during the Janus transaction {}", (Object)e.getMessage());
            this.bufferGraph.tx().rollback();
        }
    }

    private void checkMainGraph(Vertex columnInVertex, Vertex columnOutVertex, Vertex process) {
        GraphTraversalSource mainG = this.mainGraph.traversal();
        GraphTraversalSource bufferG = this.bufferGraph.traversal();
        GraphTraversal columnIn = mainG.V(new Object[0]).has("vertex--nodeID", columnInVertex.property("vertex--guid").value());
        GraphTraversal columnOut = mainG.V(new Object[0]).has("vertex--nodeID", columnOutVertex.property("vertex--guid").value());
        Vertex newColumnIn = null;
        Vertex newColumnOut = null;
        if (!columnIn.hasNext()) {
            newColumnIn = this.checkAssetVertex(mainG, bufferG, columnInVertex);
        }
        if (!columnOut.hasNext()) {
            newColumnOut = this.checkAssetVertex(mainG, bufferG, columnOutVertex);
        }
        mainG.tx().commit();
        bufferG.tx().commit();
        if (newColumnIn == null) {
            newColumnIn = (Vertex)columnIn.next();
        }
        if (newColumnOut == null) {
            newColumnOut = (Vertex)columnOut.next();
        }
        this.addProcess(newColumnIn, newColumnOut, process);
    }

    private Vertex checkAssetVertex(GraphTraversalSource mainG, GraphTraversalSource bufferG, Vertex originalVertex) {
        Vertex newColumn = (Vertex)mainG.addV("column").property((Object)"vertex--nodeID", originalVertex.property("vertex--guid").value(), new Object[0]).next();
        this.copyVertexProperties(originalVertex, newColumn);
        this.addExtraProperties(mainG, bufferG, originalVertex, newColumn);
        return newColumn;
    }

    private void copyVertexProperties(Vertex originalVertex, Vertex newVertex) {
        Iterator iterator = originalVertex.properties(new String[0]);
        while (iterator.hasNext()) {
            VertexProperty oldVertexProperty = (VertexProperty)iterator.next();
            newVertex.property(oldVertexProperty.key(), oldVertexProperty.value());
        }
    }

    private void addExtraProperties(GraphTraversalSource mainG, GraphTraversalSource bufferG, Vertex originalVertex, Vertex newVertex) {
        GraphTraversal tableAsset = bufferG.V(new Object[]{originalVertex.id()}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(2).or(new Traversal[]{__.hasLabel((String)"RelationalTable", (String[])new String[0]), __.hasLabel((String)"DataFile", (String[])new String[0])});
        GraphTraversal schema = bufferG.V(new Object[]{originalVertex.id()}).emit().repeat((Traversal)__.bothE((String[])new String[0]).inV().simplePath()).times(3).or(new Traversal[]{__.hasLabel((String)"RelationalDBSchemaType", (String[])new String[0]), __.hasLabel((String)"FileFolder", (String[])new String[0])});
        if (tableAsset.hasNext()) {
            newVertex.property("vertex--tableDisplayName", ((Vertex)tableAsset.next()).property("vertex--InstancePropdisplayName").value());
        }
        if (schema.hasNext()) {
            newVertex.property("vertex--schemaDisplayNname", ((Vertex)schema.next()).property("vertex--InstancePropdisplayName").value());
        }
        this.getGlossaryTerm(mainG, bufferG, newVertex);
    }

    private void getGlossaryTerm(GraphTraversalSource mainG, GraphTraversalSource bufferG, Vertex asset) {
        GraphTraversal glossaryTermBuffer = bufferG.V(new Object[0]).has("vertex--guid", (Object)asset.property("vertex--guid").value().toString()).bothE(new String[]{"SemanticAssignment"}).outV();
        if (glossaryTermBuffer.hasNext()) {
            Vertex glossaryBuffer = (Vertex)glossaryTermBuffer.next();
            String guidGlossary = glossaryBuffer.property("vertex--guid").value().toString();
            Vertex glossaryMain = (Vertex)mainG.V(new Object[0]).has("vertex--guid", (Object)guidGlossary).fold().coalesce(new Traversal[]{__.unfold(), __.addV((String)"glossaryTerm")}).property((Object)"vertex--nodeID", (Object)guidGlossary, new Object[0]).next();
            mainG.V(new Object[]{asset.id()}).as("v", new String[0]).V(new Object[]{glossaryMain.id()}).coalesce(new Traversal[]{__.outE((String[])new String[]{"semanticAssignment"}).where((Traversal)__.inV().as("v", new String[0])), __.addE((String)"semanticAssignment").from("v")}).next();
            this.copyVertexProperties(glossaryBuffer, glossaryMain);
        }
    }

    private void addProcess(Vertex columnInVertex, Vertex columnOutVertex, Vertex process) {
        GraphTraversalSource mainG = this.mainGraph.traversal();
        String processGuid = (String)process.value("vertex--guid");
        String processName = (String)process.value("vertex--InstancePropdisplayName");
        if (mainG.V(new Object[]{columnInVertex.id()}).bothE(new String[]{"DataFlowWithProcess"}).otherV().has("vertex--guid", (Object)processGuid).hasNext()) {
            return;
        }
        if (columnInVertex != null && columnOutVertex != null) {
            Vertex subProcess = (Vertex)mainG.addV("subProcess").property((Object)"vertex--nodeID", (Object)UUID.randomUUID().toString(), new Object[0]).property((Object)"vertex--guid", (Object)processGuid, new Object[0]).property((Object)"vertex--displayName", (Object)processName, new Object[0]).next();
            columnInVertex.addEdge("DataFlowWithProcess", subProcess, new Object[0]);
            subProcess.addEdge("DataFlowWithProcess", columnOutVertex, new Object[0]);
            GraphTraversal processTopLevel = mainG.V(new Object[0]).has("vertex--nodeID", process.property("vertex--guid").value());
            if (processTopLevel.hasNext()) {
                Vertex mainProcess = (Vertex)processTopLevel.next();
                subProcess.addEdge("includedIn", mainProcess, new Object[0]);
                mainG.tx().commit();
                this.addTableNode(columnInVertex, columnOutVertex, mainProcess);
            } else {
                Vertex mainProcess = (Vertex)mainG.addV("process").next();
                mainProcess.property("vertex--nodeID", (Object)processGuid);
                mainProcess.property("vertex--guid", (Object)processGuid);
                mainProcess.property("vertex--displayName", (Object)processName);
                subProcess.addEdge("includedIn", mainProcess, new Object[0]);
                mainG.tx().commit();
                this.addTableNode(columnInVertex, columnOutVertex, mainProcess);
            }
        } else {
            log.debug("Process failed");
            mainG.tx().rollback();
        }
    }

    private void addTableNode(Vertex columnInVertex, Vertex columnOutVertex, Vertex process) {
        GraphTraversalSource bufferG = this.bufferGraph.traversal();
        GraphTraversalSource mainG = this.mainGraph.traversal();
        Vertex tableIn = this.getTable(bufferG, mainG, columnInVertex);
        Vertex tableOut = this.getTable(bufferG, mainG, columnOutVertex);
        if (tableIn == null || tableOut == null) {
            bufferG.tx().rollback();
            mainG.tx().rollback();
            return;
        }
        this.addTableRelationships(bufferG, mainG, tableIn, process, columnInVertex);
        this.addTableRelationships(bufferG, mainG, tableOut, process, columnOutVertex);
        this.addColumns(bufferG, mainG, tableOut);
        bufferG.tx().commit();
        mainG.tx().commit();
    }

    private void addColumns(GraphTraversalSource bufferG, GraphTraversalSource mainG, Vertex tableOut) {
        List columns = bufferG.V(new Object[0]).has("vertex--guid", tableOut.property("vertex--guid").value()).inE(new String[]{"NestedSchemaAttribute"}).otherV().toList();
        List guidList = columns.stream().map(v -> (String)v.property("vertex--guid").value()).collect(Collectors.toList());
        for (String guid : guidList) {
            GraphTraversal columnToAdd = mainG.V(new Object[0]).has("vertex--nodeID", (Object)guid);
            if (columnToAdd.hasNext()) continue;
            Vertex newColumn = (Vertex)mainG.addV("column").property((Object)"vertex--nodeID", (Object)guid, new Object[0]).next();
            Vertex originalVertex = (Vertex)bufferG.V(new Object[0]).has("vertex--guid", (Object)guid).next();
            this.copyVertexProperties(originalVertex, newColumn);
            this.addExtraProperties(mainG, bufferG, originalVertex, newColumn);
            GraphTraversal columnVertex = mainG.V(new Object[]{newColumn.id()}).bothE(new String[]{"includedIn"}).otherV().has("vertex--nodeID", tableOut.property("vertex--guid").value());
            if (columnVertex.hasNext()) continue;
            newColumn.addEdge("includedIn", tableOut, new Object[0]);
        }
    }

    private Vertex getTable(GraphTraversalSource bufferG, GraphTraversalSource mainG, Vertex asset) {
        GraphTraversal table = bufferG.V(new Object[0]).has("vertex--guid", asset.property("vertex--guid").value()).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(2).or(new Traversal[]{__.hasLabel((String)"RelationalTable", (String[])new String[0]), __.hasLabel((String)"DataFile", (String[])new String[0])});
        if (!table.hasNext()) {
            return null;
        }
        Vertex tableBuffer = (Vertex)table.next();
        GraphTraversal tableVertex = mainG.V(new Object[0]).has("vertex--nodeID", tableBuffer.property("vertex--guid").value());
        if (!tableVertex.hasNext()) {
            Vertex newTable = (Vertex)mainG.addV("table").property((Object)"vertex--nodeID", tableBuffer.property("vertex--guid").value(), new Object[0]).next();
            this.copyVertexProperties(tableBuffer, newTable);
            return newTable;
        }
        return (Vertex)tableVertex.next();
    }

    private void addTableRelationships(GraphTraversalSource bufferG, GraphTraversalSource mainG, Vertex table, Vertex process, Vertex column) {
        GraphTraversal columnVertex;
        this.getGlossaryTerm(mainG, bufferG, table);
        GraphTraversal tableVertex = mainG.V(new Object[]{table.id()}).outE(new String[]{"DataFlowWithProcess"}).otherV();
        if (!tableVertex.hasNext()) {
            table.addEdge("DataFlowWithProcess", process, new Object[0]);
        }
        if (!(columnVertex = mainG.V(new Object[]{column.id()}).outE(new String[]{"includedIn"}).inV().has("vertex--guid", table.property("vertex--guid").value())).hasNext()) {
            column.addEdge("includedIn", table, new Object[0]);
        }
    }
}

