/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.maingraph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageServerErrorCode;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageEdge;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.GraphConstants;

public class MainGraphConnectorHelper {
    private JanusGraph mainGraph;

    public MainGraphConnectorHelper(JanusGraph mainGraph) {
        this.mainGraph = mainGraph;
    }

    LineageVerticesAndEdges ultimateSource(String guid, String ... edgeLabels) throws OpenLineageException {
        String methodName = "MainGraphConnector.ultimateSource";
        GraphTraversalSource g = this.mainGraph.traversal();
        List sourcesList = g.V(new Object[0]).has("vertex--nodeID", (Object)guid).until((Traversal)__.inE((String[])edgeLabels).count().is((Object)0)).repeat((Traversal)__.inE((String[])edgeLabels).outV().simplePath()).dedup(new String[0]).toList();
        this.detectProblematicCycle(methodName, sourcesList);
        Vertex originalQueriedVertex = (Vertex)g.V(new Object[0]).has("vertex--nodeID", (Object)guid).next();
        HashSet<LineageVertex> lineageVertices = new HashSet<LineageVertex>();
        HashSet<LineageEdge> lineageEdges = new HashSet<LineageEdge>();
        LineageVertex queriedVertex = this.abstractVertex(originalQueriedVertex);
        lineageVertices.add(queriedVertex);
        this.addSourceCondensation(sourcesList, lineageVertices, lineageEdges, originalQueriedVertex, queriedVertex);
        LineageVerticesAndEdges lineageVerticesAndEdges = new LineageVerticesAndEdges(lineageVertices, lineageEdges);
        return lineageVerticesAndEdges;
    }

    LineageVerticesAndEdges ultimateDestination(String guid, String ... edgeLabels) throws OpenLineageException {
        String methodName = "MainGraphConnector.ultimateDestination";
        GraphTraversalSource g = this.mainGraph.traversal();
        List destinationsList = g.V(new Object[0]).has("vertex--nodeID", (Object)guid).until((Traversal)__.outE((String[])edgeLabels).count().is((Object)0)).repeat((Traversal)__.outE((String[])edgeLabels).inV().simplePath()).dedup(new String[0]).toList();
        this.detectProblematicCycle(methodName, destinationsList);
        Vertex originalQueriedVertex = (Vertex)g.V(new Object[0]).has("vertex--nodeID", (Object)guid).next();
        LineageVertex queriedVertex = this.abstractVertex(originalQueriedVertex);
        HashSet<LineageVertex> lineageVertices = new HashSet<LineageVertex>();
        HashSet<LineageEdge> lineageEdges = new HashSet<LineageEdge>();
        lineageVertices.add(queriedVertex);
        this.addDestinationCondensation(destinationsList, lineageVertices, lineageEdges, originalQueriedVertex, queriedVertex);
        LineageVerticesAndEdges lineageVerticesAndEdges = new LineageVerticesAndEdges(lineageVertices, lineageEdges);
        return lineageVerticesAndEdges;
    }

    LineageVerticesAndEdges endToEnd(String guid, String ... edgeLabels) {
        GraphTraversalSource g = this.mainGraph.traversal();
        Graph endToEndGraph = (Graph)g.V(new Object[0]).has("vertex--nodeID", (Object)guid).union(new Traversal[]{__.until((Traversal)__.inE((String[])edgeLabels).count().is((Object)0)).repeat((Traversal)__.inE((String[])edgeLabels).subgraph("subGraph").outV().simplePath()), __.until((Traversal)__.outE((String[])edgeLabels).count().is((Object)0)).repeat((Traversal)__.outE((String[])edgeLabels).subgraph("subGraph").inV().simplePath())}).cap("subGraph", new String[0]).next();
        LineageVerticesAndEdges lineageVerticesAndEdges = this.getLineageVerticesAndEdges(endToEndGraph);
        return lineageVerticesAndEdges;
    }

    LineageVerticesAndEdges sourceAndDestination(String guid, String ... edgeLabels) throws OpenLineageException {
        String methodName = "MainGraphConnector.sourceAndDestination";
        GraphTraversalSource g = this.mainGraph.traversal();
        List sourcesList = g.V(new Object[0]).has("vertex--nodeID", (Object)guid).until((Traversal)__.inE((String[])edgeLabels).count().is((Object)0)).repeat((Traversal)__.inE((String[])edgeLabels).outV().simplePath()).dedup(new String[0]).toList();
        List destinationsList = g.V(new Object[0]).has("vertex--nodeID", (Object)guid).until((Traversal)__.outE((String[])edgeLabels).count().is((Object)0)).repeat((Traversal)__.outE((String[])edgeLabels).inV().simplePath()).dedup(new String[0]).toList();
        this.detectProblematicCycle(methodName, sourcesList);
        this.detectProblematicCycle(methodName, destinationsList);
        Vertex originalQueriedVertex = (Vertex)g.V(new Object[0]).has("vertex--nodeID", (Object)guid).next();
        LineageVertex queriedVertex = this.abstractVertex(originalQueriedVertex);
        HashSet<LineageVertex> lineageVertices = new HashSet<LineageVertex>();
        HashSet<LineageEdge> lineageEdges = new HashSet<LineageEdge>();
        lineageVertices.add(queriedVertex);
        this.addSourceCondensation(sourcesList, lineageVertices, lineageEdges, originalQueriedVertex, queriedVertex);
        this.addDestinationCondensation(destinationsList, lineageVertices, lineageEdges, originalQueriedVertex, queriedVertex);
        LineageVerticesAndEdges lineageVerticesAndEdges = new LineageVerticesAndEdges(lineageVertices, lineageEdges);
        return lineageVerticesAndEdges;
    }

    LineageVerticesAndEdges glossary(String guid) {
        GraphTraversalSource g = this.mainGraph.traversal();
        Graph subGraph = (Graph)g.V(new Object[0]).has("vertex--nodeID", (Object)guid).emit().repeat((Traversal)__.bothE((String[])new String[]{"synonym"}).subgraph("subGraph").simplePath().otherV()).inE(new String[]{"semanticAssignment"}).subgraph("subGraph").outV().cap("subGraph", new String[0]).next();
        LineageVerticesAndEdges lineageVerticesAndEdges = this.getLineageVerticesAndEdges(subGraph);
        return lineageVerticesAndEdges;
    }

    void filterDisplayName(LineageVerticesAndEdges lineageVerticesAndEdges, String displayNameMustContain) {
        Set lineageVertices = lineageVerticesAndEdges.getLineageVertices();
        Set lineageEdges = lineageVerticesAndEdges.getLineageEdges();
        HashSet<LineageVertex> verticesToBeRemoved = new HashSet<LineageVertex>();
        HashSet<LineageEdge> edgesToBeRemoved = new HashSet<LineageEdge>();
        for (LineageVertex vertex : lineageVertices) {
            String nodeID = vertex.getNodeID();
            if (vertex.getDisplayName().contains(displayNameMustContain)) continue;
            verticesToBeRemoved.add(vertex);
            for (LineageEdge edge : lineageEdges) {
                if (!edge.getSourceNodeID().equals(nodeID) && !edge.getDestinationNodeID().equals(nodeID)) continue;
                edgesToBeRemoved.add(edge);
            }
        }
        lineageVertices.removeAll(verticesToBeRemoved);
        lineageEdges.removeAll(edgesToBeRemoved);
        lineageVerticesAndEdges.setLineageVertices(lineageVertices);
        lineageVerticesAndEdges.setLineageEdges(lineageEdges);
    }

    private LineageVertex abstractVertex(Vertex originalVertex) {
        String displayName;
        String nodeID = originalVertex.property("vertex--nodeID").value().toString();
        String nodeType = originalVertex.label();
        LineageVertex lineageVertex = new LineageVertex(nodeID, nodeType);
        if (originalVertex.property("vertex--displayName").isPresent()) {
            displayName = originalVertex.property("vertex--displayName").value().toString();
            lineageVertex.setDisplayName(displayName);
        } else if (originalVertex.property("vertex--InstancePropdisplayName").isPresent()) {
            displayName = originalVertex.property("vertex--InstancePropdisplayName").value().toString();
            lineageVertex.setDisplayName(displayName);
        }
        if (originalVertex.property("vertex--guid").isPresent()) {
            String guid = originalVertex.property("vertex--guid").value().toString();
            lineageVertex.setGuid(guid);
        }
        Map<String, String> properties = this.retrieveProperties(originalVertex);
        lineageVertex.setProperties(properties);
        return lineageVertex;
    }

    private LineageEdge abstractEdge(Edge originalEdge) {
        String sourceNodeID = originalEdge.outVertex().property("vertex--nodeID").value().toString();
        String destinationNodeId = originalEdge.inVertex().property("vertex--nodeID").value().toString();
        LineageEdge lineageEdge = new LineageEdge(originalEdge.label(), sourceNodeID, destinationNodeId);
        return lineageEdge;
    }

    private Map<String, String> retrieveProperties(Vertex originalVertex) {
        HashMap<String, String> newNodeProperties = new HashMap<String, String>();
        Iterator originalProperties = originalVertex.properties(new String[0]);
        while (originalProperties.hasNext()) {
            Property originalProperty = (Property)originalProperties.next();
            if (!GraphConstants.immutableReturnedPropertiesWhiteList.contains((Object)originalProperty.key())) continue;
            String newPropertyKey = originalProperty.key().replace("vertex--InstanceProp", "").replace("vertex--", "");
            String newPropertyValue = originalProperty.value().toString();
            newNodeProperties.put(newPropertyKey, newPropertyValue);
        }
        return newNodeProperties;
    }

    private void detectProblematicCycle(String methodName, List<Vertex> vertexList) throws OpenLineageException {
        if (!vertexList.isEmpty()) {
            return;
        }
        OpenLineageServerErrorCode errorCode = OpenLineageServerErrorCode.LINEAGE_CYCLE;
        throw new OpenLineageException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorCode.getFormattedErrorMessage(new String[0]), errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void addSourceCondensation(List<Vertex> sourcesList, Set<LineageVertex> lineageVertices, Set<LineageEdge> lineageEdges, Vertex originalQueriedVertex, LineageVertex queriedVertex) {
        if (sourcesList.get(0).property("vertex--nodeID").equals(originalQueriedVertex.property("vertex--nodeID"))) {
            return;
        }
        LineageVertex condensedVertex = new LineageVertex("condensedSource", "condensedNode");
        condensedVertex.setDisplayName("...");
        lineageVertices.add(condensedVertex);
        for (Vertex originalVertex : sourcesList) {
            LineageVertex newVertex = this.abstractVertex(originalVertex);
            LineageEdge newEdge = new LineageEdge("condensed", newVertex.getNodeID(), condensedVertex.getNodeID());
            lineageVertices.add(newVertex);
            lineageEdges.add(newEdge);
        }
        LineageEdge sourceEdge = new LineageEdge("condensed", condensedVertex.getNodeID(), queriedVertex.getNodeID());
        lineageEdges.add(sourceEdge);
    }

    private void addDestinationCondensation(List<Vertex> destinationsList, Set<LineageVertex> lineageVertices, Set<LineageEdge> lineageEdges, Vertex originalQueriedVertex, LineageVertex queriedVertex) {
        if (!destinationsList.get(0).property("vertex--nodeID").equals(originalQueriedVertex.property("vertex--nodeID"))) {
            LineageVertex condensedDestinationVertex = new LineageVertex("condensedDestination", "condensedNode");
            condensedDestinationVertex.setDisplayName("...");
            for (Vertex originalVertex : destinationsList) {
                LineageVertex newVertex = this.abstractVertex(originalVertex);
                LineageEdge newEdge = new LineageEdge("condensed", condensedDestinationVertex.getNodeID(), newVertex.getNodeID());
                lineageVertices.add(newVertex);
                lineageEdges.add(newEdge);
            }
            LineageEdge destinationEdge = new LineageEdge("condensed", queriedVertex.getNodeID(), condensedDestinationVertex.getNodeID());
            lineageVertices.add(condensedDestinationVertex);
            lineageEdges.add(destinationEdge);
        }
    }

    private LineageVerticesAndEdges getLineageVerticesAndEdges(Graph subGraph) {
        Iterator originalVertices = subGraph.vertices(new Object[0]);
        Iterator originalEdges = subGraph.edges(new Object[0]);
        HashSet<LineageVertex> lineageVertices = new HashSet<LineageVertex>();
        HashSet<LineageEdge> lineageEdges = new HashSet<LineageEdge>();
        while (originalVertices.hasNext()) {
            LineageVertex newVertex = this.abstractVertex((Vertex)originalVertices.next());
            lineageVertices.add(newVertex);
        }
        while (originalEdges.hasNext()) {
            LineageEdge newLineageEdge = this.abstractEdge((Edge)originalEdges.next());
            lineageEdges.add(newLineageEdge);
        }
        LineageVerticesAndEdges lineageVerticesAndEdges = new LineageVerticesAndEdges(lineageVertices, lineageEdges);
        return lineageVerticesAndEdges;
    }
}

