/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.maingraph;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONWriter;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.graphdb.tinkerpop.io.graphson.JanusGraphSONModuleV2d0;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageServerErrorCode;
import org.odpi.openmetadata.governanceservers.openlineage.maingraph.MainGraphConnectorBase;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory.GraphFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.maingraph.MainGraphConnectorHelper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainGraphConnector
extends MainGraphConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(MainGraphConnector.class);
    private JanusGraph mainGraph;
    private MainGraphConnectorHelper helper;

    public void initializeGraphDB() throws OpenLineageException {
        GraphFactory graphFactory = new GraphFactory();
        try {
            this.mainGraph = graphFactory.openGraph(this.connectionProperties);
        }
        catch (JanusConnectorException error) {
            log.error("The Main graph could not be initialized due to an error", (Throwable)error);
            throw new OpenLineageException(500, error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction());
        }
        this.helper = new MainGraphConnectorHelper(this.mainGraph);
    }

    public LineageResponse lineage(Scope scope, String guid, String displayNameMustContain, boolean includeProcesses) throws OpenLineageException {
        String methodName = "lineage";
        GraphTraversalSource g = this.mainGraph.traversal();
        try {
            g.V(new Object[0]).has("vertex--nodeID", (Object)guid).next();
        }
        catch (NoSuchElementException e) {
            log.debug("Requested element was not found", (Throwable)e);
            OpenLineageServerErrorCode errorCode = OpenLineageServerErrorCode.NODE_NOT_FOUND;
            throw new OpenLineageException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorCode.getFormattedErrorMessage(new String[0]), errorCode.getSystemAction(), errorCode.getUserAction());
        }
        ArrayList<String> edgeLabels = new ArrayList<String>();
        edgeLabels.add("semanticAssignment");
        edgeLabels.add(includeProcesses ? "DataFlowWithProcess" : "DataFlowWithoutProcess");
        LineageVerticesAndEdges lineageVerticesAndEdges = null;
        switch (scope) {
            case SOURCE_AND_DESTINATION: {
                lineageVerticesAndEdges = this.helper.sourceAndDestination(guid, edgeLabels.toArray(new String[edgeLabels.size()]));
                break;
            }
            case END_TO_END: {
                lineageVerticesAndEdges = this.helper.endToEnd(guid, edgeLabels.toArray(new String[edgeLabels.size()]));
                break;
            }
            case ULTIMATE_SOURCE: {
                lineageVerticesAndEdges = this.helper.ultimateSource(guid, edgeLabels.toArray(new String[edgeLabels.size()]));
                break;
            }
            case ULTIMATE_DESTINATION: {
                lineageVerticesAndEdges = this.helper.ultimateDestination(guid, edgeLabels.toArray(new String[edgeLabels.size()]));
                break;
            }
            case GLOSSARY: {
                lineageVerticesAndEdges = this.helper.glossary(guid);
            }
        }
        if (!displayNameMustContain.isEmpty()) {
            this.helper.filterDisplayName(lineageVerticesAndEdges, displayNameMustContain);
        }
        return new LineageResponse(lineageVerticesAndEdges);
    }

    public void dumpMainGraph() {
        try {
            ((GraphMLIo)this.mainGraph.io(IoCore.graphml())).writeGraph("mainGraph.graphml");
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    public String exportMainGraph() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GraphSONMapper mapper = GraphSONMapper.build().addCustomModule((SimpleModule)JanusGraphSONModuleV2d0.getInstance()).create();
        GraphSONWriter writer = GraphSONWriter.build().mapper((Mapper)mapper).wrapAdjacencyList(true).create();
        try {
            writer.writeGraph((OutputStream)out, (Graph)this.mainGraph);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return ((Object)out).toString();
    }

    public Object getMainGraph() {
        return this.mainGraph;
    }

    public void disconnect() throws ConnectorCheckedException {
        this.mainGraph.close();
        super.disconnect();
    }
}

