/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageRelationship;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.graph.LineageGraphConnectorBase;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageVertexResponse;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory.GraphFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphConnectorHelper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphTransactionManager;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageGraphConnector
extends LineageGraphConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(LineageGraphConnector.class);
    private LineageGraphConnectorHelper helper;
    private GraphTraversalSource g;
    private GraphFactory graphFactory;
    private AuditLog auditLog;

    public void initializeGraphDB(AuditLog auditLog) throws OpenLineageException {
        this.auditLog = auditLog;
        try {
            this.graphFactory = new GraphFactory();
            this.g = this.graphFactory.openGraph(this.connectionProperties.getConnectorType().getConnectorProviderClassName(), this.connectionProperties, auditLog);
            if (this.g == null) {
                log.error("The graphTraversal is empty connection with the graph is not established");
                JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.GRAPH_TRAVERSAL_EMPTY;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage("The graphTraversal is empty connection with the graph is not established", "initializeGraphDB", LineageGraphConnector.class.getName());
                throw new OpenLineageException(500, ((Object)((Object)errorCode)).getClass().getName(), errorMessage, errorCode.getErrorMessage(), errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.helper = new LineageGraphConnectorHelper(this.g, this.graphFactory.isSupportingTransactions());
        }
        catch (JanusConnectorException error) {
            log.error("The Lineage graph could not be initialized due to an error", (Throwable)error);
            throw new OpenLineageException(500, error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction());
        }
    }

    public void disconnect() {
        try {
            this.graphFactory.closeGraph();
            super.disconnect();
        }
        catch (Exception e) {
            log.error("Exception while closing lineage graph: ", (Throwable)e);
            this.auditLog.logException("Exception while closing lineage graph", JanusConnectorErrorCode.GRAPH_DISCONNECT_ERROR.getMessageDefinition(), (Throwable)e);
        }
    }

    public void performLineageGraphJob() {
        block3: {
            try {
                List vertices = this.g.V(new Object[0]).has("vertex--label", (Object)"Process").toList();
                List<String> guidList = vertices.stream().map(v -> ((Map)this.g.V(new Object[]{v.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid").toString()).collect(Collectors.toList());
                guidList.forEach(guid -> this.findInputColumns(this.g, (String)guid));
                if (this.graphFactory.isSupportingTransactions()) {
                    this.g.tx().commit();
                }
            }
            catch (Exception e) {
                log.error("Something went wrong when trying to map a process. The error is: ", (Throwable)e);
                this.auditLog.logException("Something went wrong when trying to map a process.", JanusConnectorErrorCode.PROCESS_MAPPING_ERROR.getMessageDefinition(), (Throwable)e);
                if (!this.graphFactory.isSupportingTransactions()) break block3;
                this.g.tx().rollback();
            }
        }
    }

    public void saveAssetLineageUpdateTime(Long lastUpdateTime) {
        this.g.getGraph().variables().set("assetLineageLastUpdateTimestamp", (Object)lastUpdateTime);
    }

    public Optional<Long> getAssetLineageUpdateTime() {
        Optional lastUpdateTime = this.g.getGraph().variables().get("assetLineageLastUpdateTimestamp");
        if (lastUpdateTime.isPresent()) {
            return lastUpdateTime;
        }
        return Optional.empty();
    }

    private void findInputColumns(GraphTraversalSource g, String guid) {
        List inputPathsForColumns = g.V(new Object[0]).has("vertex--guid", (Object)guid).out(new String[]{"ProcessPort"}).out(new String[]{"PortDelegation"}).has("PortImplementation", "vertex--InstancePropportType", (Object)"INPUT_PORT").out(new String[]{"PortSchema"}).out(new String[]{"AttributeForSchema"}).in(new String[]{"LineageMapping"}).or(new Traversal[]{__.in((String[])new String[]{"AttributeForSchema"}).in(new String[]{"AssetSchemaType"}).has("vertex--label", P.within(Constants.DATA_FILE_AND_SUBTYPES)), __.in((String[])new String[]{"NestedSchemaAttribute"}).has("vertex--label", (Object)"RelationalTable")}).toList();
        if (this.graphFactory.isSupportingTransactions()) {
            g.tx().commit();
        }
        Vertex process = (Vertex)g.V(new Object[0]).has("vertex--guid", (Object)guid).next();
        inputPathsForColumns.forEach(columnIn -> this.findOutputColumns(g, (Vertex)columnIn, process));
    }

    private void findOutputColumns(GraphTraversalSource g, Vertex columnIn, Vertex process) {
        List schemaElementVertices = g.V(new Object[0]).has("vertex--guid", ((Map)g.V(new Object[]{columnIn.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid")).out(new String[]{"LineageMapping"}).toList();
        if (this.graphFactory.isSupportingTransactions()) {
            g.tx().commit();
        }
        if (schemaElementVertices != null) {
            ArrayList<Vertex> columnOutList = new ArrayList<Vertex>();
            for (Vertex schemaElementVertex : schemaElementVertices) {
                Vertex vertexToStart = this.isSchemaElementLinkedToProcess(g, schemaElementVertex, process);
                if (vertexToStart != null) {
                    columnOutList.addAll(this.findPathForOutputAsset(vertexToStart, g, columnIn));
                }
                for (Vertex columnOut : columnOutList) {
                    this.addNodesAndEdgesForQuerying(columnIn, columnOut, process);
                }
            }
        }
    }

    private Vertex isSchemaElementLinkedToProcess(GraphTraversalSource g, Vertex schemaElementVertex, Vertex process) {
        List initialProcess = g.V(new Object[]{schemaElementVertex.id()}).bothE(new String[]{"AttributeForSchema"}).otherV().inE(new String[]{"PortSchema"}).otherV().inE(new String[]{"PortDelegation"}).otherV().inE(new String[]{"ProcessPort"}).otherV().has("vertex--guid", ((Map)g.V(new Object[]{process.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid")).toList();
        if (this.graphFactory.isSupportingTransactions()) {
            g.tx().commit();
        }
        if (!initialProcess.isEmpty()) {
            return schemaElementVertex;
        }
        return null;
    }

    private boolean isColumnEmpty(Vertex column) {
        return column == null || !StringUtils.isNotEmpty((CharSequence)this.getGuid(column));
    }

    private void addNodesAndEdgesForQuerying(Vertex columnIn, Vertex columnOut, Vertex process) {
        if (this.isColumnEmpty(columnIn) || this.isColumnEmpty(columnOut)) {
            return;
        }
        String processGuid = this.getGuid(process);
        String columnInGuid = this.getGuid(columnIn);
        String columnOutGuid = this.getGuid(columnOut);
        String processName = ((Map)this.g.V(new Object[]{process.id()}).elementMap(new String[]{"vertex--InstancePropdisplayName"}).toList().get(0)).get("vertex--InstancePropdisplayName").toString();
        GraphTraversal t = this.g.V(new Object[]{columnIn.id()}).outE(new String[]{"ColumnDataFlow"}).inV().has("columnOutGuid", (Object)columnOutGuid).has("processGuid", (Object)processGuid);
        if (!t.hasNext()) {
            Vertex subProcess = (Vertex)this.g.addV("subProcess").property((Object)"vertex--nodeID", (Object)UUID.randomUUID().toString(), new Object[0]).property((Object)"vertex--displayName", (Object)processName, new Object[0]).property((Object)"processGuid", (Object)processGuid, new Object[0]).property((Object)"columnInGuid", (Object)columnInGuid, new Object[0]).property((Object)"columnOutGuid", (Object)columnOutGuid, new Object[0]).next();
            this.g.V(new Object[]{columnIn.id()}).addE("ColumnDataFlow").to((Traversal)this.g.V(new Object[]{subProcess.id()})).next();
            this.g.V(new Object[]{subProcess.id()}).addE("ColumnDataFlow").to((Traversal)this.g.V(new Object[]{columnOut.id()})).next();
            this.g.V(new Object[]{subProcess.id()}).addE("includedIn").to((Traversal)this.g.V(new Object[]{process.id()})).next();
            if (this.graphFactory.isSupportingTransactions()) {
                this.g.tx().commit();
            }
            this.addAssetToProcessEdges(columnIn, columnOut, process);
            log.info("OLS has added the corresponding subProcess node and edges for input column {}, output column {} and process {} ", new Object[]{columnInGuid, columnOutGuid, processGuid});
        }
    }

    private void addAssetToProcessEdges(Vertex columnIn, Vertex columnOut, Vertex process) {
        GraphTraversal tableVertex;
        Optional<Vertex> assetOut;
        GraphTraversal tableVertex2;
        Optional<Vertex> assetIn = this.getAsset(columnIn);
        if (assetIn.isPresent() && !(tableVertex2 = this.g.V(new Object[]{assetIn.get().id()}).outE(new String[]{"TableDataFlow"}).inV().hasId(process.id(), new Object[0])).hasNext()) {
            this.g.V(new Object[]{assetIn.get().id()}).addE("TableDataFlow").to((Traversal)this.g.V(new Object[]{process.id()})).next();
        }
        if ((assetOut = this.getAsset(columnOut)).isPresent() && !(tableVertex = this.g.V(new Object[]{assetOut.get().id()}).inE(new String[]{"TableDataFlow"}).outV().hasId(process.id(), new Object[0])).hasNext()) {
            this.g.V(new Object[]{process.id()}).addE("TableDataFlow").to((Traversal)this.g.V(new Object[]{assetOut.get().id()})).next();
        }
        if (this.graphFactory.isSupportingTransactions()) {
            this.g.tx().commit();
        }
    }

    private String getGuid(Vertex vertex) {
        return ((Map)this.g.V(new Object[]{vertex.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid").toString();
    }

    private Optional<Vertex> getAsset(Vertex asset) {
        Object vertexGuid = ((Map)this.g.V(new Object[]{asset.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid");
        Vertex graphVertex = (Vertex)this.g.V(new Object[0]).has("vertex--guid", vertexGuid).next();
        Object vertexId = graphVertex.id();
        if ("RelationalColumn".equalsIgnoreCase(asset.label())) {
            GraphTraversal table = this.g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"RelationalTable", (String[])new String[0])});
            return Optional.of(table.next());
        }
        if ("TabularColumn".equalsIgnoreCase(asset.label())) {
            GraphTraversal dataFile = this.g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(2).or(new Traversal[]{__.hasLabel((P)P.within(Constants.DATA_FILE_AND_SUBTYPES))});
            return Optional.of(dataFile.next());
        }
        return Optional.empty();
    }

    public void storeToGraph(Set<GraphContext> graphContext) {
        graphContext.forEach(entry -> {
            try {
                LineageEntity fromEntity = entry.getFromVertex();
                LineageEntity toEntity = entry.getToVertex();
                this.upsertToGraph(fromEntity, toEntity, entry.getRelationshipType(), entry.getRelationshipGuid());
            }
            catch (Exception e) {
                log.error("An exception happened when trying to create vertices and relationships in LineageGraph. The error is", (Throwable)e);
            }
        });
    }

    public void updateNeighbours(String nodeGUID, Set<String> neighboursGUIDS) {
        List<String> existingNeighboursGUIDs = this.getAllNeighbours(nodeGUID);
        if (this.isDifferentGraphContext(neighboursGUIDS, existingNeighboursGUIDs)) {
            this.removeObsoleteEdges(nodeGUID, neighboursGUIDS, existingNeighboursGUIDs);
        }
    }

    private List<String> getAllNeighbours(String entityGUID) {
        GraphTraversal exitingVertices = this.g.V(new Object[0]).has("vertex--guid", (Object)entityGUID).bothE(new String[0]).otherV();
        ArrayList<String> existingGUIDs = new ArrayList<String>();
        while (exitingVertices.hasNext()) {
            existingGUIDs.add((String)((Vertex)exitingVertices.next()).property("vertex--guid").value());
        }
        return existingGUIDs;
    }

    private boolean isDifferentGraphContext(Set<String> newVertices, List<String> neighboursGUIDs) {
        return neighboursGUIDs.size() != newVertices.size() || !neighboursGUIDs.containsAll(newVertices);
    }

    private void removeObsoleteEdges(String entityGUID, Set<String> newVertices, List<String> neighboursGUIDs) {
        Function<Edge, GraphTraversal> dropEdgeFromGraph = e -> this.g.E(new Object[]{e.id()}).drop().iterate();
        List obsoleteNeighbours = neighboursGUIDs.stream().filter(existingVertex -> !newVertices.contains(existingVertex)).collect(Collectors.toList());
        if (obsoleteNeighbours.isEmpty()) {
            return;
        }
        GraphTraversal existingEdges = this.g.V(new Object[0]).has("vertex--guid", (Object)entityGUID).bothE(new String[0]);
        while (existingEdges.hasNext()) {
            Edge edge = (Edge)existingEdges.next();
            String inVertexGuid = (String)edge.inVertex().property("vertex--guid").value();
            String outVertexGuid = (String)edge.outVertex().property("vertex--guid").value();
            if (!obsoleteNeighbours.contains(inVertexGuid) && !obsoleteNeighbours.contains(outVertexGuid)) continue;
            LineageGraphTransactionManager.commit(this.graphFactory, this.g, dropEdgeFromGraph, edge, "Could not drop edge " + edge.id());
        }
    }

    private void upsertToGraph(LineageEntity fromEntity, LineageEntity toEntity, String relationshipLabel, String relationshipGuid) {
        Function<LineageEntity, Vertex> createVertexFunction = lineageEntity -> (Vertex)this.g.V(new Object[0]).has("vertex--guid", (Object)lineageEntity.getGuid()).fold().coalesce(new Traversal[]{__.unfold(), __.addV((String)lineageEntity.getTypeDefName()).property((Object)"vertex--guid", (Object)lineageEntity.getGuid(), new Object[0])}).next();
        Vertex from = LineageGraphTransactionManager.commit(this.graphFactory, this.g, createVertexFunction, fromEntity, "Unable to create vertex with type " + fromEntity.getTypeDefName() + " and guid " + fromEntity.getGuid());
        Vertex to = LineageGraphTransactionManager.commit(this.graphFactory, this.g, createVertexFunction, toEntity, "Unable to create vertex with type " + toEntity.getTypeDefName() + " and guid " + toEntity.getGuid());
        Supplier<Edge> createEdgeSupplier = () -> (Edge)this.g.V(new Object[]{from.id()}).as("from", new String[0]).V(new Object[]{to.id()}).coalesce(new Traversal[]{__.inE((String[])new String[]{relationshipLabel}).where((Traversal)__.outV().as("from", new String[0])), __.addE((String)relationshipLabel).from("from")}).property((Object)"edge--guid", (Object)relationshipGuid, new Object[0]).next();
        LineageGraphTransactionManager.commit(this.graphFactory, this.g, createEdgeSupplier, "Unable to create edge with label " + relationshipLabel + " and guid " + relationshipGuid);
        BiConsumer<Vertex, LineageEntity> addOrUpdatePropertiesVertexConsumer = this::addOrUpdatePropertiesVertex;
        LineageGraphTransactionManager.commit(this.graphFactory, this.g, addOrUpdatePropertiesVertexConsumer, from, fromEntity, "Unable to add properties on vertex from entity with type " + fromEntity.getTypeDefName() + "and guid " + fromEntity.getGuid());
        LineageGraphTransactionManager.commit(this.graphFactory, this.g, addOrUpdatePropertiesVertexConsumer, to, toEntity, "Unable to add properties on vertex from entity with type " + toEntity.getTypeDefName() + "and guid " + toEntity.getGuid());
    }

    private void addOrUpdatePropertiesVertex(Vertex vertex, LineageEntity lineageEntity) {
        Map<String, Object> properties = lineageEntity.getProperties().entrySet().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)((CharSequence)e.getValue()))).collect(Collectors.toMap(e -> "vertex--InstanceProp" + (String)e.getKey(), Map.Entry::getValue));
        properties.computeIfAbsent("vertex--createTime", val -> lineageEntity.getCreateTime());
        properties.computeIfAbsent("vertex--createdBy", val -> lineageEntity.getCreatedBy());
        properties.computeIfAbsent("vertex--updateTime", val -> lineageEntity.getUpdateTime());
        properties.computeIfAbsent("vertex--updatedBy", val -> lineageEntity.getUpdatedBy());
        properties.computeIfAbsent("vertex--label", val -> lineageEntity.getTypeDefName());
        properties.computeIfAbsent("vertex--version", val -> lineageEntity.getVersion());
        properties.computeIfAbsent("vertex--metadataCollectionId", val -> lineageEntity.getMetadataCollectionId());
        this.g.inject((Object[])new Map[]{properties}).unfold().as("properties", new String[0]).V(new Object[]{vertex.id()}).as("v", new String[0]).sideEffect((Traversal)__.select((String)"properties").unfold().as("kv", new String[0]).select("v").property((Object)__.select((String)"kv").by((Function)Column.keys), (Object)__.select((String)"kv").by((Function)Column.values), new Object[0])).iterate();
    }

    public void updateEntity(LineageEntity lineageEntity) {
        block5: {
            GraphTraversal vertex = this.g.V(new Object[0]).has("vertex--guid", (Object)lineageEntity.getGuid());
            if (!vertex.hasNext()) {
                log.debug("when trying to update, vertex with guid {} was not found  ", (Object)lineageEntity.getGuid());
                if (this.graphFactory.isSupportingTransactions()) {
                    this.g.tx().rollback();
                }
                return;
            }
            try {
                this.addOrUpdatePropertiesVertex((Vertex)vertex.next(), lineageEntity);
                if (this.graphFactory.isSupportingTransactions()) {
                    this.g.tx().commit();
                }
            }
            catch (Exception e) {
                log.error("An exception happened during update of the properties with exception: ", (Throwable)e);
                if (!this.graphFactory.isSupportingTransactions()) break block5;
                this.g.tx().rollback();
            }
        }
    }

    public void upsertRelationship(LineageRelationship lineageRelationship) {
        LineageEntity firstEnd = lineageRelationship.getSourceEntity();
        LineageEntity secondEnd = lineageRelationship.getTargetEntity();
        this.upsertToGraph(firstEnd, secondEnd, lineageRelationship.getTypeDefName(), lineageRelationship.getGuid());
        Consumer<LineageRelationship> addOrUpdatePropertiesEdge = this::addOrUpdatePropertiesEdge;
        LineageGraphTransactionManager.commit(this.graphFactory, this.g, addOrUpdatePropertiesEdge, lineageRelationship, "Unable to add properties on edge from relationship with type " + lineageRelationship.getTypeDefName() + "and guid " + lineageRelationship.getGuid());
    }

    public void updateRelationship(LineageRelationship lineageRelationship) {
        block5: {
            GraphTraversal edge = this.g.E(new Object[0]).has("edge--guid", (Object)lineageRelationship.getGuid());
            if (!edge.hasNext()) {
                log.debug("when trying to update, edge with guid {} was not found", (Object)lineageRelationship.getGuid());
                if (this.graphFactory.isSupportingTransactions()) {
                    this.g.tx().rollback();
                }
                return;
            }
            try {
                this.addOrUpdatePropertiesEdge(lineageRelationship);
                if (this.graphFactory.isSupportingTransactions()) {
                    this.g.tx().commit();
                }
            }
            catch (Exception e) {
                log.debug("An exception happened during update of the properties with error:", (Throwable)e);
                if (!this.graphFactory.isSupportingTransactions()) break block5;
                this.g.tx().rollback();
            }
        }
    }

    public void updateClassification(Set<GraphContext> classificationContext) {
        for (GraphContext graphContext : classificationContext) {
            String classificationGuid = graphContext.getToVertex().getGuid();
            GraphTraversal vertexIterator = this.g.V(new Object[0]).has("vertex--guid", (Object)classificationGuid);
            if (!vertexIterator.hasNext()) {
                log.debug("Classification with guid {} not found", (Object)classificationGuid);
                if (!this.graphFactory.isSupportingTransactions()) continue;
                this.g.tx().rollback();
                continue;
            }
            Vertex storedClassification = (Vertex)vertexIterator.next();
            long storedClassificationVersion = (Long)((Map)this.g.V(new Object[]{storedClassification.id()}).elementMap(new String[]{"vertex--version"}).toList().get(0)).get("vertex--version");
            if (storedClassificationVersion >= graphContext.getToVertex().getVersion()) continue;
            this.addOrUpdatePropertiesVertex(storedClassification, graphContext.getToVertex());
            if (!this.graphFactory.isSupportingTransactions()) break;
            this.g.tx().commit();
            break;
        }
    }

    public void deleteClassification(Set<GraphContext> classificationContext) {
        block2: for (GraphContext context : classificationContext) {
            Graph entityAndClassificationsGraph = (Graph)this.g.V(new Object[0]).has("vertex--guid", (Object)context.getFromVertex().getGuid()).bothE(new String[]{"Classification"}).subgraph("s").cap("s", new String[0]).next();
            Iterator edges = entityAndClassificationsGraph.edges(new Object[0]);
            while (edges.hasNext()) {
                Edge edge = (Edge)edges.next();
                String storedClassificationGuid = (String)((Map)this.g.E(new Object[]{edge.id()}).inV().elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid");
                if (!context.getToVertex().getGuid().equals(storedClassificationGuid)) continue;
                try {
                    this.g.V(new Object[0]).has("vertex--guid", (Object)storedClassificationGuid).drop();
                    this.g.E(new Object[]{edge.id()}).drop();
                    if (!this.graphFactory.isSupportingTransactions()) continue block2;
                    this.g.tx().commit();
                    continue block2;
                }
                catch (Exception e) {
                    log.debug("An exception happened during delete of classifications with error:", (Throwable)e);
                    if (!this.graphFactory.isSupportingTransactions()) continue;
                    this.g.tx().rollback();
                }
            }
        }
    }

    public void deleteEntity(String guid, Object version) {
        GraphTraversal vertex = this.g.V(new Object[0]).has("vertex--guid", (Object)guid).has("vertex--version", version);
        if (!vertex.hasNext()) {
            if (this.graphFactory.isSupportingTransactions()) {
                this.g.tx().rollback();
            }
            log.debug("Vertex with guid is not present {}", (Object)guid);
            return;
        }
        this.g.V(new Object[0]).has("vertex--guid", (Object)guid).drop();
        if (this.graphFactory.isSupportingTransactions()) {
            this.g.tx().commit();
        }
        log.debug("Vertex with guid {} deleted", (Object)guid);
    }

    public void deleteRelationship(String guid) {
        GraphTraversal edge = this.g.E(new Object[0]).has("edge--guid", (Object)guid);
        if (!edge.hasNext()) {
            if (this.graphFactory.isSupportingTransactions()) {
                this.g.tx().rollback();
            }
            log.debug("Edge with guid did not delete {}", (Object)guid);
            return;
        }
        this.g.E(new Object[]{((Edge)edge.next()).id()}).drop();
        if (this.graphFactory.isSupportingTransactions()) {
            this.g.tx().commit();
        }
        log.debug("Edge with guid {} deleted", (Object)guid);
    }

    private void addOrUpdatePropertiesEdge(LineageRelationship lineageRelationship) {
        Map<String, Object> properties = lineageRelationship.getProperties().entrySet().stream().collect(Collectors.toMap(e -> "vertex--InstanceProp" + (String)e.getKey(), Map.Entry::getValue));
        properties.values().remove(null);
        properties.computeIfAbsent("vertex--createTime", val -> lineageRelationship.getCreateTime());
        properties.computeIfAbsent("vertex--createdBy", val -> lineageRelationship.getCreatedBy());
        properties.computeIfAbsent("vertex--updateTime", val -> lineageRelationship.getUpdateTime());
        properties.computeIfAbsent("vertex--updatedBy", val -> lineageRelationship.getUpdatedBy());
        properties.computeIfAbsent("vertex--label", val -> lineageRelationship.getTypeDefName());
        properties.computeIfAbsent("vertex--version", val -> lineageRelationship.getVersion());
        properties.computeIfAbsent("vertex--metadataCollectionId", val -> lineageRelationship.getMetadataCollectionId());
        this.g.inject((Object[])new Map[]{properties}).as("properties", new String[0]).V(new Object[]{lineageRelationship.getSourceEntity().getGuid()}).outE(new String[0]).where((Traversal)__.inV().hasId((Object)lineageRelationship.getTargetEntity().getGuid(), new Object[0])).as("edge", new String[0]).sideEffect((Traversal)__.select((String)"properties").unfold().as("kv", new String[0]).select("edge").property((Object)__.select((String)"kv").by((Function)Column.keys), (Object)__.select((String)"kv").by((Function)Column.values), new Object[0])).iterate();
    }

    private List<Vertex> findPathForOutputAsset(Vertex endingVertex, GraphTraversalSource g, Vertex startingVertex) {
        if (endingVertex == null) {
            return null;
        }
        ArrayList<Vertex> endVertices = new ArrayList<Vertex>();
        try {
            if (this.isEndColumn(g, endingVertex)) {
                endVertices.add(endingVertex);
            } else {
                List nextVertices = g.V(new Object[]{endingVertex.id()}).out(new String[]{"LineageMapping"}).toList();
                for (Vertex vertex : nextVertices) {
                    if (vertex.equals(startingVertex)) continue;
                    Optional.ofNullable(this.findPathForOutputAsset(vertex, g, endingVertex)).ifPresent(endVertices::addAll);
                }
            }
            if (this.graphFactory.isSupportingTransactions()) {
                g.tx().commit();
            }
            return endVertices;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Vertex does not exist with guid {} and display name {}", startingVertex.id(), startingVertex.property("vertex--displayName").value());
            }
            if (this.graphFactory.isSupportingTransactions()) {
                g.tx().rollback();
            }
            return null;
        }
    }

    private boolean isEndColumn(GraphTraversalSource g, Vertex vertex) {
        String VERTEX = "vertex";
        GraphTraversal end = g.V(new Object[]{vertex.id()}).or(new Traversal[]{__.in((String[])new String[]{"AttributeForSchema"}).in(new String[]{"AssetSchemaType"}).has("vertex--label", P.within(Constants.DATA_FILE_AND_SUBTYPES)).store("vertex"), __.in((String[])new String[]{"NestedSchemaAttribute"}).has("vertex--label", (Object)"RelationalTable").store("vertex")}).select("vertex").unfold();
        return end.hasNext();
    }

    public LineageResponse lineage(Scope scope, String guid, String displayNameMustContain, boolean includeProcesses) {
        GraphTraversal vertexGraphTraversal = this.g.V(new Object[0]).has("vertex--guid", (Object)guid);
        if (!vertexGraphTraversal.hasNext()) {
            return new LineageResponse();
        }
        Optional<Object> lineageVerticesAndEdges = Optional.empty();
        switch (scope) {
            case SOURCE_AND_DESTINATION: {
                lineageVerticesAndEdges = this.helper.sourceAndDestination(guid, includeProcesses);
                break;
            }
            case END_TO_END: {
                lineageVerticesAndEdges = this.helper.endToEnd(guid, includeProcesses);
                break;
            }
            case ULTIMATE_SOURCE: {
                lineageVerticesAndEdges = this.helper.ultimateSource(guid, includeProcesses);
                break;
            }
            case ULTIMATE_DESTINATION: {
                lineageVerticesAndEdges = this.helper.ultimateDestination(guid, includeProcesses);
                break;
            }
            case VERTICAL: {
                lineageVerticesAndEdges = this.helper.verticalLineage(guid);
            }
        }
        if (lineageVerticesAndEdges.isPresent() && !displayNameMustContain.isEmpty()) {
            this.helper.filterDisplayName((LineageVerticesAndEdges)lineageVerticesAndEdges.get(), displayNameMustContain);
        }
        return new LineageResponse((LineageVerticesAndEdges)lineageVerticesAndEdges.orElse(null));
    }

    public LineageVertexResponse getEntityDetails(String guid) {
        LineageVertex lineageVertex = this.helper.getLineageVertexByGuid(guid);
        return new LineageVertexResponse(lineageVertex);
    }

    public boolean isEntityInGraph(String guid) {
        return !this.g.V(new Object[0]).has("vertex--guid", (Object)guid).toList().isEmpty();
    }
}

