/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.remote.DriverRemoteConnection;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV3d0;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.AnonymousTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.graphdb.tinkerpop.JanusGraphIoRegistry;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory.IndexingFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphConnectorProvider;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphRemoteConnectorProvider;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.EdgeLabelsLineageGraph;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.VertexLabelsLineageGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphFactory
extends IndexingFactory {
    private static final Logger log = LoggerFactory.getLogger(GraphFactory.class);
    private Graph graph;
    private GraphTraversalSource g;
    private boolean supportingTransactions;
    private Map<String, Object> properties;
    private Cluster cluster;
    private Client client;
    private static final String ADD_VERTEX_LABEL_IF_MISSING_FORMAT = "if (management.getVertexLabel(\"%s\") == null ) { management.makeVertexLabel(\"%s\").make(); }\n";
    private static final String ADD_EDGE_LABEL_IF_MISSING_FORMAT = "if (management.getEdgeLabel(\"%s\") == null ) { management.makeEdgeLabel(\"%s\").make(); }\n";
    private static final String VERTEX = "Vertex";
    private static final String EDGE = "Edge";

    public GraphTraversalSource openGraph(String providerClass, ConnectionProperties connectionProperties, AuditLog auditLog) throws JanusConnectorException {
        this.auditLog = auditLog;
        if (providerClass.equals(LineageGraphConnectorProvider.class.getName())) {
            return this.openEmbeddedGraph(connectionProperties.getConfigurationProperties());
        }
        if (providerClass.equals(LineageGraphRemoteConnectorProvider.class.getName())) {
            return this.openRemoteGraph(connectionProperties.getConfigurationProperties());
        }
        return null;
    }

    private GraphTraversalSource openEmbeddedGraph(Map<String, Object> properties) throws JanusConnectorException {
        String methodName = "openEmbeddedGraph";
        try {
            this.graph = org.apache.tinkerpop.gremlin.structure.util.GraphFactory.open(properties);
            this.g = this.graph.traversal();
            JanusGraph janusGraph = (JanusGraph)this.graph;
            this.initializeGraph(janusGraph);
            this.supportingTransactions = true;
            return this.g;
        }
        catch (Exception e) {
            log.error("A connection with the graph database could not be established with the provided configuration", (Throwable)e);
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.CANNOT_OPEN_GRAPH_DB;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(e.getMessage(), "openEmbeddedGraph", GraphFactory.class.getName());
            throw this.mapConnectorException("openEmbeddedGraph", errorMessage, errorCode);
        }
    }

    private GraphTraversalSource openRemoteGraph(Map<String, Object> properties) throws JanusConnectorException {
        String methodName = "openRemoteGraph";
        this.supportingTransactions = false;
        this.properties = properties;
        try {
            this.cluster = this.createCluster();
            this.client = this.cluster.connect();
            if (properties.get("remote.schemaManagement.enable") != null && properties.get("remote.schemaManagement.enable").toString().equalsIgnoreCase("true")) {
                this.initializeRemoteGraph(this.client);
            }
            return (GraphTraversalSource)AnonymousTraversalSource.traversal().withRemote((RemoteConnection)DriverRemoteConnection.using((Cluster)this.cluster, (String)this.properties.getOrDefault("gremlin.remote.driver.sourceName", "g").toString()));
        }
        catch (Exception e) {
            log.error("A connection with the graph database could not be established with the provided configuration", (Throwable)e);
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.CANNOT_OPEN_GRAPH_DB;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(e.getMessage(), methodName, GraphFactory.class.getName());
            throw this.mapConnectorException(methodName, errorMessage, errorCode);
        }
    }

    private void initializeGraph(JanusGraph janusGraph) throws JanusConnectorException {
        String methodName = "initializeGraph";
        log.debug("Initializing graph. Updating schema, if necessary.");
        try {
            JanusGraphManagement management = janusGraph.openManagement();
            Set<String> vertexLabels = this.schemaBasedOnGraphType(VertexLabelsLineageGraph.class);
            Set<String> relationshipsLabels = this.schemaBasedOnGraphType(EdgeLabelsLineageGraph.class);
            this.checkAndAddLabelVertex(management, vertexLabels);
            this.checkAndAddLabelEdge(management, relationshipsLabels);
            management.commit();
            this.createIndexes(janusGraph);
        }
        catch (Exception e) {
            log.error("{} failed  during graph initialize operation with error: ", (Throwable)e);
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.GRAPH_INITIALIZATION_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(e.getMessage(), "initializeGraph", GraphFactory.class.getName());
            throw this.mapConnectorException("initializeGraph", errorMessage, errorCode);
        }
    }

    private void initializeRemoteGraph(Client client) throws JanusConnectorException {
        String methodName = "initializeRemoteGraph";
        log.debug("Initializing graph remotely. Updating schema, if necessary.");
        try {
            String createLabels = this.createLabelsCommand();
            log.debug("Checking labels...");
            client.submit(createLabels);
            String indexCommandGuid = GraphFactory.createIndexCommand("vertexIndexCompositevertex--guid", "vertex--guid", true, VERTEX);
            String indexCommandLabel = GraphFactory.createIndexCommand("vertexIndexCompositevertex--label", "vertex--label", false, VERTEX);
            String indexCommandVersion = GraphFactory.createIndexCommand("vertexIndexCompositevertex--version", "vertex--version", false, VERTEX);
            String indexCommandMetadataCollectionId = GraphFactory.createIndexCommand("vertexIndexCompositevertex--metadataCollectionId", "vertex--metadataCollectionId", false, VERTEX);
            String indexCommandEdgeGuid = GraphFactory.createIndexCommand("edgeIndexCompositeedge--guid", "edge--guid", false, EDGE);
            String indexCommandEdgeLabel = GraphFactory.createIndexCommand("edgeIndexCompositeedge--label", "edge--label", false, EDGE);
            log.debug("Checking indices...");
            client.submit(indexCommandGuid);
            client.submit(indexCommandLabel);
            client.submit(indexCommandVersion);
            client.submit(indexCommandMetadataCollectionId);
            client.submit(indexCommandEdgeGuid);
            client.submit(indexCommandEdgeLabel);
        }
        catch (Exception e) {
            log.error("{} failed  during graph initialize operation with error: ", (Throwable)e);
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.GRAPH_INITIALIZATION_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(e.getMessage(), "initializeRemoteGraph", GraphFactory.class.getName());
            throw this.mapConnectorException("initializeRemoteGraph", errorMessage, errorCode);
        }
    }

    private <T extends Enum<T>> Set<String> schemaBasedOnGraphType(Class<T> aEnum) {
        return Stream.of(aEnum.getEnumConstants()).map(Enum::name).collect(Collectors.toSet());
    }

    private void checkAndAddLabelVertex(JanusGraphManagement management, Set<String> labels) {
        for (String label : labels) {
            if (management.getVertexLabel(label) != null) continue;
            management.makeVertexLabel(label).make();
        }
    }

    private void checkAndAddLabelEdge(JanusGraphManagement management, Set<String> labels) {
        for (String label : labels) {
            if (management.getEdgeLabel(label) != null) continue;
            management.makeEdgeLabel(label).make();
        }
    }

    private void createIndexes(JanusGraph janusGraph) {
        this.createCompositeIndexForProperty("guid", "vertex--guid", true, janusGraph, Vertex.class);
        this.createCompositeIndexForProperty("label", "vertex--label", false, janusGraph, Vertex.class);
        this.createCompositeIndexForProperty("version", "vertex--version", false, janusGraph, Vertex.class);
        this.createCompositeIndexForProperty("metadataCollectionId", "vertex--metadataCollectionId", false, janusGraph, Vertex.class);
        this.createCompositeIndexForProperty("label", "edge--label", false, janusGraph, Edge.class);
        this.createCompositeIndexForProperty("guid", "edge--guid", false, janusGraph, Edge.class);
    }

    private Cluster createCluster() throws JanusConnectorException {
        String methodName = "createCluster";
        try {
            GryoMapper.Builder builder = GryoMapper.build().addRegistry((IoRegistry)JanusGraphIoRegistry.getInstance());
            Cluster.Builder clusterBuilder = Cluster.build().serializer((MessageSerializer)new GryoMessageSerializerV3d0(builder));
            if (this.properties.get("gremlin.remote.driver.cluster.port") != null) {
                clusterBuilder.port(Integer.parseInt(this.properties.get("gremlin.remote.driver.cluster.port").toString()));
            }
            if (this.properties.get("gremlin.remote.driver.cluster.hosts") != null) {
                String[] hosts = this.properties.get("gremlin.remote.driver.cluster.hosts").toString().split(",");
                clusterBuilder.addContactPoints(hosts);
            }
            if (this.properties.get("gremlin.remote.driver.cluster.credentials.username") != null && this.properties.get("gremlin.remote.driver.cluster.credentials.username") != null) {
                clusterBuilder.credentials(this.properties.get("gremlin.remote.driver.cluster.credentials.username").toString(), this.properties.get("gremlin.remote.driver.cluster.trustStore").toString());
            }
            if (this.properties.get("gremlin.remote.driver.cluster.minConnectionPoolSize") != null) {
                clusterBuilder.minConnectionPoolSize(Integer.parseInt(this.properties.get("gremlin.remote.driver.cluster.minConnectionPoolSize").toString()));
            }
            if (this.properties.get("gremlin.remote.driver.cluster.maxConnectionPoolSize") != null) {
                clusterBuilder.maxConnectionPoolSize(Integer.parseInt(this.properties.get("gremlin.remote.driver.cluster.maxConnectionPoolSize").toString()));
            }
            if (this.properties.get("gremlin.remote.driver.cluster.maxSimultaneousUsagePerConnection") != null) {
                clusterBuilder.maxSimultaneousUsagePerConnection(Integer.parseInt(this.properties.get("gremlin.remote.driver.cluster.maxSimultaneousUsagePerConnection").toString()));
            }
            if (this.properties.get("gremlin.remote.driver.cluster.maxInProcessPerConnection") != null) {
                clusterBuilder.maxInProcessPerConnection(Integer.parseInt(this.properties.get("gremlin.remote.driver.cluster.maxInProcessPerConnection").toString()));
            }
            if (this.properties.get("gremlin.remote.driver.cluster.ssl.enable") != null && this.properties.get("gremlin.remote.driver.cluster.ssl.enable").toString().equalsIgnoreCase("true")) {
                clusterBuilder.enableSsl(true);
                if (this.properties.get("gremlin.remote.driver.cluster.keyStoreType") != null) {
                    clusterBuilder.keyStoreType(this.properties.get("gremlin.remote.driver.cluster.keyStoreType").toString());
                }
                if (this.properties.get("gremlin.remote.driver.cluster.keyStore") != null) {
                    clusterBuilder.keyStore(this.properties.get("gremlin.remote.driver.cluster.keyStore").toString());
                }
                if (this.properties.get("gremlin.remote.driver.cluster.keyStorePassword") != null) {
                    clusterBuilder.keyStorePassword(this.properties.get("gremlin.remote.driver.cluster.keyStorePassword").toString());
                }
                if (this.properties.get("gremlin.remote.driver.cluster.sslSkipCertValidation") != null) {
                    clusterBuilder.sslSkipCertValidation(this.properties.get("gremlin.remote.driver.cluster.sslSkipCertValidation").toString().equalsIgnoreCase("true"));
                }
                if (this.properties.get("gremlin.remote.driver.cluster.trustStore") != null) {
                    clusterBuilder.trustStore(this.properties.get("gremlin.remote.driver.cluster.trustStore").toString());
                }
                if (this.properties.get("gremlin.remote.driver.cluster.trustStorePassword") != null) {
                    clusterBuilder.trustStorePassword(this.properties.get("gremlin.remote.driver.cluster.trustStorePassword").toString());
                }
            }
            return clusterBuilder.create();
        }
        catch (Exception e) {
            log.error("Cluster initiation for remote connection to the graph  failed with error: ", (Throwable)e);
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.GRAPH_CLUSTER_INIT_FAILED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(e.getMessage(), methodName, GraphFactory.class.getName());
            throw this.mapConnectorException(methodName, errorMessage, errorCode);
        }
    }

    private String createLabelsCommand() {
        StringBuilder managementCommand = new StringBuilder();
        managementCommand.append("JanusGraphManagement management = graph.openManagement();\n");
        for (VertexLabelsLineageGraph vertexLabelsLineageGraph : VertexLabelsLineageGraph.values()) {
            managementCommand.append(String.format(ADD_VERTEX_LABEL_IF_MISSING_FORMAT, new Object[]{vertexLabelsLineageGraph, vertexLabelsLineageGraph}));
        }
        for (Enum enum_ : EdgeLabelsLineageGraph.values()) {
            managementCommand.append(String.format(ADD_EDGE_LABEL_IF_MISSING_FORMAT, enum_, enum_));
        }
        managementCommand.append("management.commit();");
        return managementCommand.toString();
    }

    private static String createIndexCommand(String indexName, String propertyName, boolean hasPropertyUniqueAndConsistency, String className) {
        StringBuilder indexCommand = new StringBuilder();
        indexCommand.append("management = graph.openManagement();\n");
        indexCommand.append("vertexIndex = management.getGraphIndex(\"").append(indexName).append("\");\n");
        indexCommand.append("if (vertexIndex != null ){   management.rollback(); }\n");
        indexCommand.append(" else { ");
        indexCommand.append("propertyKeyGuid = management.makePropertyKey(\"").append(propertyName).append("\").dataType(String.class).make();\n");
        indexCommand.append("indexBuilderGuidVertex = management.buildIndex(\"").append(indexName).append("\", ").append(className).append(".class).addKey(propertyKeyGuid);\n");
        if (hasPropertyUniqueAndConsistency) {
            indexCommand.append("indexBuilderGuidVertex.unique();\n");
        }
        indexCommand.append("indexGuidVertex = indexBuilderGuidVertex.buildCompositeIndex();\n");
        if (hasPropertyUniqueAndConsistency) {
            indexCommand.append("management.setConsistency(indexGuidVertex, ConsistencyModifier.LOCK);\n");
        }
        indexCommand.append("management.commit();\n");
        indexCommand.append("management = graph.openManagement();\n");
        indexCommand.append("ManagementSystem.awaitGraphIndexStatus(graph,\"").append(indexName).append("\").timeout(15, ChronoUnit.SECONDS).call();\n");
        indexCommand.append("management.updateIndex(management.getGraphIndex(\"").append(indexName).append("\"), SchemaAction.REINDEX).get();\n");
        indexCommand.append("management.commit();\n");
        indexCommand.append("}\n");
        return indexCommand.toString();
    }

    public void closeGraph() {
        try {
            if (this.g != null) {
                this.g.close();
            }
            if (this.graph != null) {
                this.graph.close();
            }
            if (this.cluster != null) {
                this.cluster.close();
            }
        }
        catch (Exception e) {
            log.error("Exception while closing the graph.", (Throwable)e);
        }
        finally {
            this.g = null;
            this.graph = null;
            this.client = null;
            this.cluster = null;
        }
    }

    public boolean isSupportingTransactions() {
        return this.supportingTransactions;
    }

    private JanusConnectorException mapConnectorException(String methodName, String errorMessage, JanusConnectorErrorCode errorCode) {
        return new JanusConnectorException(GraphFactory.class.getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

