/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageEdge;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.GraphConstants;

public class LineageGraphConnectorHelper {
    private GraphTraversalSource g;
    private String[] glossaryTermAndClassificationEdges = new String[]{"SemanticAssignment", "RelatedTerm", "Synonym", "Antonym", "ReplacementTerm", "Translation", "ISARelationship", "Classification", "TermCategorization"};
    private String[] relationalColumnAndClassificationEdges = new String[]{"NestedSchemaAttribute", "Classification", "SemanticAssignment"};
    private String[] tabularColumnAndClassificationEdges = new String[]{"AttributeForSchema", "Classification", "SemanticAssignment"};

    public LineageGraphConnectorHelper(GraphTraversalSource graphTraversalSource) {
        this.g = graphTraversalSource;
    }

    public Optional<LineageVerticesAndEdges> ultimateSource(String guid, boolean includeProcesses) {
        Optional<String> edgeLabelOptional = this.getEdgeLabelForDataFlow((Vertex)this.g.V(new Object[0]).has("vertex--guid", (Object)guid).next());
        if (!edgeLabelOptional.isPresent()) {
            return Optional.empty();
        }
        String edgeLabel = edgeLabelOptional.get();
        Graph sourceGraph = (Graph)this.g.V(new Object[0]).has("vertex--guid", (Object)guid).until((Traversal)__.inE((String[])new String[]{edgeLabel}).count().is((Object)0)).repeat((Traversal)__.inE((String[])new String[]{edgeLabel}).subgraph("subGraph").outV().simplePath()).cap("subGraph", new String[0]).next();
        List sourcesList = this.g.V(new Object[0]).has("vertex--guid", (Object)guid).until((Traversal)__.inE((String[])new String[]{edgeLabel}).count().is((Object)0)).repeat((Traversal)__.inE((String[])new String[]{edgeLabel}).outV().simplePath()).dedup(new String[0]).toList();
        return Optional.of(this.getCondensedLineage(guid, this.g, sourceGraph, this.getLineageVertices(sourcesList), "source", includeProcesses));
    }

    public Optional<LineageVerticesAndEdges> ultimateDestination(String guid, boolean includeProcesses) {
        Optional<String> edgeLabelOptional = this.getEdgeLabelForDataFlow((Vertex)this.g.V(new Object[0]).has("vertex--guid", (Object)guid).next());
        if (!edgeLabelOptional.isPresent()) {
            return Optional.empty();
        }
        String edgeLabel = edgeLabelOptional.get();
        Graph destinationGraph = (Graph)this.g.V(new Object[0]).has("vertex--guid", (Object)guid).until((Traversal)__.outE((String[])new String[]{edgeLabel}).count().is((Object)0)).repeat((Traversal)__.outE((String[])new String[]{edgeLabel}).subgraph("subGraph").inV().simplePath()).cap("subGraph", new String[0]).next();
        List destinationsList = this.g.V(new Object[0]).has("vertex--guid", (Object)guid).until((Traversal)__.outE((String[])new String[]{edgeLabel}).count().is((Object)0)).repeat((Traversal)__.outE((String[])new String[]{edgeLabel}).inV().simplePath()).dedup(new String[0]).toList();
        return Optional.of(this.getCondensedLineage(guid, this.g, destinationGraph, this.getLineageVertices(destinationsList), "destination", includeProcesses));
    }

    public Optional<LineageVerticesAndEdges> endToEnd(String guid, boolean includeProcesses) {
        Optional<String> edgeLabelOptional = this.getEdgeLabelForDataFlow((Vertex)this.g.V(new Object[0]).has("vertex--guid", (Object)guid).next());
        if (!edgeLabelOptional.isPresent()) {
            return Optional.empty();
        }
        String edgeLabel = edgeLabelOptional.get();
        Graph endToEndGraph = (Graph)this.g.V(new Object[0]).has("vertex--guid", (Object)guid).union(new Traversal[]{__.until((Traversal)__.inE((String[])new String[]{edgeLabel}).count().is((Object)0)).repeat((Traversal)__.inE((String[])new String[]{edgeLabel}).subgraph("subGraph").outV().simplePath()), __.until((Traversal)__.outE((String[])new String[]{edgeLabel}).count().is((Object)0)).repeat((Traversal)__.outE((String[])new String[]{edgeLabel}).subgraph("subGraph").inV().simplePath())}).cap("subGraph", new String[0]).next();
        return Optional.of(this.getLineageVerticesAndEdges(endToEndGraph, includeProcesses));
    }

    public Optional<LineageVerticesAndEdges> sourceAndDestination(String guid, boolean includeProcesses) {
        Optional<LineageVerticesAndEdges> ultimateSourceResponse = this.ultimateSource(guid, includeProcesses);
        Optional<LineageVerticesAndEdges> ultimateDestinationResponse = this.ultimateDestination(guid, includeProcesses);
        if (ultimateSourceResponse.isPresent() && ultimateDestinationResponse.isPresent()) {
            Set sourceAndDestinationVertices = Stream.concat(ultimateSourceResponse.get().getLineageVertices().stream(), ultimateDestinationResponse.get().getLineageVertices().stream()).collect(Collectors.toSet());
            Set sourceAndDestinationEdges = Stream.concat(ultimateSourceResponse.get().getLineageEdges().stream(), ultimateDestinationResponse.get().getLineageEdges().stream()).collect(Collectors.toSet());
            return Optional.of(new LineageVerticesAndEdges(sourceAndDestinationVertices, sourceAndDestinationEdges));
        }
        if (ultimateSourceResponse.isPresent()) {
            return ultimateSourceResponse;
        }
        if (ultimateDestinationResponse.isPresent()) {
            return ultimateDestinationResponse;
        }
        return Optional.empty();
    }

    private Optional<LineageVerticesAndEdges> glossaryVerticalLineage(String guid) {
        Graph subGraph = (Graph)this.g.V(new Object[0]).has("vertex--guid", (Object)guid).bothE(this.glossaryTermAndClassificationEdges).subgraph("s").cap("s", new String[0]).next();
        return Optional.of(this.getLineageVerticesAndEdges(subGraph, false));
    }

    private Optional<LineageVerticesAndEdges> relationalColumnVerticalLineage(String guid) {
        Graph subGraph = (Graph)this.g.V(new Object[0]).has("vertex--guid", (Object)guid).bothE(this.relationalColumnAndClassificationEdges).subgraph("s").cap("s", new String[0]).next();
        return Optional.of(this.getLineageVerticesAndEdges(subGraph, false));
    }

    private Optional<LineageVerticesAndEdges> tabularColumnVerticalLineage(String guid) {
        Graph subGraph = (Graph)this.g.V(new Object[0]).has("vertex--guid", (Object)guid).bothE(this.tabularColumnAndClassificationEdges).subgraph("s").bothV().inE(new String[]{"AssetSchemaType"}).subgraph("s").cap("s", new String[0]).next();
        return Optional.of(this.getLineageVerticesAndEdges(subGraph, false));
    }

    public Optional<LineageVerticesAndEdges> verticalLineage(String guid) {
        String label;
        switch (label = (String)this.g.V(new Object[0]).has("vertex--guid", (Object)guid).label().next()) {
            case "GlossaryTerm": {
                return this.glossaryVerticalLineage(guid);
            }
            case "RelationalColumn": {
                return this.relationalColumnVerticalLineage(guid);
            }
            case "TabularColumn": {
                return this.tabularColumnVerticalLineage(guid);
            }
        }
        return Optional.empty();
    }

    void filterDisplayName(LineageVerticesAndEdges lineageVerticesAndEdges, String displayNameMustContain) {
        Set lineageVertices = lineageVerticesAndEdges.getLineageVertices();
        Set lineageEdges = lineageVerticesAndEdges.getLineageEdges();
        HashSet<LineageVertex> verticesToBeRemoved = new HashSet<LineageVertex>();
        HashSet<LineageEdge> edgesToBeRemoved = new HashSet<LineageEdge>();
        for (LineageVertex vertex : lineageVertices) {
            String nodeID = vertex.getNodeID();
            if (vertex.getDisplayName().contains(displayNameMustContain)) continue;
            verticesToBeRemoved.add(vertex);
            for (LineageEdge edge : lineageEdges) {
                if (!edge.getSourceNodeID().equals(nodeID) && !edge.getDestinationNodeID().equals(nodeID)) continue;
                edgesToBeRemoved.add(edge);
            }
        }
        lineageVertices.removeAll(verticesToBeRemoved);
        lineageEdges.removeAll(edgesToBeRemoved);
        lineageVerticesAndEdges.setLineageVertices(lineageVertices);
        lineageVerticesAndEdges.setLineageEdges(lineageEdges);
    }

    private LineageVerticesAndEdges getCondensedLineage(String guid, GraphTraversalSource g, Graph subGraph, Set<LineageVertex> ultimateVertices, String condensationType, boolean includeProcesses) {
        Set<LineageVertex> lineageVertices = this.getLineageVertices(subGraph);
        Set<LineageEdge> lineageEdges = this.getLineageEdges(subGraph, "source".equalsIgnoreCase(condensationType));
        Vertex originalQueriedVertex = (Vertex)g.V(new Object[0]).has("vertex--guid", (Object)guid).next();
        LineageVertex queriedVertex = this.abstractVertex(originalQueriedVertex);
        if (CollectionUtils.isEmpty(lineageVertices)) {
            lineageVertices = ultimateVertices;
        }
        this.addCondensation(lineageVertices, lineageEdges, ultimateVertices, queriedVertex, condensationType);
        this.condenseProcesses(includeProcesses, lineageVertices, lineageEdges);
        this.addColumnProperties(lineageVertices);
        return new LineageVerticesAndEdges(lineageVertices, lineageEdges);
    }

    private LineageVertex abstractVertex(Vertex originalVertex) {
        String displayName;
        String nodeType = originalVertex.label();
        String nodeID = this.getNodeID(originalVertex);
        LineageVertex lineageVertex = new LineageVertex(nodeID, nodeType);
        if (originalVertex.property("vertex--displayName").isPresent()) {
            displayName = originalVertex.property("vertex--displayName").value().toString();
            lineageVertex.setDisplayName(displayName);
        } else if (originalVertex.property("vertex--InstancePropdisplayName").isPresent()) {
            displayName = originalVertex.property("vertex--InstancePropdisplayName").value().toString();
            lineageVertex.setDisplayName(displayName);
        } else if (originalVertex.property("vertex--label").isPresent()) {
            displayName = originalVertex.property("vertex--label").value().toString();
            lineageVertex.setDisplayName(displayName);
        } else {
            lineageVertex.setDisplayName("undefined");
        }
        if (originalVertex.property("vertex--guid").isPresent()) {
            String guid = originalVertex.property("vertex--guid").value().toString();
            lineageVertex.setGuid(guid);
        }
        if ("subProcess".equals(nodeType) && originalVertex.property("processGuid").isPresent()) {
            lineageVertex.setGuid(originalVertex.property("processGuid").value().toString());
            lineageVertex.setNodeID(originalVertex.property("processGuid").value().toString());
        }
        Map<String, String> properties = this.retrieveProperties(originalVertex);
        lineageVertex.setProperties(properties);
        return lineageVertex;
    }

    private String getNodeID(Vertex vertex) {
        String nodeID = vertex.label().equalsIgnoreCase("subProcess") ? vertex.property("processGuid").value().toString() : vertex.property("vertex--guid").value().toString();
        return nodeID;
    }

    private Map<String, String> retrieveProperties(Vertex vertex) {
        boolean isClassificationVertex = vertex.edges(Direction.IN, new String[]{"Classification"}).hasNext();
        HashMap<String, String> newNodeProperties = new HashMap<String, String>();
        Iterator originalProperties = vertex.properties(new String[0]);
        while (originalProperties.hasNext()) {
            Property originalProperty = (Property)originalProperties.next();
            if (!GraphConstants.immutableReturnedPropertiesWhiteList.contains((Object)originalProperty.key()) && !isClassificationVertex) continue;
            String newPropertyKey = originalProperty.key().replace("vertex--InstanceProp", "").replace("vertex--", "");
            String newPropertyValue = originalProperty.value().toString();
            newNodeProperties.put(newPropertyKey, newPropertyValue);
        }
        return newNodeProperties;
    }

    private void addCondensation(Set<LineageVertex> lineageVertices, Set<LineageEdge> lineageEdges, Set<LineageVertex> ultimateVertices, LineageVertex queriedVertex, String condensationType) {
        long subProcessVerticesNo = lineageVertices.stream().filter(this::isSubProcess).count();
        if (subProcessVerticesNo > 1L) {
            Set<LineageVertex> verticesToRemove = this.getLineageVerticesToRemove(lineageVertices, lineageEdges, ultimateVertices, queriedVertex);
            lineageVertices.removeAll(verticesToRemove);
            Set<LineageEdge> edgesToRemove = this.getLineageEdgesToRemove(lineageEdges, verticesToRemove);
            lineageEdges.removeAll(edgesToRemove);
            LineageVertex condensedVertex = new LineageVertex(this.getCondensedNodeId(condensationType), "condensedNode");
            condensedVertex.setDisplayName("...");
            lineageVertices.add(condensedVertex);
            LineageEdge sourceEdge = new LineageEdge("condensed", queriedVertex.getNodeID(), condensedVertex.getNodeID());
            lineageEdges.add(sourceEdge);
            ultimateVertices.forEach(ultimateVertex -> lineageEdges.add(new LineageEdge("condensed", condensedVertex.getNodeID(), ultimateVertex.getNodeID())));
        }
    }

    private LineageVerticesAndEdges getLineageVerticesAndEdges(Graph subGraph, boolean includeProcesses) {
        Set<LineageVertex> lineageVertices = this.getLineageVertices(subGraph);
        Set<LineageEdge> lineageEdges = this.getLineageEdges(subGraph, false);
        this.condenseProcesses(includeProcesses, lineageVertices, lineageEdges);
        this.addColumnProperties(lineageVertices);
        return new LineageVerticesAndEdges(lineageVertices, lineageEdges);
    }

    private Set<LineageVertex> getLineageVerticesToRemove(Set<LineageVertex> lineageVertices, Set<LineageEdge> lineageEdges, Set<LineageVertex> ultimateVertices, LineageVertex queriedVertex) {
        HashSet<LineageVertex> verticesToRemove = new HashSet<LineageVertex>();
        lineageVertices.stream().filter(lineageVertex -> this.isVertexToBeCondensed((LineageVertex)lineageVertex, queriedVertex, ultimateVertices, lineageEdges)).forEach(verticesToRemove::add);
        return verticesToRemove;
    }

    private boolean isVertexToBeCondensed(LineageVertex lineageVertex, LineageVertex queriedVertex, Set<LineageVertex> ultimateVertices, Set<LineageEdge> lineageEdges) {
        return !queriedVertex.getGuid().equalsIgnoreCase(lineageVertex.getGuid()) && !ultimateVertices.contains(lineageVertex);
    }

    private Set<LineageEdge> getLineageEdgesToRemove(Set<LineageEdge> lineageEdges, Set<LineageVertex> verticesToRemove) {
        Set verticesToRemoveIDs = verticesToRemove.stream().map(LineageVertex::getNodeID).collect(Collectors.toSet());
        return lineageEdges.stream().filter(edge -> this.isInVertexesToRemove(verticesToRemoveIDs, (LineageEdge)edge)).collect(Collectors.toSet());
    }

    private Set<LineageEdge> getLineageEdges(Graph subGraph, boolean invertedEdges) {
        Iterator originalEdges = subGraph.edges(new Object[0]);
        HashSet<LineageEdge> lineageEdges = new HashSet<LineageEdge>();
        while (originalEdges.hasNext()) {
            Edge next = (Edge)originalEdges.next();
            LineageEdge newLineageEdge = new LineageEdge(next.label(), this.getNodeID(next.outVertex()), this.getNodeID(next.inVertex()));
            lineageEdges.add(newLineageEdge);
        }
        return lineageEdges;
    }

    private Set<LineageVertex> getLineageVertices(Graph subGraph) {
        Iterator originalVertices = subGraph.vertices(new Object[0]);
        LinkedHashSet<LineageVertex> lineageVertices = new LinkedHashSet<LineageVertex>();
        while (originalVertices.hasNext()) {
            LineageVertex newVertex = this.abstractVertex((Vertex)originalVertices.next());
            lineageVertices.add(newVertex);
        }
        return lineageVertices;
    }

    private Set<LineageVertex> getLineageVertices(List<Vertex> vertexList) {
        HashSet<LineageVertex> lineageVertices = new HashSet<LineageVertex>();
        vertexList.forEach(vertex -> lineageVertices.add(this.abstractVertex((Vertex)vertex)));
        return lineageVertices;
    }

    private void condenseProcesses(boolean includeProcesses, Set<LineageVertex> lineageVertices, Set<LineageEdge> lineageEdges) {
        if (!includeProcesses) {
            Set verticesToRemove = lineageVertices.stream().filter(this::isSubProcess).collect(Collectors.toSet());
            Set<String> verticesToRemoveIDs = verticesToRemove.stream().map(LineageVertex::getNodeID).collect(Collectors.toSet());
            Set edgesToRemove = lineageEdges.stream().filter(edge -> this.isInVertexesToRemove(verticesToRemoveIDs, (LineageEdge)edge)).collect(Collectors.toSet());
            List<LineageEdge> edgesToReplaceProcesses = this.createEdgesThatReplaceProcesses(lineageEdges, verticesToRemoveIDs);
            lineageEdges.addAll(edgesToReplaceProcesses);
            lineageEdges.removeAll(edgesToRemove);
            lineageVertices.removeAll(verticesToRemove);
        }
    }

    private List<LineageEdge> createEdgesThatReplaceProcesses(Set<LineageEdge> lineageEdges, Set<String> verticesToRemoveNames) {
        ArrayList<LineageEdge> edgesToReplaceProcesses = new ArrayList<LineageEdge>();
        for (String vertexName : verticesToRemoveNames) {
            for (LineageEdge edge : lineageEdges) {
                if (!edge.getDestinationNodeID().equalsIgnoreCase(vertexName)) continue;
                for (LineageEdge destinationEdge : lineageEdges) {
                    if (!destinationEdge.getSourceNodeID().equalsIgnoreCase(vertexName)) continue;
                    edgesToReplaceProcesses.add(new LineageEdge("condensed", edge.getSourceNodeID(), destinationEdge.getDestinationNodeID()));
                }
            }
        }
        return edgesToReplaceProcesses;
    }

    private boolean isSubProcess(LineageVertex vertex) {
        return vertex.getNodeType().equalsIgnoreCase("subProcess");
    }

    private boolean isInVertexesToRemove(Set<String> verticesToRemoveNames, LineageEdge edge) {
        return verticesToRemoveNames.contains(edge.getSourceNodeID()) || verticesToRemoveNames.contains(edge.getDestinationNodeID());
    }

    private void addColumnProperties(Set<LineageVertex> lineageVertices) {
        if (CollectionUtils.isEmpty(lineageVertices)) {
            return;
        }
        lineageVertices.stream().filter(this::isColumn).forEach(lineageVertex -> {
            Vertex graphVertex = (Vertex)this.g.V(new Object[0]).has("vertex--guid", (Object)lineageVertex.getGuid()).next();
            Object vertexId = graphVertex.id();
            Map<Object, Object> properties = new HashMap();
            switch (lineageVertex.getNodeType()) {
                case "TabularColumn": {
                    properties = this.getDataFileProperties(this.g, vertexId);
                    break;
                }
                case "RelationalColumn": {
                    properties = this.getRelationalTableProperties(this.g, vertexId);
                }
            }
            lineageVertex.setProperties(properties);
        });
    }

    private Map<String, String> getRelationalTableProperties(GraphTraversalSource g, Object vertexId) {
        GraphTraversal connection;
        GraphTraversal database;
        GraphTraversal deployedDatabaseSchema;
        GraphTraversal relationalDBSchemaType;
        HashMap<String, String> properties = new HashMap<String, String>();
        GraphTraversal tableAsset = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"RelationalTable", (String[])new String[0])});
        if (tableAsset.hasNext()) {
            properties.put("vertex--tableDisplayName", ((Vertex)tableAsset.next()).property("vertex--InstancePropdisplayName").value().toString());
        }
        if ((relationalDBSchemaType = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).outV().simplePath()).times(2).or(new Traversal[]{__.hasLabel((String)"RelationalDBSchemaType", (String[])new String[0])})).hasNext()) {
            properties.put("vertex--schemaTypeDisplayName", ((Vertex)relationalDBSchemaType.next()).property("vertex--InstancePropdisplayName").value().toString());
        }
        if ((deployedDatabaseSchema = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).outV().simplePath()).times(3).or(new Traversal[]{__.hasLabel((String)"DeployedDatabaseSchema", (String[])new String[0])})).hasNext()) {
            properties.put("vertex--databaseSchemaDisplayName", ((Vertex)deployedDatabaseSchema.next()).property("vertex--InstancePropdisplayName").value().toString());
        }
        if ((database = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).outV().simplePath()).times(4).or(new Traversal[]{__.hasLabel((String)"Database", (String[])new String[0])})).hasNext()) {
            properties.put("vertex--databaseDisplayName", ((Vertex)database.next()).property("vertex--InstancePropdisplayName").value().toString());
        }
        if ((connection = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).outV().simplePath()).times(5).hasLabel("Connection", new String[0])).hasNext()) {
            properties.put("vertex--connectionDisplayName", ((Vertex)connection.next()).property("vertex--InstancePropdisplayName").value().toString());
        }
        return properties;
    }

    private Map<String, String> getDataFileProperties(GraphTraversalSource g, Object vertexId) {
        GraphTraversal dataFileAsset;
        HashMap<String, String> properties = new HashMap<String, String>();
        GraphTraversal tabularSchemaType = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).outV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"TabularSchemaType", (String[])new String[0])});
        if (tabularSchemaType.hasNext()) {
            properties.put("vertex--schemaTypeDisplayName", ((Vertex)tabularSchemaType.next()).property("vertex--InstancePropdisplayName").value().toString());
        }
        if ((dataFileAsset = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(2).or(new Traversal[]{__.hasLabel((String)"DataFile", (String[])new String[0])})).hasNext()) {
            Vertex dataFileVertex = (Vertex)dataFileAsset.next();
            properties.put("vertex--tableDisplayName", dataFileVertex.property("vertex--InstancePropdisplayName").value().toString());
            List<Vertex> folderVertices = this.getFolderVertices(g, dataFileVertex);
            if (CollectionUtils.isEmpty(folderVertices)) {
                return properties;
            }
            Object lastFolderVertexId = folderVertices.get(folderVertices.size() - 1).id();
            GraphTraversal connection = g.V(new Object[]{lastFolderVertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"Connection", (String[])new String[0])});
            if (connection.hasNext()) {
                properties.put("vertex--connectionDisplayName", ((Vertex)connection.next()).property("vertex--InstancePropdisplayName").value().toString());
            }
            properties.put("vertex--path", String.join((CharSequence)"/", this.getFoldersPath(folderVertices)));
        }
        return properties;
    }

    private String getFoldersPath(List<Vertex> folderVertices) {
        Collections.reverse(folderVertices);
        return folderVertices.stream().map(folderVertex -> folderVertex.property("vertex--InstancePropdisplayName").value().toString()).collect(Collectors.joining("/"));
    }

    private List<Vertex> getFolderVertices(GraphTraversalSource g, Vertex dataFileAsset) {
        GraphTraversal fileFolders = g.V(new Object[]{dataFileAsset.id()}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).until((Traversal)__.inE((String[])new String[]{"FolderHierarchy"}).count().is((Object)0)).or(new Traversal[]{__.hasLabel((String)"FileFolder", (String[])new String[0])});
        ArrayList<Vertex> folderVertices = new ArrayList<Vertex>();
        while (fileFolders.hasNext()) {
            folderVertices.add((Vertex)fileFolders.next());
        }
        return folderVertices;
    }

    private boolean isColumn(LineageVertex lineageVertex) {
        return Arrays.asList("TabularColumn", "RelationalColumn").contains(lineageVertex.getNodeType());
    }

    private String getCondensedNodeId(String condensationType) {
        if ("source".equalsIgnoreCase(condensationType)) {
            return "condensedSource";
        }
        return "condensedDestination";
    }

    private Optional<String> getEdgeLabelForDataFlow(Vertex queriedVertex) {
        String queriedNodeType;
        switch (queriedNodeType = queriedVertex.label()) {
            case "TabularColumn": 
            case "RelationalColumn": {
                return Optional.of("ColumnDataFlow");
            }
            case "DataFile": 
            case "RelationalTable": {
                return Optional.of("TableDataFlow");
            }
        }
        return Optional.empty();
    }
}

