/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory;

import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphGremlinBase {
    private static final Logger log = LoggerFactory.getLogger(GraphGremlinBase.class);
    protected Graph graph;
    protected GraphTraversalSource g;
    protected boolean supportingTransactions;
    protected Map<String, Object> properties;

    public GraphGremlinBase(ConnectionProperties connectionProperties) {
        this.properties = connectionProperties.getConfigurationProperties();
    }

    public GraphTraversalSource openGraph() {
        log.debug("Trying to open the graph");
        try {
            this.graph = GraphFactory.open(this.properties);
            this.g = this.graph.traversal();
            return this.g;
        }
        catch (Exception e) {
            log.debug("exception: ", (Throwable)e);
            throw new RuntimeException();
        }
    }

    public void closeGraph() throws Exception {
        log.debug("closing graph");
        try {
            if (this.g != null) {
                this.g.close();
            }
            if (this.graph != null) {
                this.graph.close();
            }
        }
        finally {
            this.g = null;
            this.graph = null;
        }
    }

    public void dropGraph() throws Exception {
    }

    protected void createSchema() {
    }

    public void updateElements() {
    }

    public boolean isSupportingTransactions() {
        return this.supportingTransactions;
    }
}

