/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory;

import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.IndexProperties;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.EdgeLabelsLineageGraph;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.GraphConstants;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.VertexLabelsLineageGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLineageSchemaHelper<C extends Element> {
    private static final Logger log = LoggerFactory.getLogger(OpenLineageSchemaHelper.class);
    private static final String AWAIT_GRAPH_INDEX_STATUS_ENABLED = "{} awaitGraphIndexStatus ENABLED for {}";
    private static final String CAUGHT_INTERRUPTED_EXCEPTION_MESSAGE = "caught interrupted exception from awaitGraphIndexStatus";
    private static final String CAUGHT_INTERRUPTED_EXCEPTION = "{} caught interrupted exception from awaitGraphIndexStatus ENABLED {}";
    private static final String VERTEX = "Vertex";
    private static final String EDGE = "Edge";
    private static final String ADD_VERTEX_LABEL_IF_MISSING_FORMAT = "if (management.getVertexLabel(\"%s\") == null ) { management.makeVertexLabel(\"%s\").make(); }\n";
    private static final String ADD_EDGE_LABEL_IF_MISSING_FORMAT = "if (management.getEdgeLabel(\"%s\") == null ) { management.makeEdgeLabel(\"%s\").make(); }\n";
    AuditLog auditLog;

    public void createSchemas(JanusGraph janusGraph) {
        JanusGraphManagement management = janusGraph.openManagement();
        Set<String> vertexLabels = this.schemaBasedOnGraphType(VertexLabelsLineageGraph.class);
        Set<String> relationshipsLabels = this.schemaBasedOnGraphType(EdgeLabelsLineageGraph.class);
        this.checkAndAddLabelVertex(management, vertexLabels);
        this.checkAndAddLabelEdge(management, relationshipsLabels);
        management.commit();
    }

    private <T extends Enum<T>> Set<String> schemaBasedOnGraphType(Class<T> aEnum) {
        return Stream.of((Enum[])aEnum.getEnumConstants()).map(Enum::name).collect(Collectors.toSet());
    }

    private void checkAndAddLabelVertex(JanusGraphManagement management, Set<String> labels) {
        for (String label : labels) {
            if (management.getVertexLabel(label) != null) continue;
            management.makeVertexLabel(label).make();
        }
    }

    private void checkAndAddLabelEdge(JanusGraphManagement management, Set<String> labels) {
        for (String label : labels) {
            if (management.getEdgeLabel(label) != null) continue;
            management.makeEdgeLabel(label).make();
        }
    }

    public void createIndexes(JanusGraph janusGraph) {
        this.createCompositeIndexForProperty(janusGraph, new IndexProperties("guid", "vertex--guid", true, Vertex.class));
        this.createCompositeIndexForProperty(janusGraph, new IndexProperties("label", "vertex--label", false, Vertex.class));
        this.createCompositeIndexForProperty(janusGraph, new IndexProperties("ASSET_LINEAGE_VARIABLES", "ASSET_LINEAGE_VARIABLES", false, Vertex.class));
        this.createCompositeIndexForProperty(janusGraph, new IndexProperties("version", "vertex--version", false, Vertex.class));
        this.createCompositeIndexForProperty(janusGraph, new IndexProperties("metadataCollectionId", "vertex--metadataCollectionId", false, Vertex.class));
        this.createCompositeIndexForProperty(janusGraph, new IndexProperties("label", "edge--label", false, Edge.class));
        this.createCompositeIndexForProperty(janusGraph, new IndexProperties("guid", "edge--guid", false, Edge.class));
    }

    protected void createCompositeIndexForProperty(JanusGraph graph, IndexProperties indexProperties) {
        String indexName = null;
        if (Vertex.class.equals((Object)indexProperties.getType())) {
            indexName = "vertexIndexComposite" + indexProperties.getPropertyKeyName();
        } else if (Edge.class.equals((Object)indexProperties.getType())) {
            indexName = "edgeIndexComposite" + indexProperties.getPropertyKeyName();
        }
        log.debug("INDEX to be created {}", (Object)indexName);
        this.checkIndex(graph, indexName, indexProperties);
    }

    private void checkIndex(JanusGraph graph, String indexName, IndexProperties indexProperties) {
        JanusGraphManagement management = graph.openManagement();
        JanusGraphIndex existingIndex = management.getGraphIndex(indexName);
        if (existingIndex != null) {
            log.debug("{} index already exists", (Object)indexName);
            if (this.auditLog != null) {
                this.auditLog.logMessage(indexName + " index already exists", JanusConnectorErrorCode.INDEX_ALREADY_EXISTS.getMessageDefinition());
            }
            management.rollback();
            return;
        }
        this.createIndex(graph, management, indexName, indexProperties);
    }

    private void createIndex(JanusGraph graph, JanusGraphManagement management, String indexName, IndexProperties indexProperties) {
        PropertyKey propertyKey;
        Class<?> clazz;
        String className = (String)GraphConstants.immutableCorePropertyTypes.get((Object)indexProperties.getPropertyName());
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.error("class not found for property {}", (Object)indexProperties.getPropertyName());
            log.error("NO INDEX created for property {}", (Object)indexProperties.getPropertyName());
            this.auditLog.logMessage("class not found for property " + indexProperties.getPropertyName(), JanusConnectorErrorCode.INDEX_NOT_CREATED.getMessageDefinition());
            return;
        }
        boolean oldKey = false;
        PropertyKey existingPropertyKey = management.getPropertyKey(indexProperties.getPropertyKeyName());
        if (existingPropertyKey != null) {
            log.debug("property key already exists for property {}", (Object)indexProperties.getPropertyKeyName());
            propertyKey = existingPropertyKey;
            oldKey = true;
        } else {
            log.debug("make property key for property {}", (Object)indexProperties.getPropertyKeyName());
            propertyKey = management.makePropertyKey(indexProperties.getPropertyKeyName()).dataType(clazz).make();
        }
        this.buildIndex(graph, management, indexName, propertyKey, oldKey, indexProperties);
    }

    private void buildIndex(JanusGraph graph, JanusGraphManagement management, String indexName, PropertyKey propertyKey, boolean oldKey, IndexProperties indexProperties) {
        if (indexProperties.getType().equals(Vertex.class)) {
            this.buildVertexIndex(management, indexName, propertyKey, indexProperties);
        } else if (indexProperties.getType().equals(Edge.class)) {
            this.buildEdgeIndex(management, indexName, propertyKey);
        } else {
            management.rollback();
            return;
        }
        this.enableIndex(graph, management, indexName, oldKey);
    }

    private void buildVertexIndex(JanusGraphManagement management, String indexName, PropertyKey propertyKey, IndexProperties indexProperties) {
        JanusGraphManagement.IndexBuilder indexBuilder = management.buildIndex(indexName, indexProperties.getType()).addKey(propertyKey);
        if (indexProperties.isUnique()) {
            indexBuilder.unique();
        }
        JanusGraphIndex index = indexBuilder.buildCompositeIndex();
        if (indexProperties.isUnique()) {
            management.setConsistency((JanusGraphSchemaElement)index, ConsistencyModifier.LOCK);
        }
        management.commit();
    }

    private void buildEdgeIndex(JanusGraphManagement management, String indexName, PropertyKey propertyKey) {
        JanusGraphManagement.IndexBuilder indexBuilder = management.buildIndex(indexName, Edge.class).addKey(propertyKey);
        indexBuilder.buildCompositeIndex();
        management.commit();
    }

    private void enableIndex(JanusGraph graph, JanusGraphManagement management, String indexName, boolean oldKey) {
        String methodName = "enableIndex";
        try {
            if (oldKey) {
                ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.REGISTERED})).call();
                management = graph.openManagement();
                JanusGraphIndex index = management.getGraphIndex(indexName);
                management.updateIndex((Index)index, SchemaAction.REINDEX);
                management.commit();
            }
            log.debug(AWAIT_GRAPH_INDEX_STATUS_ENABLED, (Object)"enableIndex", (Object)indexName);
            ((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
        }
        catch (InterruptedException e) {
            log.error(CAUGHT_INTERRUPTED_EXCEPTION, (Object)"enableIndex", (Object)e);
            if (this.auditLog != null) {
                this.auditLog.logMessage(CAUGHT_INTERRUPTED_EXCEPTION_MESSAGE, JanusConnectorErrorCode.INDEX_NOT_ENABLED.getMessageDefinition());
            }
            management.rollback();
        }
    }

    public void createLabels(Client client) {
        String createLabels = this.createLabelsCommand();
        log.debug("Checking labels...");
        client.submit(createLabels);
    }

    private String createLabelsCommand() {
        StringBuilder managementCommand = new StringBuilder();
        managementCommand.append("JanusGraphManagement management = graph.openManagement();\n");
        for (VertexLabelsLineageGraph vertexLabelsLineageGraph : VertexLabelsLineageGraph.values()) {
            managementCommand.append(String.format(ADD_VERTEX_LABEL_IF_MISSING_FORMAT, new Object[]{vertexLabelsLineageGraph, vertexLabelsLineageGraph}));
        }
        for (Enum enum_ : EdgeLabelsLineageGraph.values()) {
            managementCommand.append(String.format(ADD_EDGE_LABEL_IF_MISSING_FORMAT, enum_, enum_));
        }
        managementCommand.append("management.commit();");
        return managementCommand.toString();
    }

    public void createIndexes(Client client) {
        String indexCommandGuid = this.createIndexCommand("vertexIndexCompositevertex--guid", "vertex--guid", true, VERTEX);
        String indexCommandLabel = this.createIndexCommand("vertexIndexCompositevertex--label", "vertex--label", false, VERTEX);
        String indexCommandVersion = this.createIndexCommand("vertexIndexCompositevertex--version", "vertex--version", false, VERTEX);
        String indexCommandAssetLineageVariables = this.createIndexCommand("vertexIndexCompositevertex--assetLineageVariables", "ASSET_LINEAGE_VARIABLES", false, VERTEX);
        String indexCommandMetadataCollectionId = this.createIndexCommand("vertexIndexCompositevertex--metadataCollectionId", "vertex--metadataCollectionId", false, VERTEX);
        String indexCommandEdgeGuid = this.createIndexCommand("edgeIndexCompositeedge--guid", "edge--guid", false, EDGE);
        String indexCommandEdgeLabel = this.createIndexCommand("edgeIndexCompositeedge--label", "edge--label", false, EDGE);
        log.debug("Checking indices...");
        client.submit(indexCommandGuid);
        client.submit(indexCommandLabel);
        client.submit(indexCommandVersion);
        client.submit(indexCommandAssetLineageVariables);
        client.submit(indexCommandMetadataCollectionId);
        client.submit(indexCommandEdgeGuid);
        client.submit(indexCommandEdgeLabel);
    }

    private String createIndexCommand(String indexName, String propertyName, boolean hasPropertyUniqueAndConsistency, String className) {
        StringBuilder indexCommand = new StringBuilder();
        indexCommand.append("management = graph.openManagement();\n");
        indexCommand.append("vertexIndex = management.getGraphIndex(\"").append(indexName).append("\");\n");
        indexCommand.append("if (vertexIndex != null ){   management.rollback(); }\n");
        indexCommand.append(" else { ");
        indexCommand.append("propertyKeyGuid = management.makePropertyKey(\"").append(propertyName).append("\").dataType(String.class).make();\n");
        indexCommand.append("indexBuilderGuidVertex = management.buildIndex(\"").append(indexName).append("\", ").append(className).append(".class).addKey(propertyKeyGuid);\n");
        if (hasPropertyUniqueAndConsistency) {
            indexCommand.append("indexBuilderGuidVertex.unique();\n");
        }
        indexCommand.append("indexGuidVertex = indexBuilderGuidVertex.buildCompositeIndex();\n");
        if (hasPropertyUniqueAndConsistency) {
            indexCommand.append("management.setConsistency(indexGuidVertex, ConsistencyModifier.LOCK);\n");
        }
        indexCommand.append("management.commit();\n");
        indexCommand.append("management = graph.openManagement();\n");
        indexCommand.append("ManagementSystem.awaitGraphIndexStatus(graph,\"").append(indexName).append("\").timeout(15, ChronoUnit.SECONDS).call();\n");
        indexCommand.append("management.updateIndex(management.getGraphIndex(\"").append(indexName).append("\"), SchemaAction.REINDEX).get();\n");
        indexCommand.append("management.commit();\n");
        indexCommand.append("}\n");
        return indexCommand.toString();
    }
}

