/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.governanceservers.openlineage.OpenLineageGraphConnector;
import org.odpi.openmetadata.governanceservers.openlineage.OpenLineageQueryService;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.graph.LineageGraph;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.GraphHelper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphQueryService;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphStorageService;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageJobHelper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageGraphConnector
extends ConnectorBase
implements OpenLineageGraphConnector {
    private static final Logger log = LoggerFactory.getLogger(LineageGraphConnector.class);
    public static final String CLOSE_LINEAGE_GRAPH_EXCEPTION = "Exception while closing lineage graph";
    public static final String EXCEPTION_WHILE_CLOSING_LINEAGE_GRAPH_MESSAGE = "Exception while closing lineage graph: ";
    public static final String CLOSE_LINEAGE_GRAPH_EXCEPTION_MESSAGE = "Exception while closing lineage graph: ";
    public static final String INPUT_PORT = "INPUT_PORT";
    public static final String OLS_HAS_CORRESPONDING_ELEMENTS = "OLS has added the corresponding subProcess node and edges for input column {}, output column {} and process {} ";
    public static final String VERTEX_NOT_FOUND = "Vertex does not exist with guid {} and display name {}";
    public static final String THE_LINEAGE_GRAPH_COULD_NOT_BE_INITIALIZED_DUE_TO_AN_ERROR = "The Lineage graph could not be initialized due to an error";
    private GraphHelper graphHelper;
    private LineageGraphStorageService graphStorageHelper;
    private LineageGraphQueryService lineageGraphQueryService;
    private AuditLog auditLog;

    public void initializeGraphDB(AuditLog auditLog) throws OpenLineageException {
        this.auditLog = auditLog;
        try {
            this.graphHelper = new GraphHelper();
            this.graphHelper.openGraph(this.connectionProperties.getConnectorType().getConnectorProviderClassName(), this.connectionProperties.getConfigurationProperties(), auditLog);
            this.graphStorageHelper = new LineageGraphStorageService(this.graphHelper, auditLog);
            this.lineageGraphQueryService = new LineageGraphQueryService(this.graphHelper, auditLog);
        }
        catch (JanusConnectorException error) {
            log.error(THE_LINEAGE_GRAPH_COULD_NOT_BE_INITIALIZED_DUE_TO_AN_ERROR, (Throwable)error);
            throw new OpenLineageException(500, error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction());
        }
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        try {
            this.graphHelper.closeGraph();
            super.disconnect();
        }
        catch (ConnectorCheckedException e) {
            log.error("Exception while closing lineage graph: ", (Throwable)e);
            this.auditLog.logException(CLOSE_LINEAGE_GRAPH_EXCEPTION, JanusConnectorErrorCode.GRAPH_DISCONNECT_ERROR.getMessageDefinition(), (Throwable)e);
            throw e;
        }
    }

    public void performLineageGraphJob() {
        LineageJobHelper lineageJobHelper = new LineageJobHelper(this.graphHelper, this.auditLog);
        lineageJobHelper.performLineageGraphJob();
    }

    public OpenLineageQueryService getLineageQueryService() {
        return this.lineageGraphQueryService;
    }

    public LineageGraph getLineageStorageService() {
        return this.graphStorageHelper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineageGraphConnector)) {
            return false;
        }
        LineageGraphConnector other = (LineageGraphConnector)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GraphHelper this$graphHelper = this.graphHelper;
        GraphHelper other$graphHelper = other.graphHelper;
        if (this$graphHelper == null ? other$graphHelper != null : !this$graphHelper.equals(other$graphHelper)) {
            return false;
        }
        LineageGraphStorageService this$graphStorageHelper = this.graphStorageHelper;
        LineageGraphStorageService other$graphStorageHelper = other.graphStorageHelper;
        if (this$graphStorageHelper == null ? other$graphStorageHelper != null : !this$graphStorageHelper.equals(other$graphStorageHelper)) {
            return false;
        }
        LineageGraphQueryService this$lineageGraphQueryService = this.lineageGraphQueryService;
        LineageGraphQueryService other$lineageGraphQueryService = other.lineageGraphQueryService;
        if (this$lineageGraphQueryService == null ? other$lineageGraphQueryService != null : !this$lineageGraphQueryService.equals(other$lineageGraphQueryService)) {
            return false;
        }
        AuditLog this$auditLog = this.auditLog;
        AuditLog other$auditLog = other.auditLog;
        return !(this$auditLog == null ? other$auditLog != null : !this$auditLog.equals(other$auditLog));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LineageGraphConnector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        GraphHelper $graphHelper = this.graphHelper;
        result = result * 59 + ($graphHelper == null ? 43 : $graphHelper.hashCode());
        LineageGraphStorageService $graphStorageHelper = this.graphStorageHelper;
        result = result * 59 + ($graphStorageHelper == null ? 43 : $graphStorageHelper.hashCode());
        LineageGraphQueryService $lineageGraphQueryService = this.lineageGraphQueryService;
        result = result * 59 + ($lineageGraphQueryService == null ? 43 : $lineageGraphQueryService.hashCode());
        AuditLog $auditLog = this.auditLog;
        result = result * 59 + ($auditLog == null ? 43 : $auditLog.hashCode());
        return result;
    }
}

