/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.GraphHelper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.SubProcessDetails;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageJobHelper {
    private static final Logger log = LoggerFactory.getLogger(LineageJobHelper.class);
    public static final String SOMETHING_WENT_WRONG_WHEN_TRYING_TO_MAP_A_PROCESS = "Something went wrong when trying to map a process.";
    public static final String SOMETHING_WENT_WRONG_WHEN_TRYING_TO_MAP_A_PROCESS_THE_ERROR_IS = "Something went wrong when trying to map a process. The error is: ";
    private GraphHelper graphHelper;
    private AuditLog auditLog;

    public LineageJobHelper(GraphHelper graphHelper, AuditLog auditLog) {
        this.graphHelper = graphHelper;
        this.auditLog = auditLog;
    }

    public void performLineageGraphJob() {
        try {
            List guidList = this.graphHelper.getResult(this::getProcessGuids, this::handleRetrieveProcessGuids);
            for (String guid : guidList) {
                this.findInputColumns(guid);
            }
        }
        catch (Exception e) {
            log.error(SOMETHING_WENT_WRONG_WHEN_TRYING_TO_MAP_A_PROCESS_THE_ERROR_IS, (Throwable)e);
            this.auditLog.logException(SOMETHING_WENT_WRONG_WHEN_TRYING_TO_MAP_A_PROCESS, JanusConnectorErrorCode.PROCESS_MAPPING_ERROR.getMessageDefinition(), (Throwable)e);
        }
    }

    private List<String> getProcessGuids(GraphTraversalSource g) {
        ArrayList<String> guidList = new ArrayList<String>();
        List vertices = g.V(new Object[0]).has("vertex--label", (Object)"Process").toList();
        for (Vertex v : vertices) {
            String s = ((Map)g.V(new Object[]{v.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid").toString();
            guidList.add(s);
        }
        return guidList;
    }

    private void findInputColumns(String guid) {
        List inputPathsForColumns = this.graphHelper.getResult(this::getInputPathsForColumns, guid, this::handleRetrieveResultError);
        Vertex process = this.graphHelper.getResult(this::getNodeByGuid, guid, this::handleRetrieveResultError);
        inputPathsForColumns.forEach(columnIn -> this.findOutputColumns((Vertex)columnIn, process));
    }

    private Vertex getNodeByGuid(GraphTraversalSource g, String guid) {
        return (Vertex)g.V(new Object[0]).has("vertex--guid", (Object)guid).next();
    }

    private List<Vertex> getInputPathsForColumns(GraphTraversalSource g, String guid) {
        List inputPathsForColumns = g.V(new Object[0]).has("vertex--guid", (Object)guid).out(new String[]{"ProcessPort"}).out(new String[]{"PortDelegation"}).has("PortImplementation", "vertex--InstancePropportType", (Object)"INPUT_PORT").out(new String[]{"PortSchema"}).out(new String[]{"AttributeForSchema"}).in(new String[]{"LineageMapping"}).or(new Traversal[]{__.in((String[])new String[]{"AttributeForSchema"}).in(new String[]{"AssetSchemaType"}).has("vertex--label", P.within(Constants.DATA_FILE_AND_SUBTYPES)), __.in((String[])new String[]{"NestedSchemaAttribute"}).has("vertex--label", (Object)"RelationalTable"), __.in((String[])new String[]{"AttributeForSchema"}).in(new String[]{"SchemaTypeOption"}).in(new String[]{"AssetSchemaType"}).has("vertex--label", (Object)"Topic")}).toList();
        return inputPathsForColumns;
    }

    private void findOutputColumns(Vertex columnIn, Vertex process) {
        List schemaElementVertices = this.graphHelper.getResult(this::getSchemaElementVertices, columnIn, this::handleRetrieveResultError);
        if (schemaElementVertices != null) {
            ArrayList columnOutList = new ArrayList();
            for (Vertex schemaElementVertex : schemaElementVertices) {
                Vertex vertexToStart = (Vertex)this.graphHelper.getResult(this::isSchemaElementLinkedToProcess, schemaElementVertex, process, this::handleRetrieveResultError);
                if (vertexToStart != null) {
                    columnOutList.addAll((Collection)this.graphHelper.getResult(this::findPathForOutputAsset, vertexToStart, columnIn, this::handleRetrieveResultError));
                }
                for (Vertex columnOut : columnOutList) {
                    this.addNodesAndEdgesForQuerying(columnIn, columnOut, process);
                }
            }
        }
    }

    private List<Vertex> getSchemaElementVertices(GraphTraversalSource g, Vertex columnIn) {
        List schemaElementVertices = g.V(new Object[0]).has("vertex--guid", ((Map)g.V(new Object[]{columnIn.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid")).out(new String[]{"LineageMapping"}).toList();
        return schemaElementVertices;
    }

    private Vertex isSchemaElementLinkedToProcess(GraphTraversalSource g, Vertex schemaElementVertex, Vertex process) {
        List initialProcess = g.V(new Object[]{schemaElementVertex.id()}).bothE(new String[]{"AttributeForSchema"}).otherV().inE(new String[]{"PortSchema"}).otherV().inE(new String[]{"PortDelegation"}).otherV().inE(new String[]{"ProcessPort"}).otherV().has("vertex--guid", ((Map)g.V(new Object[]{process.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid")).toList();
        if (!initialProcess.isEmpty()) {
            return schemaElementVertex;
        }
        return null;
    }

    private List<Vertex> findPathForOutputAsset(GraphTraversalSource g, Vertex endingVertex, Vertex startingVertex) {
        if (endingVertex == null) {
            return null;
        }
        ArrayList<Vertex> endVertices = new ArrayList<Vertex>();
        try {
            if (this.isEndColumn(g, endingVertex)) {
                endVertices.add(endingVertex);
            } else {
                List nextVertices = g.V(new Object[]{endingVertex.id()}).out(new String[]{"LineageMapping"}).toList();
                for (Vertex vertex : nextVertices) {
                    if (vertex.equals(startingVertex)) continue;
                    Optional.ofNullable(this.findPathForOutputAsset(g, vertex, endingVertex)).ifPresent(endVertices::addAll);
                }
            }
            return endVertices;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Vertex does not exist with guid {} and display name {}", startingVertex.id(), startingVertex.property("vertex--displayName").value());
            }
            return null;
        }
    }

    private boolean isEndColumn(GraphTraversalSource g, Vertex vertex) {
        String VERTEX = "vertex";
        GraphTraversal end = g.V(new Object[]{vertex.id()}).or(new Traversal[]{__.in((String[])new String[]{"AttributeForSchema"}).in(new String[]{"AssetSchemaType"}).has("vertex--label", P.within(Constants.DATA_FILE_AND_SUBTYPES)).aggregate(Scope.local, "vertex"), __.in((String[])new String[]{"NestedSchemaAttribute"}).has("vertex--label", (Object)"RelationalTable").aggregate(Scope.local, "vertex"), __.in((String[])new String[]{"AttributeForSchema"}).in(new String[]{"SchemaTypeOption"}).in(new String[]{"AssetSchemaType"}).has("vertex--label", (Object)"Topic").aggregate(Scope.local, "vertex")}).select("vertex").unfold();
        return end.hasNext();
    }

    private void addNodesAndEdgesForQuerying(Vertex columnIn, Vertex columnOut, Vertex process) {
        if (this.isColumnEmpty(columnIn) || this.isColumnEmpty(columnOut)) {
            return;
        }
        SubProcessDetails subProcessDetails = new SubProcessDetails();
        subProcessDetails.setProcessGuid(this.graphHelper.getResult(this::getGuid, process, this::handleRetrieveResultError));
        subProcessDetails.setColumnInGuid(this.graphHelper.getResult(this::getGuid, columnIn, this::handleRetrieveResultError));
        subProcessDetails.setColumnOutGuid(this.graphHelper.getResult(this::getGuid, columnOut, this::handleRetrieveResultError));
        subProcessDetails.setProcessName(this.graphHelper.getResult(this::getProcessName, process, this::handleRetrieveResultError));
        subProcessDetails.setColumnIn(columnIn);
        subProcessDetails.setColumnOut(columnOut);
        subProcessDetails.setProcess(process);
        Iterator existingSubProcess = this.graphHelper.getResult(this::findExistingConnection, subProcessDetails, this::handleFindExistingSubprocess);
        if (!existingSubProcess.hasNext()) {
            this.graphHelper.commit(this::connectNodes, subProcessDetails, this::handleCouldNotAddEdge);
            this.addAssetToProcessEdges(columnIn, process, columnOut);
            log.info("OLS has added the corresponding subProcess node and edges for input column {}, output column {} and process {} ", new Object[]{subProcessDetails.getColumnInGuid(), subProcessDetails.getColumnOutGuid(), subProcessDetails.getProcessGuid()});
        }
    }

    private Iterator<Vertex> findExistingConnection(GraphTraversalSource g, SubProcessDetails subProcessDetails) {
        GraphTraversal existingSubProcess = g.V(new Object[]{subProcessDetails.getColumnIn().id()}).outE(new String[]{"ColumnDataFlow"}).inV().has("columnOutGuid", (Object)subProcessDetails.getColumnOutGuid()).has("processGuid", (Object)subProcessDetails.getProcessGuid());
        return existingSubProcess;
    }

    private void connectNodes(GraphTraversalSource g, SubProcessDetails subProcessDetails) {
        Vertex subProcess = (Vertex)g.addV("subProcess").property((Object)"vertex--nodeID", (Object)UUID.randomUUID().toString(), new Object[0]).property((Object)"vertex--displayName", (Object)subProcessDetails.getProcessName(), new Object[0]).property((Object)"processGuid", (Object)subProcessDetails.getProcessGuid(), new Object[0]).property((Object)"columnInGuid", (Object)subProcessDetails.getColumnInGuid(), new Object[0]).property((Object)"columnOutGuid", (Object)subProcessDetails.getColumnOutGuid(), new Object[0]).next();
        g.V(new Object[]{subProcessDetails.getColumnIn().id()}).addE("ColumnDataFlow").to((Traversal)__.V((Object[])new Object[]{subProcess.id()})).next();
        g.V(new Object[]{subProcess.id()}).addE("ColumnDataFlow").to((Traversal)__.V((Object[])new Object[]{subProcessDetails.getColumnOut().id()})).next();
        g.V(new Object[]{subProcess.id()}).addE("includedIn").to((Traversal)__.V((Object[])new Object[]{subProcessDetails.getProcess().id()})).next();
    }

    private String getProcessName(GraphTraversalSource g, Vertex process) {
        String processName = ((Map)g.V(new Object[]{process.id()}).elementMap(new String[]{"vertex--InstancePropdisplayName"}).toList().get(0)).get("vertex--InstancePropdisplayName").toString();
        return processName;
    }

    private boolean isColumnEmpty(Vertex column) {
        return column == null || !StringUtils.isNotEmpty((CharSequence)this.graphHelper.getResult(this::getGuid, column, this::handleRetrieveResultError));
    }

    private String getGuid(GraphTraversalSource g, Vertex vertex) {
        String guid = ((Map)g.V(new Object[]{vertex.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid").toString();
        return guid;
    }

    private void addAssetToProcessEdges(Vertex columnIn, Vertex process, Vertex columnOut) {
        Optional assetIn = this.graphHelper.getResult(this::getAsset, columnIn, this::handleRetrieveResultError);
        this.graphHelper.commit(this::addEdgeFromColumnToProcess, assetIn, process, this::handleCouldNotAddEdge);
        Optional assetOut = this.graphHelper.getResult(this::getAsset, columnOut, this::handleRetrieveResultError);
        this.graphHelper.commit(this::addEdgeFromProcessToColumn, process, assetOut, this::handleCouldNotAddEdge);
    }

    private void addEdgeFromColumnToProcess(GraphTraversalSource g, Optional<Vertex> assetIn, Vertex process) {
        GraphTraversal tableVertex;
        if (assetIn.isPresent() && !(tableVertex = g.V(new Object[]{assetIn.get().id()}).outE(new String[]{"TableDataFlow"}).inV().hasId(process.id(), new Object[0])).hasNext()) {
            g.V(new Object[]{assetIn.get().id()}).addE("TableDataFlow").to((Traversal)__.V((Object[])new Object[]{process.id()})).next();
        }
    }

    private void addEdgeFromProcessToColumn(GraphTraversalSource g, Vertex process, Optional<Vertex> assetOut) {
        GraphTraversal tableVertex;
        if (assetOut.isPresent() && !(tableVertex = g.V(new Object[]{assetOut.get().id()}).inE(new String[]{"TableDataFlow"}).outV().hasId(process.id(), new Object[0])).hasNext()) {
            g.V(new Object[]{process.id()}).addE("TableDataFlow").to((Traversal)__.V((Object[])new Object[]{assetOut.get().id()})).next();
        }
    }

    private void handleCouldNotAddEdge(Exception e) {
        log.error(JanusConnectorErrorCode.VERTICES_AND_RELATIONSHIP_CREATION_EXCEPTION.getErrorMessage(), (Throwable)e);
        throw new JanusConnectorException(this.getClass().getName(), "addAssetToProcessEdges", JanusConnectorErrorCode.VERTICES_AND_RELATIONSHIP_CREATION_EXCEPTION);
    }

    private Optional<Vertex> getAsset(GraphTraversalSource g, Vertex asset) {
        Object vertexGuid = ((Map)g.V(new Object[]{asset.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid");
        Vertex graphVertex = (Vertex)g.V(new Object[0]).has("vertex--guid", vertexGuid).next();
        Object vertexId = graphVertex.id();
        Iterator result = null;
        if ("RelationalColumn".equalsIgnoreCase(asset.label())) {
            result = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"RelationalTable", (String[])new String[0])});
        }
        if ("TabularColumn".equalsIgnoreCase(asset.label()) || "TabularFileColumn".equalsIgnoreCase(asset.label())) {
            result = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(2).or(new Traversal[]{__.hasLabel((P)P.within(Constants.DATA_FILE_AND_SUBTYPES))});
        }
        if ("EventSchemaAttribute".equalsIgnoreCase(asset.label())) {
            result = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(3).or(new Traversal[]{__.hasLabel((String)"Topic", (String[])new String[0])});
        }
        if (result == null) {
            return Optional.empty();
        }
        return Optional.of((Vertex)result.next());
    }

    private void handleRetrieveProcessGuids(Exception e) {
        log.error("Could not retrieve guids from the database", (Throwable)e);
    }

    private void handleRetrieveResultError(Exception e, Vertex vertex) {
        log.error("Could not retrieve object from database {}", (Object)vertex, (Object)e);
    }

    private void handleRetrieveResultError(Exception e, String guid) {
        log.error("Could not retrieve object from database {}", (Object)guid, (Object)e);
    }

    private void handleRetrieveResultError(Exception e, Vertex vertex1, Vertex vertex2) {
        log.error("Could not retrieve object from database {}, {}", new Object[]{vertex1, vertex2, e});
    }

    private void handleFindExistingSubprocess(Exception e, SubProcessDetails subProcessDetails) {
        log.error("Could not find connection {}", (Object)subProcessDetails, (Object)e);
    }
}

