/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory.GraphFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageGraphTransactionManager {
    private static final Logger log = LoggerFactory.getLogger(LineageGraphTransactionManager.class);

    private LineageGraphTransactionManager() {
    }

    public static <T, R> R commit(GraphFactory factory, GraphTraversalSource g, Function<T, R> function, T entity, String errorMessage) {
        R object;
        block3: {
            object = null;
            try {
                object = function.apply(entity);
                if (factory.isSupportingTransactions()) {
                    g.tx().commit();
                }
            }
            catch (Exception e) {
                log.error(errorMessage, (Throwable)e);
                if (!factory.isSupportingTransactions()) break block3;
                g.tx().rollback();
            }
        }
        return object;
    }

    public static <R> R commit(GraphFactory factory, GraphTraversalSource g, Supplier<R> supplier, String errorMessage) {
        R object;
        block3: {
            object = null;
            try {
                object = supplier.get();
                if (factory.isSupportingTransactions()) {
                    g.tx().commit();
                }
            }
            catch (Exception e) {
                log.error(errorMessage, (Throwable)e);
                if (!factory.isSupportingTransactions()) break block3;
                g.tx().rollback();
            }
        }
        return object;
    }

    public static <T> void commit(GraphFactory factory, GraphTraversalSource g, Consumer<T> consumer, T arg1, String errorMessage) {
        block3: {
            try {
                consumer.accept(arg1);
                if (factory.isSupportingTransactions()) {
                    g.tx().commit();
                }
            }
            catch (Exception e) {
                log.error(errorMessage, (Throwable)e);
                if (!factory.isSupportingTransactions()) break block3;
                g.tx().rollback();
            }
        }
    }

    public static <T, U> void commit(GraphFactory factory, GraphTraversalSource g, BiConsumer<T, U> biConsumer, T arg1, U arg2, String errorMessage) {
        block3: {
            try {
                biConsumer.accept(arg1, arg2);
                if (factory.isSupportingTransactions()) {
                    g.tx().commit();
                }
            }
            catch (Exception e) {
                log.error(errorMessage, (Throwable)e);
                if (!factory.isSupportingTransactions()) break block3;
                g.tx().rollback();
            }
        }
    }
}

