/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageRelationship;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.graph.LineageGraphConnectorBase;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageVertexResponse;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory.GraphFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphConnectorHelper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphTransactionManager;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageGraphConnector
extends LineageGraphConnectorBase {
    public static final String KV = "kv";
    private static final Logger log = LoggerFactory.getLogger(LineageGraphConnector.class);
    public static final String CLOSE_LINEAGE_GRAPH_EXCEPTION = "Exception while closing lineage graph";
    public static final String EXCEPTION_WHILE_CLOSING_LINEAGE_GRAPH_MESSAGE = "Exception while closing lineage graph: ";
    public static final String CLOSE_LINEAGE_GRAPH_EXCEPTION_MESSAGE = "Exception while closing lineage graph: ";
    public static final String UNABLE_TO_ADD_PROPERTIES = "Unable to add properties on vertex from entity with type ";
    public static final String AND_GUID = " and guid ";
    public static final String UNABLE_TO_CREATE_EDGE_WITH_LABEL = "Unable to create edge with label ";
    public static final String FROM = "from";
    public static final String UNABLE_TO_CREATE_VERTEX_WITH_TYPE = "Unable to create vertex with type ";
    public static final String EMPTY_GRAPH_TRAVERSAL = "The graphTraversal is empty. Connection with the graph is not established";
    public static final String INITIALIZE_GRAPH_DB = "initializeGraphDB";
    public static final String ASSET_LINEAGE_VARIABLES = "ASSET_LINEAGE_VARIABLES";
    public static final String INPUT_PORT = "INPUT_PORT";
    public static final String OLS_HAS_CORRESPONDING_ELEMENTS = "OLS has added the corresponding subProcess node and edges for input column {}, output column {} and process {} ";
    public static final String VERTICES_AND_RELATIONSHIP_CREATION_EXCEPTION = "An exception happened when trying to create vertices and relationships in LineageGraph. The error is";
    public static final String COULD_NOT_DROP_EDGE = "Could not drop edge ";
    public static final String PROPERTIES = "properties";
    public static final String V = "v";
    public static final String VERTEX_GUID_NOT_FOUND_WHEN_UPDATE = "When trying to update, vertex with guid {} was not found  ";
    public static final String PROPERTIES_UPDATE_EXCEPTION = "An exception happened during update of the properties with exception: ";
    public static final String UNABLE_TO_ADD_PROPERTIES_ON_EDGE_FROM_RELATIONSHIP_WITH_TYPE = "Unable to add properties on edge from relationship with type ";
    public static final String EDGE_GUID_NOT_FOUND_WHEN_UPDATE = "When trying to update, edge with guid {} was not found";
    public static final String CLASSIFICATION_WITH_GUID_NOT_FOUND = "Classification with guid {} not found";
    public static final String S = "s";
    public static final String DELETE_CLASSIFICATION_EXCEPTION = "An exception happened during delete of classifications with error:";
    public static final String VERTEX_WITH_GUID_IS_NOT_PRESENT = "Vertex with guid is not present {}";
    public static final String VERTEX_WITH_GUID_DELETED = "Vertex with guid {} deleted";
    public static final String EDGE_WITH_GUID_DID_NOT_DELETE = "Edge with guid did not delete {}";
    public static final String EDGE_WITH_GUID_DELETED = "Edge with guid {} deleted";
    public static final String EDGE = "edge";
    public static final String VERTEX_NOT_FOUND = "Vertex does not exist with guid {} and display name {}";
    public static final String THE_LINEAGE_GRAPH_COULD_NOT_BE_INITIALIZED_DUE_TO_AN_ERROR = "The Lineage graph could not be initialized due to an error";
    public static final String SOMETHING_WENT_WRONG_WHEN_TRYING_TO_MAP_A_PROCESS = "Something went wrong when trying to map a process.";
    public static final String SOMETHING_WENT_WRONG_WHEN_TRYING_TO_MAP_A_PROCESS_THE_ERROR_IS = "Something went wrong when trying to map a process. The error is: ";
    private LineageGraphConnectorHelper helper;
    private GraphTraversalSource g;
    private GraphFactory graphFactory;
    private AuditLog auditLog;

    public void initializeGraphDB(AuditLog auditLog) throws OpenLineageException {
        this.auditLog = auditLog;
        try {
            this.graphFactory = new GraphFactory();
            this.g = this.graphFactory.openGraph(this.connectionProperties.getConnectorType().getConnectorProviderClassName(), this.connectionProperties, auditLog);
            if (this.g == null) {
                log.error(EMPTY_GRAPH_TRAVERSAL);
                JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.GRAPH_TRAVERSAL_EMPTY;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(EMPTY_GRAPH_TRAVERSAL, INITIALIZE_GRAPH_DB, LineageGraphConnector.class.getName());
                throw new OpenLineageException(500, ((Object)((Object)errorCode)).getClass().getName(), errorMessage, errorCode.getErrorMessage(), errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.helper = new LineageGraphConnectorHelper(this.g, this.graphFactory.isSupportingTransactions());
        }
        catch (JanusConnectorException error) {
            log.error(THE_LINEAGE_GRAPH_COULD_NOT_BE_INITIALIZED_DUE_TO_AN_ERROR, (Throwable)error);
            throw new OpenLineageException(500, error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction());
        }
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        try {
            this.graphFactory.closeGraph();
            super.disconnect();
        }
        catch (ConnectorCheckedException e) {
            log.error("Exception while closing lineage graph: ", (Throwable)e);
            this.auditLog.logException(CLOSE_LINEAGE_GRAPH_EXCEPTION, JanusConnectorErrorCode.GRAPH_DISCONNECT_ERROR.getMessageDefinition(), (Throwable)e);
            throw e;
        }
    }

    public void performLineageGraphJob() {
        try {
            List vertices = this.g.V(new Object[0]).has("vertex--label", (Object)"Process").toList();
            List<String> guidList = vertices.stream().map(v -> ((Map)this.g.V(new Object[]{v.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid").toString()).collect(Collectors.toList());
            guidList.forEach(guid -> this.findInputColumns(this.g, (String)guid));
            this.commitTransaction(this.g);
        }
        catch (Exception e) {
            log.error(SOMETHING_WENT_WRONG_WHEN_TRYING_TO_MAP_A_PROCESS_THE_ERROR_IS, (Throwable)e);
            this.auditLog.logException(SOMETHING_WENT_WRONG_WHEN_TRYING_TO_MAP_A_PROCESS, JanusConnectorErrorCode.PROCESS_MAPPING_ERROR.getMessageDefinition(), (Throwable)e);
            this.rollbackTransaction(this.g);
        }
    }

    public void saveAssetLineageUpdateTime(Long lastUpdateTime) {
        GraphTraversal lineageVariables = this.g.V(new Object[0]).hasLabel(ASSET_LINEAGE_VARIABLES, new String[0]);
        if (!lineageVariables.hasNext()) {
            this.g.addV(ASSET_LINEAGE_VARIABLES).property((Object)"assetLineageLastUpdateTimestamp", (Object)lastUpdateTime, new Object[0]).next();
        } else {
            this.g.V(new Object[]{((Vertex)lineageVariables.next()).id()}).property((Object)"assetLineageLastUpdateTimestamp", (Object)lastUpdateTime, new Object[0]).next();
        }
    }

    public Optional<Long> getAssetLineageUpdateTime() {
        GraphTraversal lineageVariables = this.g.V(new Object[0]).hasLabel(ASSET_LINEAGE_VARIABLES, new String[0]).valueMap(new String[0]);
        if (lineageVariables.hasNext()) {
            Map next = (Map)lineageVariables.next();
            if (next.containsKey("assetLineageLastUpdateTimestamp")) {
                return Optional.of((Long)((List)next.get("assetLineageLastUpdateTimestamp")).get(0));
            }
        } else {
            return this.getLineageUpdateTimeFromGraphVariables();
        }
        return Optional.empty();
    }

    private Optional<Long> getLineageUpdateTimeFromGraphVariables() {
        try {
            return this.g.getGraph().variables().get("assetLineageLastUpdateTimestamp");
        }
        catch (UnsupportedOperationException e) {
            return Optional.empty();
        }
    }

    private void findInputColumns(GraphTraversalSource g, String guid) {
        List inputPathsForColumns = g.V(new Object[0]).has("vertex--guid", (Object)guid).out(new String[]{"ProcessPort"}).out(new String[]{"PortDelegation"}).has("PortImplementation", "vertex--InstancePropportType", (Object)INPUT_PORT).out(new String[]{"PortSchema"}).out(new String[]{"AttributeForSchema"}).in(new String[]{"LineageMapping"}).or(new Traversal[]{__.in((String[])new String[]{"AttributeForSchema"}).in(new String[]{"AssetSchemaType"}).has("vertex--label", P.within(Constants.DATA_FILE_AND_SUBTYPES)), __.in((String[])new String[]{"NestedSchemaAttribute"}).has("vertex--label", (Object)"RelationalTable")}).toList();
        this.commitTransaction(g);
        Vertex process = (Vertex)g.V(new Object[0]).has("vertex--guid", (Object)guid).next();
        inputPathsForColumns.forEach(columnIn -> this.findOutputColumns(g, (Vertex)columnIn, process));
    }

    private void findOutputColumns(GraphTraversalSource g, Vertex columnIn, Vertex process) {
        List schemaElementVertices = g.V(new Object[0]).has("vertex--guid", ((Map)g.V(new Object[]{columnIn.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid")).out(new String[]{"LineageMapping"}).toList();
        this.commitTransaction(g);
        if (schemaElementVertices != null) {
            ArrayList<Vertex> columnOutList = new ArrayList<Vertex>();
            for (Vertex schemaElementVertex : schemaElementVertices) {
                Vertex vertexToStart = this.isSchemaElementLinkedToProcess(g, schemaElementVertex, process);
                if (vertexToStart != null) {
                    columnOutList.addAll(this.findPathForOutputAsset(vertexToStart, g, columnIn));
                }
                for (Vertex columnOut : columnOutList) {
                    this.addNodesAndEdgesForQuerying(columnIn, columnOut, process);
                }
            }
        }
    }

    private Vertex isSchemaElementLinkedToProcess(GraphTraversalSource g, Vertex schemaElementVertex, Vertex process) {
        List initialProcess = g.V(new Object[]{schemaElementVertex.id()}).bothE(new String[]{"AttributeForSchema"}).otherV().inE(new String[]{"PortSchema"}).otherV().inE(new String[]{"PortDelegation"}).otherV().inE(new String[]{"ProcessPort"}).otherV().has("vertex--guid", ((Map)g.V(new Object[]{process.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid")).toList();
        this.commitTransaction(g);
        if (!initialProcess.isEmpty()) {
            return schemaElementVertex;
        }
        return null;
    }

    private boolean isColumnEmpty(Vertex column) {
        return column == null || !StringUtils.isNotEmpty((CharSequence)this.getGuid(column));
    }

    private void addNodesAndEdgesForQuerying(Vertex columnIn, Vertex columnOut, Vertex process) {
        if (this.isColumnEmpty(columnIn) || this.isColumnEmpty(columnOut)) {
            return;
        }
        String processGuid = this.getGuid(process);
        String columnInGuid = this.getGuid(columnIn);
        String columnOutGuid = this.getGuid(columnOut);
        String processName = ((Map)this.g.V(new Object[]{process.id()}).elementMap(new String[]{"vertex--InstancePropdisplayName"}).toList().get(0)).get("vertex--InstancePropdisplayName").toString();
        GraphTraversal t = this.g.V(new Object[]{columnIn.id()}).outE(new String[]{"ColumnDataFlow"}).inV().has("columnOutGuid", (Object)columnOutGuid).has("processGuid", (Object)processGuid);
        if (!t.hasNext()) {
            Vertex subProcess = (Vertex)this.g.addV("subProcess").property((Object)"vertex--nodeID", (Object)UUID.randomUUID().toString(), new Object[0]).property((Object)"vertex--displayName", (Object)processName, new Object[0]).property((Object)"processGuid", (Object)processGuid, new Object[0]).property((Object)"columnInGuid", (Object)columnInGuid, new Object[0]).property((Object)"columnOutGuid", (Object)columnOutGuid, new Object[0]).next();
            this.g.V(new Object[]{columnIn.id()}).addE("ColumnDataFlow").to((Traversal)this.g.V(new Object[]{subProcess.id()})).next();
            this.g.V(new Object[]{subProcess.id()}).addE("ColumnDataFlow").to((Traversal)this.g.V(new Object[]{columnOut.id()})).next();
            this.g.V(new Object[]{subProcess.id()}).addE("includedIn").to((Traversal)this.g.V(new Object[]{process.id()})).next();
            this.commitTransaction(this.g);
            this.addAssetToProcessEdges(columnIn, columnOut, process);
            log.info(OLS_HAS_CORRESPONDING_ELEMENTS, new Object[]{columnInGuid, columnOutGuid, processGuid});
        }
    }

    private void addAssetToProcessEdges(Vertex columnIn, Vertex columnOut, Vertex process) {
        GraphTraversal tableVertex;
        Optional<Vertex> assetOut;
        GraphTraversal tableVertex2;
        Optional<Vertex> assetIn = this.getAsset(columnIn);
        if (assetIn.isPresent() && !(tableVertex2 = this.g.V(new Object[]{assetIn.get().id()}).outE(new String[]{"TableDataFlow"}).inV().hasId(process.id(), new Object[0])).hasNext()) {
            this.g.V(new Object[]{assetIn.get().id()}).addE("TableDataFlow").to((Traversal)this.g.V(new Object[]{process.id()})).next();
        }
        if ((assetOut = this.getAsset(columnOut)).isPresent() && !(tableVertex = this.g.V(new Object[]{assetOut.get().id()}).inE(new String[]{"TableDataFlow"}).outV().hasId(process.id(), new Object[0])).hasNext()) {
            this.g.V(new Object[]{process.id()}).addE("TableDataFlow").to((Traversal)this.g.V(new Object[]{assetOut.get().id()})).next();
        }
        this.commitTransaction(this.g);
    }

    private String getGuid(Vertex vertex) {
        return ((Map)this.g.V(new Object[]{vertex.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid").toString();
    }

    private Optional<Vertex> getAsset(Vertex asset) {
        Object vertexGuid = ((Map)this.g.V(new Object[]{asset.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid");
        Vertex graphVertex = (Vertex)this.g.V(new Object[0]).has("vertex--guid", vertexGuid).next();
        Object vertexId = graphVertex.id();
        if ("RelationalColumn".equalsIgnoreCase(asset.label())) {
            GraphTraversal table = this.g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"RelationalTable", (String[])new String[0])});
            return Optional.of((Vertex)table.next());
        }
        if ("TabularColumn".equalsIgnoreCase(asset.label()) || "TabularFileColumn".equalsIgnoreCase(asset.label())) {
            GraphTraversal dataFile = this.g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(2).or(new Traversal[]{__.hasLabel((P)P.within(Constants.DATA_FILE_AND_SUBTYPES))});
            return Optional.of((Vertex)dataFile.next());
        }
        return Optional.empty();
    }

    public void storeToGraph(Set<GraphContext> graphContext) {
        graphContext.forEach(entry -> {
            try {
                LineageEntity fromEntity = entry.getFromVertex();
                LineageEntity toEntity = entry.getToVertex();
                this.upsertToGraph(fromEntity, toEntity, entry.getRelationshipType(), entry.getRelationshipGuid());
            }
            catch (Exception e) {
                log.error(VERTICES_AND_RELATIONSHIP_CREATION_EXCEPTION, (Throwable)e);
            }
        });
    }

    public void updateNeighbours(String nodeGUID, Set<String> neighboursGUIDS) {
        List<String> existingNeighboursGUIDs = this.getAllNeighbours(nodeGUID);
        if (this.isDifferentGraphContext(neighboursGUIDS, existingNeighboursGUIDs)) {
            this.removeObsoleteEdges(nodeGUID, neighboursGUIDS, existingNeighboursGUIDs);
        }
    }

    private List<String> getAllNeighbours(String entityGUID) {
        GraphTraversal exitingVertices = this.g.V(new Object[0]).has("vertex--guid", (Object)entityGUID).bothE(new String[0]).otherV();
        ArrayList<String> existingGUIDs = new ArrayList<String>();
        while (exitingVertices.hasNext()) {
            Map valueMap = (Map)this.g.V(new Object[]{((Vertex)exitingVertices.next()).id()}).valueMap(new String[]{"vertex--guid"}).next();
            if (!valueMap.containsKey("vertex--guid")) continue;
            existingGUIDs.addAll((List)valueMap.get("vertex--guid"));
        }
        return existingGUIDs;
    }

    private boolean isDifferentGraphContext(Set<String> newVertices, List<String> neighboursGUIDs) {
        return neighboursGUIDs.size() != newVertices.size() || !neighboursGUIDs.containsAll(newVertices);
    }

    private void removeObsoleteEdges(String entityGUID, Set<String> newVertices, List<String> neighboursGUIDs) {
        Function<Edge, GraphTraversal> dropEdgeFromGraph = e -> this.g.E(new Object[]{e.id()}).drop().iterate();
        List obsoleteNeighbours = neighboursGUIDs.stream().filter(existingVertex -> !newVertices.contains(existingVertex)).collect(Collectors.toList());
        if (obsoleteNeighbours.isEmpty()) {
            return;
        }
        GraphTraversal existingEdges = this.g.V(new Object[0]).has("vertex--guid", (Object)entityGUID).bothE(new String[0]);
        while (existingEdges.hasNext()) {
            Edge edge = (Edge)existingEdges.next();
            List inVertexGuid = (List)((Map)this.g.V(new Object[]{edge.inVertex()}).valueMap(new String[]{"vertex--guid"}).next()).get("vertex--guid");
            List outVertexGuid = (List)((Map)this.g.V(new Object[]{edge.outVertex()}).valueMap(new String[]{"vertex--guid"}).next()).get("vertex--guid");
            if (!obsoleteNeighbours.containsAll(inVertexGuid) && !obsoleteNeighbours.containsAll(outVertexGuid)) continue;
            LineageGraphTransactionManager.commit(this.graphFactory, this.g, dropEdgeFromGraph, edge, COULD_NOT_DROP_EDGE + edge.id());
        }
    }

    private void upsertToGraph(LineageEntity fromEntity, LineageEntity toEntity, String relationshipLabel, String relationshipGuid) {
        Function<LineageEntity, Vertex> createVertexFunction = lineageEntity -> (Vertex)this.g.V(new Object[0]).has("vertex--guid", (Object)lineageEntity.getGuid()).fold().coalesce(new Traversal[]{__.unfold(), __.addV((String)lineageEntity.getTypeDefName()).property((Object)"vertex--guid", (Object)lineageEntity.getGuid(), new Object[0])}).next();
        Vertex from = LineageGraphTransactionManager.commit(this.graphFactory, this.g, createVertexFunction, fromEntity, UNABLE_TO_CREATE_VERTEX_WITH_TYPE + fromEntity.getTypeDefName() + AND_GUID + fromEntity.getGuid());
        Vertex to = LineageGraphTransactionManager.commit(this.graphFactory, this.g, createVertexFunction, toEntity, UNABLE_TO_CREATE_VERTEX_WITH_TYPE + toEntity.getTypeDefName() + AND_GUID + toEntity.getGuid());
        Supplier<Edge> createEdgeSupplier = () -> (Edge)this.g.V(new Object[]{from.id()}).as(FROM, new String[0]).V(new Object[]{to.id()}).coalesce(new Traversal[]{__.inE((String[])new String[]{relationshipLabel}).where((Traversal)__.outV().as(FROM, new String[0])), __.addE((String)relationshipLabel).from(FROM)}).property((Object)"edge--guid", (Object)relationshipGuid, new Object[0]).next();
        LineageGraphTransactionManager.commit(this.graphFactory, this.g, createEdgeSupplier, UNABLE_TO_CREATE_EDGE_WITH_LABEL + relationshipLabel + AND_GUID + relationshipGuid);
        BiConsumer<Vertex, LineageEntity> addOrUpdatePropertiesVertexConsumer = this::addOrUpdatePropertiesVertex;
        LineageGraphTransactionManager.commit(this.graphFactory, this.g, addOrUpdatePropertiesVertexConsumer, from, fromEntity, UNABLE_TO_ADD_PROPERTIES + fromEntity.getTypeDefName() + AND_GUID + fromEntity.getGuid());
        LineageGraphTransactionManager.commit(this.graphFactory, this.g, addOrUpdatePropertiesVertexConsumer, to, toEntity, UNABLE_TO_ADD_PROPERTIES + toEntity.getTypeDefName() + AND_GUID + toEntity.getGuid());
    }

    private void addOrUpdatePropertiesVertex(Vertex vertex, LineageEntity lineageEntity) {
        Map<String, Object> properties = lineageEntity.getProperties().entrySet().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)((CharSequence)e.getValue()))).collect(Collectors.toMap(e -> "vertex--InstanceProp" + (String)e.getKey(), Map.Entry::getValue));
        properties.computeIfAbsent("vertex--createTime", val -> lineageEntity.getCreateTime());
        properties.computeIfAbsent("vertex--createdBy", val -> lineageEntity.getCreatedBy());
        properties.computeIfAbsent("vertex--updateTime", val -> lineageEntity.getUpdateTime());
        properties.computeIfAbsent("vertex--updatedBy", val -> lineageEntity.getUpdatedBy());
        properties.computeIfAbsent("vertex--label", val -> lineageEntity.getTypeDefName());
        properties.computeIfAbsent("vertex--version", val -> lineageEntity.getVersion());
        properties.computeIfAbsent("vertex--metadataCollectionId", val -> lineageEntity.getMetadataCollectionId());
        this.g.inject((Object[])new Map[]{properties}).unfold().as(PROPERTIES, new String[0]).V(new Object[]{vertex.id()}).as(V, new String[0]).sideEffect((Traversal)__.select((String)PROPERTIES).unfold().as(KV, new String[0]).select(V).property((Object)__.select((String)KV).by((Function)Column.keys), (Object)__.select((String)KV).by((Function)Column.values), new Object[0])).iterate();
    }

    public void updateEntity(LineageEntity lineageEntity) {
        GraphTraversal vertex = this.g.V(new Object[0]).has("vertex--guid", (Object)lineageEntity.getGuid());
        if (!vertex.hasNext()) {
            log.debug(VERTEX_GUID_NOT_FOUND_WHEN_UPDATE, (Object)lineageEntity.getGuid());
            this.rollbackTransaction(this.g);
            return;
        }
        try {
            this.addOrUpdatePropertiesVertex((Vertex)vertex.next(), lineageEntity);
            this.commitTransaction(this.g);
        }
        catch (Exception e) {
            log.error(PROPERTIES_UPDATE_EXCEPTION, (Throwable)e);
            this.rollbackTransaction(this.g);
        }
    }

    public void upsertRelationship(LineageRelationship lineageRelationship) {
        LineageEntity firstEnd = lineageRelationship.getSourceEntity();
        LineageEntity secondEnd = lineageRelationship.getTargetEntity();
        this.upsertToGraph(firstEnd, secondEnd, lineageRelationship.getTypeDefName(), lineageRelationship.getGuid());
        Consumer<LineageRelationship> addOrUpdatePropertiesEdge = this::addOrUpdatePropertiesEdge;
        LineageGraphTransactionManager.commit(this.graphFactory, this.g, addOrUpdatePropertiesEdge, lineageRelationship, UNABLE_TO_ADD_PROPERTIES_ON_EDGE_FROM_RELATIONSHIP_WITH_TYPE + lineageRelationship.getTypeDefName() + AND_GUID + lineageRelationship.getGuid());
    }

    public void updateRelationship(LineageRelationship lineageRelationship) {
        GraphTraversal edge = this.g.E(new Object[0]).has("edge--guid", (Object)lineageRelationship.getGuid());
        if (!edge.hasNext()) {
            log.debug(EDGE_GUID_NOT_FOUND_WHEN_UPDATE, (Object)lineageRelationship.getGuid());
            this.rollbackTransaction(this.g);
            return;
        }
        try {
            this.addOrUpdatePropertiesEdge(lineageRelationship);
            this.commitTransaction(this.g);
        }
        catch (Exception e) {
            log.debug(PROPERTIES_UPDATE_EXCEPTION, (Throwable)e);
            this.rollbackTransaction(this.g);
        }
    }

    public void updateClassification(Set<GraphContext> classificationContext) {
        for (GraphContext graphContext : classificationContext) {
            String classificationGuid = graphContext.getToVertex().getGuid();
            GraphTraversal vertexIterator = this.g.V(new Object[0]).has("vertex--guid", (Object)classificationGuid);
            if (!vertexIterator.hasNext()) {
                log.debug(CLASSIFICATION_WITH_GUID_NOT_FOUND, (Object)classificationGuid);
                this.rollbackTransaction(this.g);
                continue;
            }
            Vertex storedClassification = (Vertex)vertexIterator.next();
            long storedClassificationVersion = (Long)((Map)this.g.V(new Object[]{storedClassification.id()}).elementMap(new String[]{"vertex--version"}).toList().get(0)).get("vertex--version");
            if (storedClassificationVersion >= graphContext.getToVertex().getVersion()) continue;
            this.addOrUpdatePropertiesVertex(storedClassification, graphContext.getToVertex());
            this.commitTransaction(this.g);
            break;
        }
    }

    public void deleteClassification(Set<GraphContext> classificationContext) {
        block2: for (GraphContext context : classificationContext) {
            Graph entityAndClassificationsGraph = (Graph)this.g.V(new Object[0]).has("vertex--guid", (Object)context.getFromVertex().getGuid()).bothE(new String[]{"Classification"}).subgraph(S).cap(S, new String[0]).next();
            Iterator edges = entityAndClassificationsGraph.edges(new Object[0]);
            while (edges.hasNext()) {
                Edge edge = (Edge)edges.next();
                String storedClassificationGuid = (String)((Map)this.g.E(new Object[]{edge.id()}).inV().elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid");
                if (!context.getToVertex().getGuid().equals(storedClassificationGuid)) continue;
                try {
                    this.g.V(new Object[0]).has("vertex--guid", (Object)storedClassificationGuid).drop().iterate();
                    this.g.E(new Object[]{edge.id()}).drop().iterate();
                    this.commitTransaction(this.g);
                    continue block2;
                }
                catch (Exception e) {
                    log.debug(DELETE_CLASSIFICATION_EXCEPTION, (Throwable)e);
                    this.rollbackTransaction(this.g);
                }
            }
        }
    }

    public void deleteEntity(String guid, Object version) {
        GraphTraversal vertex = this.g.V(new Object[0]).has("vertex--guid", (Object)guid);
        if (!vertex.hasNext()) {
            this.rollbackTransaction(this.g);
            log.debug(VERTEX_WITH_GUID_IS_NOT_PRESENT, (Object)guid);
            return;
        }
        this.g.V(new Object[0]).has("vertex--guid", (Object)guid).drop().iterate();
        this.commitTransaction(this.g);
        log.debug(VERTEX_WITH_GUID_DELETED, (Object)guid);
    }

    public void deleteRelationship(String guid) {
        GraphTraversal edge = this.g.E(new Object[0]).has("edge--guid", (Object)guid);
        if (!edge.hasNext()) {
            this.rollbackTransaction(this.g);
            log.debug(EDGE_WITH_GUID_DID_NOT_DELETE, (Object)guid);
            return;
        }
        this.g.E(new Object[]{((Edge)edge.next()).id()}).drop().iterate();
        this.commitTransaction(this.g);
        log.debug(EDGE_WITH_GUID_DELETED, (Object)guid);
    }

    private void addOrUpdatePropertiesEdge(LineageRelationship lineageRelationship) {
        Map<String, Object> properties = lineageRelationship.getProperties().entrySet().stream().collect(Collectors.toMap(e -> "vertex--InstanceProp" + (String)e.getKey(), Map.Entry::getValue));
        properties.values().remove(null);
        properties.computeIfAbsent("vertex--createTime", val -> lineageRelationship.getCreateTime());
        properties.computeIfAbsent("vertex--createdBy", val -> lineageRelationship.getCreatedBy());
        properties.computeIfAbsent("vertex--updateTime", val -> lineageRelationship.getUpdateTime());
        properties.computeIfAbsent("vertex--updatedBy", val -> lineageRelationship.getUpdatedBy());
        properties.computeIfAbsent("vertex--label", val -> lineageRelationship.getTypeDefName());
        properties.computeIfAbsent("vertex--version", val -> lineageRelationship.getVersion());
        properties.computeIfAbsent("vertex--metadataCollectionId", val -> lineageRelationship.getMetadataCollectionId());
        this.g.inject((Object[])new Map[]{properties}).as(PROPERTIES, new String[0]).V(new Object[]{lineageRelationship.getSourceEntity().getGuid()}).outE(new String[0]).where((Traversal)__.inV().hasId((Object)lineageRelationship.getTargetEntity().getGuid(), new Object[0])).as(EDGE, new String[0]).sideEffect((Traversal)__.select((String)PROPERTIES).unfold().as(KV, new String[0]).select(EDGE).property((Object)__.select((String)KV).by((Function)Column.keys), (Object)__.select((String)KV).by((Function)Column.values), new Object[0])).iterate();
    }

    private List<Vertex> findPathForOutputAsset(Vertex endingVertex, GraphTraversalSource g, Vertex startingVertex) {
        if (endingVertex == null) {
            return null;
        }
        ArrayList<Vertex> endVertices = new ArrayList<Vertex>();
        try {
            if (this.isEndColumn(g, endingVertex)) {
                endVertices.add(endingVertex);
            } else {
                List nextVertices = g.V(new Object[]{endingVertex.id()}).out(new String[]{"LineageMapping"}).toList();
                for (Vertex vertex : nextVertices) {
                    if (vertex.equals(startingVertex)) continue;
                    Optional.ofNullable(this.findPathForOutputAsset(vertex, g, endingVertex)).ifPresent(endVertices::addAll);
                }
            }
            this.commitTransaction(g);
            return endVertices;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug(VERTEX_NOT_FOUND, startingVertex.id(), startingVertex.property("vertex--displayName").value());
            }
            this.rollbackTransaction(g);
            return null;
        }
    }

    private boolean isEndColumn(GraphTraversalSource g, Vertex vertex) {
        String VERTEX = "vertex";
        GraphTraversal end = g.V(new Object[]{vertex.id()}).or(new Traversal[]{__.in((String[])new String[]{"AttributeForSchema"}).in(new String[]{"AssetSchemaType"}).has("vertex--label", P.within(Constants.DATA_FILE_AND_SUBTYPES)).aggregate(org.apache.tinkerpop.gremlin.process.traversal.Scope.local, "vertex"), __.in((String[])new String[]{"NestedSchemaAttribute"}).has("vertex--label", (Object)"RelationalTable").aggregate(org.apache.tinkerpop.gremlin.process.traversal.Scope.local, "vertex")}).select("vertex").unfold();
        return end.hasNext();
    }

    public LineageResponse lineage(Scope scope, String guid, String displayNameMustContain, boolean includeProcesses) {
        GraphTraversal vertexGraphTraversal = this.g.V(new Object[0]).has("vertex--guid", (Object)guid);
        if (!vertexGraphTraversal.hasNext()) {
            return new LineageResponse();
        }
        Optional<Object> lineageVerticesAndEdges = Optional.empty();
        switch (scope) {
            case END_TO_END: {
                lineageVerticesAndEdges = this.helper.endToEnd(guid, includeProcesses);
                break;
            }
            case ULTIMATE_SOURCE: {
                lineageVerticesAndEdges = this.helper.ultimateSource(guid);
                break;
            }
            case ULTIMATE_DESTINATION: {
                lineageVerticesAndEdges = this.helper.ultimateDestination(guid);
                break;
            }
            case VERTICAL: {
                lineageVerticesAndEdges = this.helper.verticalLineage(guid);
            }
        }
        if (lineageVerticesAndEdges.isPresent() && !displayNameMustContain.isEmpty()) {
            this.helper.filterDisplayName((LineageVerticesAndEdges)lineageVerticesAndEdges.get(), displayNameMustContain);
        }
        return new LineageResponse((LineageVerticesAndEdges)lineageVerticesAndEdges.orElse(null));
    }

    public LineageVertexResponse getEntityDetails(String guid) {
        LineageVertex lineageVertex = this.helper.getLineageVertexByGuid(guid);
        return new LineageVertexResponse(lineageVertex);
    }

    public boolean isEntityInGraph(String guid) {
        return !this.g.V(new Object[0]).has("vertex--guid", (Object)guid).toList().isEmpty();
    }

    private void commitTransaction(GraphTraversalSource g) {
        if (this.graphFactory.isSupportingTransactions()) {
            g.tx().commit();
        }
    }

    private void rollbackTransaction(GraphTraversalSource g) {
        if (this.graphFactory.isSupportingTransactions()) {
            g.tx().rollback();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineageGraphConnector)) {
            return false;
        }
        LineageGraphConnector other = (LineageGraphConnector)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LineageGraphConnectorHelper this$helper = this.helper;
        LineageGraphConnectorHelper other$helper = other.helper;
        if (this$helper == null ? other$helper != null : !this$helper.equals(other$helper)) {
            return false;
        }
        GraphTraversalSource this$g = this.g;
        GraphTraversalSource other$g = other.g;
        if (this$g == null ? other$g != null : !this$g.equals(other$g)) {
            return false;
        }
        GraphFactory this$graphFactory = this.graphFactory;
        GraphFactory other$graphFactory = other.graphFactory;
        if (this$graphFactory == null ? other$graphFactory != null : !this$graphFactory.equals(other$graphFactory)) {
            return false;
        }
        AuditLog this$auditLog = this.auditLog;
        AuditLog other$auditLog = other.auditLog;
        return !(this$auditLog == null ? other$auditLog != null : !this$auditLog.equals(other$auditLog));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LineageGraphConnector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LineageGraphConnectorHelper $helper = this.helper;
        result = result * 59 + ($helper == null ? 43 : $helper.hashCode());
        GraphTraversalSource $g = this.g;
        result = result * 59 + ($g == null ? 43 : $g.hashCode());
        GraphFactory $graphFactory = this.graphFactory;
        result = result * 59 + ($graphFactory == null ? 43 : $graphFactory.hashCode());
        AuditLog $auditLog = this.auditLog;
        result = result * 59 + ($auditLog == null ? 43 : $auditLog.hashCode());
        return result;
    }
}

