/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory;

import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.GraphConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingFactory<C extends Element> {
    private static final Logger log = LoggerFactory.getLogger(IndexingFactory.class);
    private static final String AWAIT_GRAPH_INDEX_STATUS_ENABLED = "{} awaitGraphIndexStatus ENABLED for {}";
    private static final String CAUGHT_INTERRUPTED_EXCEPTION_MESSAGE = "caught interrupted exception from awaitGraphIndexStatus";
    private static final String CAUGHT_INTERRUPTED_EXCEPTION = "{} caught interrupted exception from awaitGraphIndexStatus ENABLED {}";
    private JanusGraph graph;
    AuditLog auditLog;

    protected void createCompositeIndexForProperty(String propertyName, String propertyKeyName, boolean unique, JanusGraph graph, Class<C> type) {
        String indexName = null;
        if (Vertex.class.equals(type)) {
            indexName = "vertexIndexComposite" + propertyKeyName;
        } else if (Edge.class.equals(type)) {
            indexName = "edgeIndexComposite" + propertyKeyName;
        }
        log.debug("INDEX to be created {}", (Object)indexName);
        this.graph = graph;
        this.checkIndex(indexName, propertyName, propertyKeyName, unique, type);
    }

    private void checkIndex(String indexName, String propertyName, String propertyKeyName, boolean unique, Class<C> type) {
        JanusGraphManagement management = this.graph.openManagement();
        JanusGraphIndex existingIndex = management.getGraphIndex(indexName);
        if (existingIndex != null) {
            log.debug("{} index already exists", (Object)indexName);
            if (this.auditLog != null) {
                this.auditLog.logMessage(indexName + " index already exists", JanusConnectorErrorCode.INDEX_ALREADY_EXISTS.getMessageDefinition());
            }
            management.rollback();
            return;
        }
        this.createIndex(management, indexName, propertyName, propertyKeyName, unique, type);
    }

    private void createIndex(JanusGraphManagement management, String indexName, String propertyName, String propertyKeyName, boolean unique, Class<C> type) {
        PropertyKey propertyKey;
        Class<?> clazz;
        String className = (String)GraphConstants.immutableCorePropertyTypes.get((Object)propertyName);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            log.error("class not found for property {}", (Object)propertyName);
            log.error("NO INDEX created for property {}", (Object)propertyName);
            this.auditLog.logMessage("class not found for property " + propertyName, JanusConnectorErrorCode.INDEX_NOT_CREATED.getMessageDefinition());
            return;
        }
        boolean oldKey = false;
        PropertyKey existingPropertyKey = management.getPropertyKey(propertyKeyName);
        if (existingPropertyKey != null) {
            log.debug("property key already exists for property {}", (Object)propertyKeyName);
            propertyKey = existingPropertyKey;
            oldKey = true;
        } else {
            log.debug("make property key for property {}", (Object)propertyKeyName);
            propertyKey = management.makePropertyKey(propertyKeyName).dataType(clazz).make();
        }
        this.buildIndex(management, indexName, propertyKey, unique, oldKey, type);
    }

    private void buildIndex(JanusGraphManagement management, String indexName, PropertyKey propertyKey, boolean unique, boolean oldKey, Class<C> type) {
        if (type.equals(Vertex.class)) {
            JanusGraphManagement.IndexBuilder indexBuilder = management.buildIndex(indexName, type).addKey(propertyKey);
            if (unique) {
                indexBuilder.unique();
            }
            JanusGraphIndex index = indexBuilder.buildCompositeIndex();
            if (unique) {
                management.setConsistency((JanusGraphSchemaElement)index, ConsistencyModifier.LOCK);
            }
            management.commit();
        } else if (type.equals(Edge.class)) {
            JanusGraphManagement.IndexBuilder indexBuilder = management.buildIndex(indexName, Edge.class).addKey(propertyKey);
            indexBuilder.buildCompositeIndex();
            management.commit();
        } else {
            management.rollback();
            return;
        }
        this.enableIndex(management, indexName, oldKey);
    }

    private void enableIndex(JanusGraphManagement management, String indexName, boolean oldKey) {
        String methodName = "enableIndex";
        try {
            if (oldKey) {
                ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.REGISTERED})).call();
                management = this.graph.openManagement();
                JanusGraphIndex index = management.getGraphIndex(indexName);
                management.updateIndex((Index)index, SchemaAction.REINDEX);
                management.commit();
            }
            log.debug(AWAIT_GRAPH_INDEX_STATUS_ENABLED, (Object)"enableIndex", (Object)indexName);
            ((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
        }
        catch (InterruptedException e) {
            log.error(CAUGHT_INTERRUPTED_EXCEPTION, (Object)"enableIndex", (Object)e);
            if (this.auditLog != null) {
                this.auditLog.logMessage(CAUGHT_INTERRUPTED_EXCEPTION_MESSAGE, JanusConnectorErrorCode.INDEX_NOT_ENABLED.getMessageDefinition());
            }
            management.rollback();
        }
    }
}

