/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageRelationship;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageServerErrorCode;
import org.odpi.openmetadata.governanceservers.openlineage.graph.LineageGraphConnectorBase;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageVertexResponse;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory.GraphFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphConnectorHelper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphTransactionManager;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageGraphConnector
extends LineageGraphConnectorBase {
    public static final String KV = "kv";
    private static final Logger log = LoggerFactory.getLogger(LineageGraphConnector.class);
    public static final String CLOSE_LINEAGE_GRAPH_EXCEPTION = "Exception while closing lineage graph";
    public static final String EXCEPTION_WHILE_CLOSING_LINEAGE_GRAPH_MESSAGE = "Exception while closing lineage graph: ";
    public static final String CLOSE_LINEAGE_GRAPH_EXCEPTION_MESSAGE = "Exception while closing lineage graph: ";
    public static final String UNABLE_TO_ADD_PROPERTIES = "Unable to add properties on vertex from entity with type ";
    public static final String AND_GUID = " and guid ";
    public static final String UNABLE_TO_CREATE_EDGE_WITH_LABEL = "Unable to create edge with label ";
    public static final String FROM = "from";
    public static final String UNABLE_TO_CREATE_VERTEX_WITH_TYPE = "Unable to create vertex with type ";
    public static final String ASSET_LINEAGE_VARIABLES = "ASSET_LINEAGE_VARIABLES";
    public static final String INPUT_PORT = "INPUT_PORT";
    public static final String OLS_HAS_CORRESPONDING_ELEMENTS = "OLS has added the corresponding subProcess node and edges for input column {}, output column {} and process {} ";
    public static final String VERTICES_AND_RELATIONSHIP_CREATION_EXCEPTION = "An exception happened when trying to create vertices and relationships in LineageGraph. The error is";
    public static final String COULD_NOT_DROP_EDGE = "Could not drop edge ";
    public static final String PROPERTIES = "properties";
    public static final String V = "v";
    public static final String VERTEX_GUID_NOT_FOUND_WHEN_UPDATE = "When trying to update, vertex with guid {} was not found  ";
    public static final String PROPERTIES_UPDATE_EXCEPTION = "An exception happened during update of the properties with exception: ";
    public static final String UNABLE_TO_ADD_PROPERTIES_ON_EDGE_FROM_RELATIONSHIP_WITH_TYPE = "Unable to add properties on edge from relationship with type ";
    public static final String EDGE_GUID_NOT_FOUND_WHEN_UPDATE = "When trying to update, edge with guid {} was not found";
    public static final String CLASSIFICATION_WITH_GUID_NOT_FOUND = "Classification with guid {} not found";
    public static final String S = "s";
    public static final String DELETE_CLASSIFICATION_EXCEPTION = "An exception happened during delete of classifications with error:";
    public static final String VERTEX_WITH_GUID_IS_NOT_PRESENT = "Vertex with guid is not present {}";
    public static final String VERTEX_WITH_GUID_DELETED = "Vertex with guid {} deleted";
    public static final String EDGE_WITH_GUID_DID_NOT_DELETE = "Edge with guid did not delete {}";
    public static final String EDGE_WITH_GUID_DELETED = "Edge with guid {} deleted";
    public static final String EDGE = "edge";
    public static final String VERTEX_NOT_FOUND = "Vertex does not exist with guid {} and display name {}";
    public static final String THE_LINEAGE_GRAPH_COULD_NOT_BE_INITIALIZED_DUE_TO_AN_ERROR = "The Lineage graph could not be initialized due to an error";
    public static final String SOMETHING_WENT_WRONG_WHEN_TRYING_TO_MAP_A_PROCESS = "Something went wrong when trying to map a process.";
    public static final String SOMETHING_WENT_WRONG_WHEN_TRYING_TO_MAP_A_PROCESS_THE_ERROR_IS = "Something went wrong when trying to map a process. The error is: ";
    public static final String FAILED_TO_UPDATE_CLASSIFICATION_WITH_GUID = "failed to update classification with guid";
    private LineageGraphConnectorHelper helper;
    private GraphFactory graphFactory;
    private AuditLog auditLog;

    public void initializeGraphDB(AuditLog auditLog) throws OpenLineageException {
        this.auditLog = auditLog;
        try {
            this.graphFactory = new GraphFactory();
            this.graphFactory.openGraph(this.connectionProperties.getConnectorType().getConnectorProviderClassName(), this.connectionProperties.getConfigurationProperties(), auditLog);
            this.helper = new LineageGraphConnectorHelper(this.graphFactory, this.graphFactory.isSupportingTransactions());
        }
        catch (JanusConnectorException error) {
            log.error(THE_LINEAGE_GRAPH_COULD_NOT_BE_INITIALIZED_DUE_TO_AN_ERROR, (Throwable)error);
            throw new OpenLineageException(500, error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction());
        }
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        try {
            this.graphFactory.closeGraph();
            super.disconnect();
        }
        catch (ConnectorCheckedException e) {
            log.error("Exception while closing lineage graph: ", (Throwable)e);
            this.auditLog.logException(CLOSE_LINEAGE_GRAPH_EXCEPTION, JanusConnectorErrorCode.GRAPH_DISCONNECT_ERROR.getMessageDefinition(), (Throwable)e);
            throw e;
        }
    }

    public void performLineageGraphJob() {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        try {
            List vertices = g.V(new Object[0]).has("vertex--label", (Object)"Process").toList();
            ArrayList<String> guidList = new ArrayList<String>();
            for (Vertex v : vertices) {
                String s = ((Map)g.V(new Object[]{v.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid").toString();
                guidList.add(s);
            }
            this.commitTransaction(g);
            g = this.graphFactory.getGraphTraversalSource();
            for (String guid : guidList) {
                this.findInputColumns(g, guid);
            }
            this.commitTransaction(g);
        }
        catch (Exception e) {
            log.error(SOMETHING_WENT_WRONG_WHEN_TRYING_TO_MAP_A_PROCESS_THE_ERROR_IS, (Throwable)e);
            this.auditLog.logException(SOMETHING_WENT_WRONG_WHEN_TRYING_TO_MAP_A_PROCESS, JanusConnectorErrorCode.PROCESS_MAPPING_ERROR.getMessageDefinition(), (Throwable)e);
            this.rollbackTransaction(g);
        }
    }

    public void saveAssetLineageUpdateTime(Long lastUpdateTime) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        GraphTraversal lineageVariables = g.V(new Object[0]).hasLabel(ASSET_LINEAGE_VARIABLES, new String[0]);
        if (!lineageVariables.hasNext()) {
            g.addV(ASSET_LINEAGE_VARIABLES).property((Object)"assetLineageLastUpdateTimestamp", (Object)lastUpdateTime, new Object[0]).next();
        } else {
            g.V(new Object[]{((Vertex)lineageVariables.next()).id()}).property((Object)"assetLineageLastUpdateTimestamp", (Object)lastUpdateTime, new Object[0]).next();
        }
        this.commitTransaction(g);
    }

    public Optional<Long> getAssetLineageUpdateTime() {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        GraphTraversal lineageVariables = g.V(new Object[0]).hasLabel(ASSET_LINEAGE_VARIABLES, new String[0]).valueMap(new String[0]);
        if (lineageVariables.hasNext()) {
            Map next = (Map)lineageVariables.next();
            if (next.containsKey("assetLineageLastUpdateTimestamp")) {
                return Optional.of((Long)((List)next.get("assetLineageLastUpdateTimestamp")).get(0));
            }
        } else {
            return this.getLineageUpdateTimeFromGraphVariables(g);
        }
        return Optional.empty();
    }

    private Optional<Long> getLineageUpdateTimeFromGraphVariables(GraphTraversalSource g) {
        try {
            return g.getGraph().variables().get("assetLineageLastUpdateTimestamp");
        }
        catch (UnsupportedOperationException e) {
            return Optional.empty();
        }
    }

    private void findInputColumns(GraphTraversalSource g, String guid) {
        List inputPathsForColumns = g.V(new Object[0]).has("vertex--guid", (Object)guid).out(new String[]{"ProcessPort"}).out(new String[]{"PortDelegation"}).has("PortImplementation", "vertex--InstancePropportType", (Object)INPUT_PORT).out(new String[]{"PortSchema"}).out(new String[]{"AttributeForSchema"}).in(new String[]{"LineageMapping"}).or(new Traversal[]{__.in((String[])new String[]{"AttributeForSchema"}).in(new String[]{"AssetSchemaType"}).has("vertex--label", P.within(Constants.DATA_FILE_AND_SUBTYPES)), __.in((String[])new String[]{"NestedSchemaAttribute"}).has("vertex--label", (Object)"RelationalTable"), __.in((String[])new String[]{"AttributeForSchema"}).in(new String[]{"SchemaTypeOption"}).in(new String[]{"AssetSchemaType"}).has("vertex--label", (Object)"Topic")}).toList();
        this.commitTransaction(g);
        Vertex process = (Vertex)g.V(new Object[0]).has("vertex--guid", (Object)guid).next();
        inputPathsForColumns.forEach(columnIn -> this.findOutputColumns(g, (Vertex)columnIn, process));
    }

    private void findOutputColumns(GraphTraversalSource g, Vertex columnIn, Vertex process) {
        List schemaElementVertices = g.V(new Object[0]).has("vertex--guid", ((Map)g.V(new Object[]{columnIn.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid")).out(new String[]{"LineageMapping"}).toList();
        if (schemaElementVertices != null) {
            ArrayList<Vertex> columnOutList = new ArrayList<Vertex>();
            for (Vertex schemaElementVertex : schemaElementVertices) {
                Vertex vertexToStart = this.isSchemaElementLinkedToProcess(g, schemaElementVertex, process);
                if (vertexToStart != null) {
                    columnOutList.addAll(this.findPathForOutputAsset(vertexToStart, g, columnIn));
                }
                for (Vertex columnOut : columnOutList) {
                    this.addNodesAndEdgesForQuerying(columnIn, columnOut, process);
                }
            }
        }
    }

    private Vertex isSchemaElementLinkedToProcess(GraphTraversalSource g, Vertex schemaElementVertex, Vertex process) {
        List initialProcess = g.V(new Object[]{schemaElementVertex.id()}).bothE(new String[]{"AttributeForSchema"}).otherV().inE(new String[]{"PortSchema"}).otherV().inE(new String[]{"PortDelegation"}).otherV().inE(new String[]{"ProcessPort"}).otherV().has("vertex--guid", ((Map)g.V(new Object[]{process.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid")).toList();
        this.commitTransaction(g);
        if (!initialProcess.isEmpty()) {
            return schemaElementVertex;
        }
        return null;
    }

    private boolean isColumnEmpty(Vertex column) {
        return column == null || !StringUtils.isNotEmpty((CharSequence)this.getGuid(column));
    }

    private void addNodesAndEdgesForQuerying(Vertex columnIn, Vertex columnOut, Vertex process) {
        if (this.isColumnEmpty(columnIn) || this.isColumnEmpty(columnOut)) {
            return;
        }
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        String processGuid = this.getGuid(process);
        String columnInGuid = this.getGuid(columnIn);
        String columnOutGuid = this.getGuid(columnOut);
        String processName = ((Map)g.V(new Object[]{process.id()}).elementMap(new String[]{"vertex--InstancePropdisplayName"}).toList().get(0)).get("vertex--InstancePropdisplayName").toString();
        GraphTraversal t = g.V(new Object[]{columnIn.id()}).outE(new String[]{"ColumnDataFlow"}).inV().has("columnOutGuid", (Object)columnOutGuid).has("processGuid", (Object)processGuid);
        if (!t.hasNext()) {
            Vertex subProcess = (Vertex)g.addV("subProcess").property((Object)"vertex--nodeID", (Object)UUID.randomUUID().toString(), new Object[0]).property((Object)"vertex--displayName", (Object)processName, new Object[0]).property((Object)"processGuid", (Object)processGuid, new Object[0]).property((Object)"columnInGuid", (Object)columnInGuid, new Object[0]).property((Object)"columnOutGuid", (Object)columnOutGuid, new Object[0]).next();
            this.commitTransaction(g);
            g = this.graphFactory.getGraphTraversalSource();
            g.V(new Object[]{columnIn.id()}).addE("ColumnDataFlow").to((Traversal)__.V((Object[])new Object[]{subProcess.id()})).next();
            g.V(new Object[]{subProcess.id()}).addE("ColumnDataFlow").to((Traversal)__.V((Object[])new Object[]{columnOut.id()})).next();
            g.V(new Object[]{subProcess.id()}).addE("includedIn").to((Traversal)__.V((Object[])new Object[]{process.id()})).next();
            this.commitTransaction(g);
            this.addAssetToProcessEdges(columnIn, process, columnOut);
            log.info(OLS_HAS_CORRESPONDING_ELEMENTS, new Object[]{columnInGuid, columnOutGuid, processGuid});
        }
    }

    private void addAssetToProcessEdges(Vertex columnIn, Vertex process, Vertex columnOut) {
        GraphTraversal tableVertex;
        Optional<Vertex> assetOut;
        GraphTraversal tableVertex2;
        GraphTraversalSource localG = this.graphFactory.getGraphTraversalSource();
        Optional<Vertex> assetIn = this.getAsset(columnIn);
        if (assetIn.isPresent() && !(tableVertex2 = localG.V(new Object[]{assetIn.get().id()}).outE(new String[]{"TableDataFlow"}).inV().hasId(process.id(), new Object[0])).hasNext()) {
            localG.V(new Object[]{assetIn.get().id()}).addE("TableDataFlow").to((Traversal)__.V((Object[])new Object[]{process.id()})).next();
        }
        if ((assetOut = this.getAsset(columnOut)).isPresent() && !(tableVertex = localG.V(new Object[]{assetOut.get().id()}).inE(new String[]{"TableDataFlow"}).outV().hasId(process.id(), new Object[0])).hasNext()) {
            localG.V(new Object[]{process.id()}).addE("TableDataFlow").to((Traversal)__.V((Object[])new Object[]{assetOut.get().id()})).next();
        }
        this.commitTransaction(localG);
    }

    private String getGuid(Vertex vertex) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        String guid = ((Map)g.V(new Object[]{vertex.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid").toString();
        this.commitTransaction(g);
        return guid;
    }

    private Optional<Vertex> getAsset(Vertex asset) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        Object vertexGuid = ((Map)g.V(new Object[]{asset.id()}).elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid");
        Vertex graphVertex = (Vertex)g.V(new Object[0]).has("vertex--guid", vertexGuid).next();
        Object vertexId = graphVertex.id();
        Iterator result = null;
        if ("RelationalColumn".equalsIgnoreCase(asset.label())) {
            result = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"RelationalTable", (String[])new String[0])});
        }
        if ("TabularColumn".equalsIgnoreCase(asset.label()) || "TabularFileColumn".equalsIgnoreCase(asset.label())) {
            result = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(2).or(new Traversal[]{__.hasLabel((P)P.within(Constants.DATA_FILE_AND_SUBTYPES))});
        }
        if ("EventSchemaAttribute".equalsIgnoreCase(asset.label())) {
            result = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(3).or(new Traversal[]{__.hasLabel((String)"Topic", (String[])new String[0])});
        }
        this.commitTransaction(g);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.of((Vertex)result.next());
    }

    public void storeToGraph(Set<GraphContext> graphContext) {
        graphContext.forEach(entry -> {
            try {
                LineageEntity fromEntity = entry.getFromVertex();
                LineageEntity toEntity = entry.getToVertex();
                this.upsertToGraph(fromEntity, toEntity, entry.getRelationshipType(), entry.getRelationshipGuid());
            }
            catch (Exception e) {
                log.error(VERTICES_AND_RELATIONSHIP_CREATION_EXCEPTION, (Throwable)e);
            }
        });
    }

    public void updateNeighbours(String nodeGUID, Set<String> neighboursGUIDS) {
        List<String> existingNeighboursGUIDs = this.getAllNeighbours(nodeGUID);
        if (this.isDifferentGraphContext(neighboursGUIDS, existingNeighboursGUIDs)) {
            this.removeObsoleteEdges(nodeGUID, neighboursGUIDS, existingNeighboursGUIDs);
        }
    }

    private List<String> getAllNeighbours(String entityGUID) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        GraphTraversal exitingVertices = g.V(new Object[0]).has("vertex--guid", (Object)entityGUID).bothE(new String[0]).otherV();
        ArrayList<String> existingGUIDs = new ArrayList<String>();
        while (exitingVertices.hasNext()) {
            Map valueMap = (Map)g.V(new Object[]{((Vertex)exitingVertices.next()).id()}).valueMap(new String[]{"vertex--guid"}).next();
            if (!valueMap.containsKey("vertex--guid")) continue;
            existingGUIDs.addAll((List)valueMap.get("vertex--guid"));
        }
        this.commitTransaction(g);
        return existingGUIDs;
    }

    private boolean isDifferentGraphContext(Set<String> newVertices, List<String> neighboursGUIDs) {
        return neighboursGUIDs.size() != newVertices.size() || !neighboursGUIDs.containsAll(newVertices);
    }

    private void removeObsoleteEdges(String entityGUID, Set<String> newVertices, List<String> neighboursGUIDs) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        Function<Edge, GraphTraversal> dropEdgeFromGraph = e -> g.E(new Object[]{e.id()}).drop().iterate();
        List obsoleteNeighbours = neighboursGUIDs.stream().filter(existingVertex -> !newVertices.contains(existingVertex)).collect(Collectors.toList());
        if (obsoleteNeighbours.isEmpty()) {
            return;
        }
        GraphTraversal existingEdges = g.V(new Object[0]).has("vertex--guid", (Object)entityGUID).bothE(new String[0]);
        while (existingEdges.hasNext()) {
            Edge edge = (Edge)existingEdges.next();
            List inVertexGuid = (List)((Map)g.V(new Object[]{edge.inVertex()}).valueMap(new String[]{"vertex--guid"}).next()).get("vertex--guid");
            List outVertexGuid = (List)((Map)g.V(new Object[]{edge.outVertex()}).valueMap(new String[]{"vertex--guid"}).next()).get("vertex--guid");
            if (!obsoleteNeighbours.containsAll(inVertexGuid) && !obsoleteNeighbours.containsAll(outVertexGuid)) continue;
            LineageGraphTransactionManager.commit(this.graphFactory, g, dropEdgeFromGraph, edge, COULD_NOT_DROP_EDGE + edge.id());
        }
    }

    private void upsertToGraph(LineageEntity fromEntity, LineageEntity toEntity, String relationshipLabel, String relationshipGuid) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        Vertex to = this.addVertex(g, toEntity);
        Vertex from = this.addVertex(g, fromEntity);
        this.addEdge(g, relationshipLabel, relationshipGuid, to, from);
        if (this.graphFactory.isSupportingTransactions()) {
            try {
                g.tx().commit();
            }
            catch (Exception e) {
                log.error("could not create things upsert to graph vertex {} {}, edge {}", new Object[]{fromEntity.getGuid(), toEntity.getGuid(), relationshipGuid});
                g.tx().rollback();
            }
        }
    }

    private Vertex addVertex(GraphTraversalSource g, LineageEntity toEntity) {
        Map<String, Object> toEntityProperties = this.getProperties(toEntity);
        GraphTraversal objectVertexGraphTraversal = __.addV((String)toEntity.getTypeDefName());
        objectVertexGraphTraversal.property((Object)"vertex--guid", (Object)toEntity.getGuid(), new Object[0]);
        for (Map.Entry<String, Object> propertiesEntry : toEntityProperties.entrySet()) {
            objectVertexGraphTraversal.property((Object)propertiesEntry.getKey(), propertiesEntry.getValue(), new Object[0]);
        }
        return (Vertex)g.V(new Object[0]).has("vertex--guid", (Object)toEntity.getGuid()).fold().coalesce(new Traversal[]{__.unfold(), objectVertexGraphTraversal}).next();
    }

    private void addEdge(GraphTraversalSource g, String relationshipLabel, String relationshipGuid, Vertex to, Vertex from) {
        g.V(new Object[]{from.id()}).as(FROM, new String[0]).V(new Object[]{to.id()}).coalesce(new Traversal[]{__.inE((String[])new String[]{relationshipLabel}).where((Traversal)__.outV().as(FROM, new String[0])), __.addE((String)relationshipLabel).from(FROM)}).property((Object)"edge--guid", (Object)relationshipGuid, new Object[0]).next();
    }

    private void addOrUpdatePropertiesVertex(GraphTraversalSource g, Vertex vertex, LineageEntity lineageEntity) {
        Map<String, Object> properties = this.getProperties(lineageEntity);
        g.inject((Object[])new Map[]{properties}).unfold().as(PROPERTIES, new String[0]).V(new Object[]{vertex.id()}).as(V, new String[0]).sideEffect((Traversal)__.select((String)PROPERTIES).unfold().as(KV, new String[0]).select(V).property((Object)__.select((String)KV).by((Function)Column.keys), (Object)__.select((String)KV).by((Function)Column.values), new Object[0])).iterate();
    }

    private Map<String, Object> getProperties(LineageEntity lineageEntity) {
        Map<String, Object> properties = lineageEntity.getProperties().entrySet().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)((CharSequence)e.getValue()))).collect(Collectors.toMap(e -> "vertex--InstanceProp" + (String)e.getKey(), Map.Entry::getValue));
        properties.computeIfAbsent("vertex--createTime", val -> lineageEntity.getCreateTime());
        properties.computeIfAbsent("vertex--createdBy", val -> lineageEntity.getCreatedBy());
        properties.computeIfAbsent("vertex--updateTime", val -> lineageEntity.getUpdateTime());
        properties.computeIfAbsent("vertex--updatedBy", val -> lineageEntity.getUpdatedBy());
        properties.computeIfAbsent("vertex--label", val -> lineageEntity.getTypeDefName());
        properties.computeIfAbsent("vertex--version", val -> lineageEntity.getVersion());
        properties.computeIfAbsent("vertex--metadataCollectionId", val -> lineageEntity.getMetadataCollectionId());
        return properties;
    }

    public void updateEntity(LineageEntity lineageEntity) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        GraphTraversal vertex = g.V(new Object[0]).has("vertex--guid", (Object)lineageEntity.getGuid());
        if (!vertex.hasNext()) {
            log.debug(VERTEX_GUID_NOT_FOUND_WHEN_UPDATE, (Object)lineageEntity.getGuid());
            this.rollbackTransaction(g);
            return;
        }
        LineageGraphTransactionManager.commit(this.graphFactory, g, this::addOrUpdatePropertiesVertex, g, (Vertex)vertex.next(), lineageEntity, PROPERTIES_UPDATE_EXCEPTION);
    }

    public void upsertRelationship(LineageRelationship lineageRelationship) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        LineageEntity firstEnd = lineageRelationship.getSourceEntity();
        LineageEntity secondEnd = lineageRelationship.getTargetEntity();
        this.upsertToGraph(firstEnd, secondEnd, lineageRelationship.getTypeDefName(), lineageRelationship.getGuid());
        BiConsumer<GraphTraversalSource, LineageRelationship> addOrUpdatePropertiesEdge = this::addOrUpdatePropertiesEdge;
        LineageGraphTransactionManager.commit(this.graphFactory, g, addOrUpdatePropertiesEdge, g, lineageRelationship, UNABLE_TO_ADD_PROPERTIES_ON_EDGE_FROM_RELATIONSHIP_WITH_TYPE + lineageRelationship.getTypeDefName() + AND_GUID + lineageRelationship.getGuid());
    }

    public void updateRelationship(LineageRelationship lineageRelationship) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        GraphTraversal edge = g.E(new Object[0]).has("edge--guid", (Object)lineageRelationship.getGuid());
        if (!edge.hasNext()) {
            log.debug(EDGE_GUID_NOT_FOUND_WHEN_UPDATE, (Object)lineageRelationship.getGuid());
            this.rollbackTransaction(g);
            return;
        }
        LineageGraphTransactionManager.commit(this.graphFactory, g, this::addOrUpdatePropertiesEdge, g, lineageRelationship, PROPERTIES_UPDATE_EXCEPTION);
    }

    public void updateClassification(Set<GraphContext> classificationContext) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        for (GraphContext graphContext : classificationContext) {
            String classificationGuid = graphContext.getToVertex().getGuid();
            GraphTraversal vertexIterator = g.V(new Object[0]).has("vertex--guid", (Object)classificationGuid);
            if (!vertexIterator.hasNext()) {
                log.debug(CLASSIFICATION_WITH_GUID_NOT_FOUND, (Object)classificationGuid);
                this.rollbackTransaction(g);
                continue;
            }
            Vertex storedClassification = (Vertex)vertexIterator.next();
            long storedClassificationVersion = (Long)((Map)g.V(new Object[]{storedClassification.id()}).elementMap(new String[]{"vertex--version"}).toList().get(0)).get("vertex--version");
            if (storedClassificationVersion >= graphContext.getToVertex().getVersion()) continue;
            this.addOrUpdatePropertiesVertex(g, storedClassification, graphContext.getToVertex());
            LineageGraphTransactionManager.commit(this.graphFactory, g, this::addOrUpdatePropertiesVertex, g, storedClassification, graphContext.getToVertex(), FAILED_TO_UPDATE_CLASSIFICATION_WITH_GUID + classificationGuid);
        }
    }

    public void deleteClassification(Set<GraphContext> classificationContext) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        block0: for (GraphContext context : classificationContext) {
            Graph entityAndClassificationsGraph = (Graph)g.V(new Object[0]).has("vertex--guid", (Object)context.getFromVertex().getGuid()).bothE(new String[]{"Classification"}).subgraph(S).cap(S, new String[0]).next();
            Iterator edges = entityAndClassificationsGraph.edges(new Object[0]);
            while (edges.hasNext()) {
                Edge edge = (Edge)edges.next();
                String storedClassificationGuid = (String)((Map)g.E(new Object[]{edge.id()}).inV().elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid");
                if (!context.getToVertex().getGuid().equals(storedClassificationGuid)) continue;
                LineageGraphTransactionManager.commit(this.graphFactory, g, this::dropEdge, g, edge, storedClassificationGuid, DELETE_CLASSIFICATION_EXCEPTION);
                continue block0;
            }
        }
    }

    private void dropEdge(GraphTraversalSource g, Edge edge, String storedClassificationGuid) {
        g.V(new Object[0]).has("vertex--guid", (Object)storedClassificationGuid).drop().iterate();
        g.E(new Object[]{edge.id()}).drop().iterate();
    }

    public void deleteEntity(String guid, Object version) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        GraphTraversal vertex = g.V(new Object[0]).has("vertex--guid", (Object)guid);
        if (!vertex.hasNext()) {
            this.rollbackTransaction(g);
            log.debug(VERTEX_WITH_GUID_IS_NOT_PRESENT, (Object)guid);
            return;
        }
        g.V(new Object[0]).has("vertex--guid", (Object)guid).drop().iterate();
        this.commitTransaction(g);
        log.debug(VERTEX_WITH_GUID_DELETED, (Object)guid);
    }

    public void deleteRelationship(String guid) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        GraphTraversal edge = g.E(new Object[0]).has("edge--guid", (Object)guid);
        if (!edge.hasNext()) {
            this.rollbackTransaction(g);
            log.debug(EDGE_WITH_GUID_DID_NOT_DELETE, (Object)guid);
            return;
        }
        g.E(new Object[]{((Edge)edge.next()).id()}).drop().iterate();
        this.commitTransaction(g);
        log.debug(EDGE_WITH_GUID_DELETED, (Object)guid);
    }

    private void addOrUpdatePropertiesEdge(GraphTraversalSource g, LineageRelationship lineageRelationship) {
        Map<String, Object> properties = lineageRelationship.getProperties().entrySet().stream().collect(Collectors.toMap(e -> "vertex--InstanceProp" + (String)e.getKey(), Map.Entry::getValue));
        properties.values().remove(null);
        properties.computeIfAbsent("vertex--createTime", val -> lineageRelationship.getCreateTime());
        properties.computeIfAbsent("vertex--createdBy", val -> lineageRelationship.getCreatedBy());
        properties.computeIfAbsent("vertex--updateTime", val -> lineageRelationship.getUpdateTime());
        properties.computeIfAbsent("vertex--updatedBy", val -> lineageRelationship.getUpdatedBy());
        properties.computeIfAbsent("vertex--label", val -> lineageRelationship.getTypeDefName());
        properties.computeIfAbsent("vertex--version", val -> lineageRelationship.getVersion());
        properties.computeIfAbsent("vertex--metadataCollectionId", val -> lineageRelationship.getMetadataCollectionId());
        g.inject((Object[])new Map[]{properties}).as(PROPERTIES, new String[0]).V(new Object[]{lineageRelationship.getSourceEntity().getGuid()}).outE(new String[0]).where((Traversal)__.inV().hasId((Object)lineageRelationship.getTargetEntity().getGuid(), new Object[0])).as(EDGE, new String[0]).sideEffect((Traversal)__.select((String)PROPERTIES).unfold().as(KV, new String[0]).select(EDGE).property((Object)__.select((String)KV).by((Function)Column.keys), (Object)__.select((String)KV).by((Function)Column.values), new Object[0])).iterate();
    }

    private List<Vertex> findPathForOutputAsset(Vertex endingVertex, GraphTraversalSource g, Vertex startingVertex) {
        if (endingVertex == null) {
            return null;
        }
        ArrayList<Vertex> endVertices = new ArrayList<Vertex>();
        try {
            if (this.isEndColumn(g, endingVertex)) {
                endVertices.add(endingVertex);
            } else {
                List nextVertices = g.V(new Object[]{endingVertex.id()}).out(new String[]{"LineageMapping"}).toList();
                for (Vertex vertex : nextVertices) {
                    if (vertex.equals(startingVertex)) continue;
                    Optional.ofNullable(this.findPathForOutputAsset(vertex, g, endingVertex)).ifPresent(endVertices::addAll);
                }
            }
            return endVertices;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug(VERTEX_NOT_FOUND, startingVertex.id(), startingVertex.property("vertex--displayName").value());
            }
            return null;
        }
    }

    private boolean isEndColumn(GraphTraversalSource g, Vertex vertex) {
        String VERTEX = "vertex";
        GraphTraversal end = g.V(new Object[]{vertex.id()}).or(new Traversal[]{__.in((String[])new String[]{"AttributeForSchema"}).in(new String[]{"AssetSchemaType"}).has("vertex--label", P.within(Constants.DATA_FILE_AND_SUBTYPES)).aggregate(org.apache.tinkerpop.gremlin.process.traversal.Scope.local, "vertex"), __.in((String[])new String[]{"NestedSchemaAttribute"}).has("vertex--label", (Object)"RelationalTable").aggregate(org.apache.tinkerpop.gremlin.process.traversal.Scope.local, "vertex"), __.in((String[])new String[]{"AttributeForSchema"}).in(new String[]{"SchemaTypeOption"}).in(new String[]{"AssetSchemaType"}).has("vertex--label", (Object)"Topic").aggregate(org.apache.tinkerpop.gremlin.process.traversal.Scope.local, "vertex")}).select("vertex").unfold();
        return end.hasNext();
    }

    public LineageResponse lineage(Scope scope, String guid, boolean includeProcesses) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        GraphTraversal vertexGraphTraversal = g.V(new Object[0]).has("vertex--guid", (Object)guid);
        this.commitTransaction(g);
        if (!vertexGraphTraversal.hasNext()) {
            LineageResponse lineageResponse = new LineageResponse();
            lineageResponse.setRelatedHTTPCode(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getHTTPErrorCode());
            lineageResponse.setExceptionErrorMessage(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getFormattedErrorMessage(new String[]{guid}));
            lineageResponse.setActionDescription(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getUserAction());
            lineageResponse.setExceptionUserAction(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getUserAction());
            lineageResponse.setExceptionErrorMessageId(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getErrorMessageId());
            lineageResponse.setExceptionErrorMessageId(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getErrorMessageId());
            lineageResponse.setExceptionClassName(InvalidParameterException.class.getName());
            return lineageResponse;
        }
        Optional<Object> lineageVerticesAndEdges = Optional.empty();
        switch (scope) {
            case END_TO_END: {
                lineageVerticesAndEdges = this.helper.endToEnd(guid, includeProcesses);
                break;
            }
            case ULTIMATE_SOURCE: {
                lineageVerticesAndEdges = this.helper.ultimateSource(guid);
                break;
            }
            case ULTIMATE_DESTINATION: {
                lineageVerticesAndEdges = this.helper.ultimateDestination(guid);
                break;
            }
            case VERTICAL: {
                lineageVerticesAndEdges = this.helper.verticalLineage(guid);
            }
        }
        if (lineageVerticesAndEdges.isEmpty()) {
            LineageResponse lineageResponse = new LineageResponse();
            lineageResponse.setRelatedHTTPCode(OpenLineageServerErrorCode.ERROR_LINEAGE_NOT_FOUND.getHTTPErrorCode());
            lineageResponse.setExceptionErrorMessage(OpenLineageServerErrorCode.ERROR_LINEAGE_NOT_FOUND.getFormattedErrorMessage(new String[]{guid}));
            lineageResponse.setActionDescription(OpenLineageServerErrorCode.ERROR_LINEAGE_NOT_FOUND.getUserAction());
            lineageResponse.setExceptionUserAction(OpenLineageServerErrorCode.ERROR_LINEAGE_NOT_FOUND.getUserAction());
            lineageResponse.setExceptionErrorMessageId(OpenLineageServerErrorCode.ERROR_LINEAGE_NOT_FOUND.getErrorMessageId());
            lineageResponse.setExceptionErrorMessageId(OpenLineageServerErrorCode.ERROR_LINEAGE_NOT_FOUND.getErrorMessageId());
            lineageResponse.setExceptionClassName(InvalidParameterException.class.getName());
            return lineageResponse;
        }
        return new LineageResponse((LineageVerticesAndEdges)lineageVerticesAndEdges.orElse(null));
    }

    public LineageVertexResponse getEntityDetails(String guid) {
        LineageVertex lineageVertex = this.helper.getLineageVertexByGuid(guid);
        if (lineageVertex.getGuid() == null) {
            LineageVertexResponse lineageResponse = new LineageVertexResponse();
            lineageResponse.setRelatedHTTPCode(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getHTTPErrorCode());
            lineageResponse.setExceptionErrorMessage(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getFormattedErrorMessage(new String[]{guid}));
            lineageResponse.setActionDescription(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getUserAction());
            lineageResponse.setExceptionUserAction(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getUserAction());
            lineageResponse.setExceptionErrorMessageId(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getErrorMessageId());
            lineageResponse.setExceptionErrorMessageId(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getErrorMessageId());
            lineageResponse.setExceptionClassName(InvalidParameterException.class.getName());
            return lineageResponse;
        }
        return new LineageVertexResponse(lineageVertex);
    }

    public boolean isEntityInGraph(String guid) {
        GraphTraversalSource g = this.graphFactory.getGraphTraversalSource();
        return !g.V(new Object[0]).has("vertex--guid", (Object)guid).toList().isEmpty();
    }

    private void commitTransaction(GraphTraversalSource g) {
        if (this.graphFactory.isSupportingTransactions()) {
            g.tx().commit();
        }
    }

    private void rollbackTransaction(GraphTraversalSource g) {
        if (this.graphFactory.isSupportingTransactions()) {
            g.tx().rollback();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineageGraphConnector)) {
            return false;
        }
        LineageGraphConnector other = (LineageGraphConnector)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LineageGraphConnectorHelper this$helper = this.helper;
        LineageGraphConnectorHelper other$helper = other.helper;
        if (this$helper == null ? other$helper != null : !this$helper.equals(other$helper)) {
            return false;
        }
        GraphFactory this$graphFactory = this.graphFactory;
        GraphFactory other$graphFactory = other.graphFactory;
        if (this$graphFactory == null ? other$graphFactory != null : !this$graphFactory.equals(other$graphFactory)) {
            return false;
        }
        AuditLog this$auditLog = this.auditLog;
        AuditLog other$auditLog = other.auditLog;
        return !(this$auditLog == null ? other$auditLog != null : !this$auditLog.equals(other$auditLog));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LineageGraphConnector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LineageGraphConnectorHelper $helper = this.helper;
        result = result * 59 + ($helper == null ? 43 : $helper.hashCode());
        GraphFactory $graphFactory = this.graphFactory;
        result = result * 59 + ($graphFactory == null ? 43 : $graphFactory.hashCode());
        AuditLog $auditLog = this.auditLog;
        result = result * 59 + ($auditLog == null ? 43 : $auditLog.hashCode());
        return result;
    }
}

