/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageEdge;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.GraphHelper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.Constants;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.GraphConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageGraphQueryHelper {
    private final GraphHelper graphHelper;
    private static final Logger log = LoggerFactory.getLogger(LineageGraphQueryHelper.class);

    public LineageGraphQueryHelper(GraphHelper graphHelper) {
        this.graphHelper = graphHelper;
    }

    public LineageVerticesAndEdges getLineageVerticesAndEdges(Graph subGraph, boolean includeProcesses) {
        Set<LineageVertex> lineageVertices = this.getLineageVertices(subGraph);
        Set<LineageEdge> lineageEdges = this.getLineageEdges(subGraph);
        this.condenseProcesses(includeProcesses, lineageVertices, lineageEdges);
        return new LineageVerticesAndEdges(lineageVertices, lineageEdges);
    }

    public Set<LineageVertex> getLineageVertices(Graph subGraph) {
        Iterator originalVertices = subGraph.vertices(new Object[0]);
        LinkedHashSet<LineageVertex> lineageVertices = new LinkedHashSet<LineageVertex>();
        while (originalVertices.hasNext()) {
            LineageVertex newVertex = this.abstractVertex((Vertex)originalVertices.next());
            lineageVertices.add(newVertex);
        }
        return lineageVertices;
    }

    public Set<LineageVertex> getLineageVertices(List<Vertex> vertexList) {
        if (CollectionUtils.isNotEmpty(vertexList)) {
            return vertexList.stream().map(this::abstractVertex).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public Set<LineageEdge> getLineageEdges(Graph subGraph) {
        Iterator originalEdges = subGraph.edges(new Object[0]);
        HashSet<LineageEdge> lineageEdges = new HashSet<LineageEdge>();
        while (originalEdges.hasNext()) {
            Edge next = (Edge)originalEdges.next();
            LineageEdge newLineageEdge = new LineageEdge(next.label(), this.getNodeID(next.outVertex()), this.getNodeID(next.inVertex()));
            lineageEdges.add(newLineageEdge);
        }
        return lineageEdges;
    }

    private void condenseProcesses(boolean includeProcesses, Set<LineageVertex> lineageVertices, Set<LineageEdge> lineageEdges) {
        if (!includeProcesses) {
            Set verticesToRemove = lineageVertices.stream().filter(this::isProcessOrSubprocessNode).collect(Collectors.toSet());
            Set<String> verticesToRemoveIDs = verticesToRemove.stream().map(LineageVertex::getNodeID).collect(Collectors.toSet());
            Set edgesToRemove = lineageEdges.stream().filter(edge -> this.isInVertexesToRemove(verticesToRemoveIDs, (LineageEdge)edge)).collect(Collectors.toSet());
            List<LineageEdge> edgesToReplaceProcesses = this.createEdgesThatReplaceProcesses(lineageEdges, verticesToRemoveIDs);
            lineageEdges.addAll(edgesToReplaceProcesses);
            lineageEdges.removeAll(edgesToRemove);
            lineageVertices.removeAll(verticesToRemove);
        }
    }

    private boolean isProcessOrSubprocessNode(LineageVertex vertex) {
        return GraphConstants.PROCESS_NODES.stream().anyMatch(vertex.getNodeType()::equalsIgnoreCase);
    }

    private List<LineageEdge> createEdgesThatReplaceProcesses(Set<LineageEdge> lineageEdges, Set<String> verticesToRemoveNames) {
        ArrayList<LineageEdge> edgesToReplaceProcesses = new ArrayList<LineageEdge>();
        for (String vertexName : verticesToRemoveNames) {
            for (LineageEdge edge : lineageEdges) {
                if (!edge.getDestinationNodeID().equalsIgnoreCase(vertexName)) continue;
                for (LineageEdge destinationEdge : lineageEdges) {
                    if (!destinationEdge.getSourceNodeID().equalsIgnoreCase(vertexName)) continue;
                    edgesToReplaceProcesses.add(new LineageEdge("condensed", edge.getSourceNodeID(), destinationEdge.getDestinationNodeID()));
                }
            }
        }
        return edgesToReplaceProcesses;
    }

    private boolean isInVertexesToRemove(Set<String> verticesToRemoveNames, LineageEdge edge) {
        return verticesToRemoveNames.contains(edge.getSourceNodeID()) || verticesToRemoveNames.contains(edge.getDestinationNodeID());
    }

    public LineageVertex abstractVertex(Vertex originalVertex) {
        String displayName;
        String nodeType = originalVertex.label();
        String nodeID = this.getNodeID(originalVertex);
        LineageVertex lineageVertex = new LineageVertex(nodeID, nodeType);
        lineageVertex.setId(originalVertex.id());
        if (originalVertex.property("vertex--displayName").isPresent()) {
            displayName = originalVertex.property("vertex--displayName").value().toString();
            lineageVertex.setDisplayName(displayName);
        } else if (originalVertex.property("vertex--InstancePropdisplayName").isPresent()) {
            displayName = originalVertex.property("vertex--InstancePropdisplayName").value().toString();
            lineageVertex.setDisplayName(displayName);
        } else if (originalVertex.property("vertex--label").isPresent()) {
            displayName = originalVertex.property("vertex--label").value().toString();
            lineageVertex.setDisplayName(displayName);
        } else {
            lineageVertex.setDisplayName("undefined");
        }
        if (originalVertex.property("vertex--guid").isPresent()) {
            String guid = originalVertex.property("vertex--guid").value().toString();
            lineageVertex.setGuid(guid);
        }
        if (originalVertex.property("vertex--InstancePropqualifiedName").isPresent()) {
            String qualifiedName = originalVertex.property("vertex--InstancePropqualifiedName").value().toString();
            lineageVertex.setQualifiedName(qualifiedName);
        }
        if ("subProcess".equals(nodeType) && originalVertex.property("processGuid").isPresent()) {
            lineageVertex.setGuid(originalVertex.property("processGuid").value().toString());
            lineageVertex.setNodeID(originalVertex.property("processGuid").value().toString());
        }
        Map<String, String> properties = this.retrieveProperties(originalVertex);
        lineageVertex.setProperties(properties);
        return lineageVertex;
    }

    private String getNodeID(Vertex vertex) {
        String nodeID = vertex.label().equalsIgnoreCase("subProcess") ? vertex.property("processGuid").value().toString() : vertex.property("vertex--guid").value().toString();
        return nodeID;
    }

    private Map<String, String> retrieveProperties(Vertex vertex) {
        boolean isClassificationVertex = vertex.edges(Direction.IN, new String[]{"Classification"}).hasNext();
        HashMap<String, String> newNodeProperties = new HashMap<String, String>();
        Iterator originalProperties = vertex.properties(new String[0]);
        while (originalProperties.hasNext()) {
            Property originalProperty = (Property)originalProperties.next();
            if (!GraphConstants.immutableReturnedPropertiesWhiteList.contains((Object)originalProperty.key()) && !isClassificationVertex) continue;
            String newPropertyKey = originalProperty.key().replace("vertex--InstanceProp", "").replace("vertex--", "");
            String newPropertyValue = originalProperty.value().toString();
            newNodeProperties.put(newPropertyKey, newPropertyValue);
        }
        return newNodeProperties;
    }

    public void addColumnProperties(LineageVerticesAndEdges lineageVerticesAndEdges) {
        Set lineageVertices = lineageVerticesAndEdges.getLineageVertices();
        if (CollectionUtils.isEmpty((Collection)lineageVertices)) {
            return;
        }
        lineageVertices.stream().filter(this::needsAdditionalNodeContext).forEach(vertex -> vertex.setProperties(this.getProperties((LineageVertex)vertex)));
    }

    private boolean needsAdditionalNodeContext(LineageVertex lineageVertex) {
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(Constants.DATA_FILE_AND_SUBTYPES);
        types.addAll(Arrays.asList("RelationalTable", "GlossaryTerm", "GlossaryCategory", "Process", "TabularColumn", "TabularFileColumn", "RelationalColumn", "subProcess", "Topic", "EventSchemaAttribute"));
        return types.contains(lineageVertex.getNodeType());
    }

    private Map<String, String> getProperties(LineageVertex vertex) {
        String type = vertex.getNodeType();
        Object vertexId = vertex.getId();
        Map<String, String> properties = new HashMap<String, String>();
        switch (type) {
            case "TabularFileColumn": 
            case "TabularColumn": {
                properties = this.graphHelper.getResult(this::getTabularColumnProperties, vertexId, this::handlePropertiesNotFound);
                break;
            }
            case "RelationalColumn": {
                properties = this.graphHelper.getResult(this::getRelationalColumnProperties, vertexId, this::handlePropertiesNotFound);
                break;
            }
            case "EventSchemaAttribute": {
                properties = this.graphHelper.getResult(this::getEventSchemaAttributeProperties, vertexId, this::handlePropertiesNotFound);
                break;
            }
            case "RelationalTable": {
                properties = this.graphHelper.getResult(this::getRelationalTableProperties, vertexId, this::handlePropertiesNotFound);
                break;
            }
            case "Topic": {
                properties = this.graphHelper.getResult(this::getTopicProperties, vertexId, this::handlePropertiesNotFound);
                break;
            }
            case "DataFile": 
            case "AvroFile": 
            case "CSVFile": 
            case "JSONFile": 
            case "KeystoreFile": 
            case "LogFile": 
            case "MediaFile": 
            case "Document": {
                properties = this.graphHelper.getResult(this::getDataFileProperties, vertexId, this::handlePropertiesNotFound);
                break;
            }
            case "Process": 
            case "subProcess": {
                properties = this.graphHelper.getResult(this::getProcessProperties, vertexId, this::handlePropertiesNotFound);
                break;
            }
            case "GlossaryTerm": 
            case "GlossaryCategory": {
                properties = this.graphHelper.getResult(this::getGlossaryTermProperties, vertexId, this::handlePropertiesNotFound);
            }
        }
        return properties;
    }

    private Map<String, String> getRelationalColumnProperties(GraphTraversalSource g, Object vertexId) {
        HashMap<String, String> properties = new HashMap<String, String>();
        GraphTraversal tableAsset = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"RelationalTable", (String[])new String[0])});
        if (tableAsset.hasNext()) {
            Vertex tableAssetVertex = (Vertex)tableAsset.next();
            properties.put("relationalTable", this.getDisplayNameForVertex(tableAssetVertex));
            properties.putAll(this.getRelationalTableProperties(g, tableAssetVertex.id()));
        }
        return properties;
    }

    private Map<String, String> getTabularColumnProperties(GraphTraversalSource g, Object vertexId) {
        GraphTraversal dataFileAsset;
        HashMap<String, String> properties = new HashMap<String, String>();
        GraphTraversal tabularSchemaType = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).outV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"TabularSchemaType", (String[])new String[0])}).valueMap(new String[0]);
        if (tabularSchemaType.hasNext()) {
            properties.put("schema", this.getDisplayNameForVertex((Map)tabularSchemaType.next()));
        }
        if ((dataFileAsset = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(2).or(new Traversal[]{__.hasLabel((P)P.within(Constants.DATA_FILE_AND_SUBTYPES))}).id()).hasNext()) {
            properties.putAll(this.getDataFileProperties(g, dataFileAsset.next()));
        }
        return properties;
    }

    private String getFoldersPath(List<Vertex> folderVertices) {
        Collections.reverse(folderVertices);
        return folderVertices.stream().map(folderVertex -> folderVertex.property("vertex--InstancePropdisplayName").value().toString()).collect(Collectors.joining("/"));
    }

    private List<Vertex> getFolderVertices(GraphTraversalSource g, Object dataFileAssetId) {
        GraphTraversal fileFolders = g.V(new Object[]{dataFileAssetId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).until((Traversal)__.inE((String[])new String[]{"FolderHierarchy"}).count().is((Object)0)).or(new Traversal[]{__.hasLabel((String)"FileFolder", (String[])new String[0])});
        ArrayList<Vertex> folderVertices = new ArrayList<Vertex>();
        while (fileFolders.hasNext()) {
            folderVertices.add((Vertex)fileFolders.next());
        }
        return folderVertices;
    }

    private Map<String, String> getRelationalTableProperties(GraphTraversalSource g, Object vertexId) {
        HashMap<String, String> properties = new HashMap<String, String>();
        GraphTraversal outVertices = g.V(new Object[]{vertexId}).repeat((Traversal)__.inE((String[])Constants.RELATIONAL_TABLE_CONTEXT_IN_EDGES).otherV()).emit().times(4);
        while (outVertices.hasNext()) {
            String vertexLabel;
            Vertex vertex = (Vertex)outVertices.next();
            switch (vertexLabel = vertex.label()) {
                case "RelationalDBSchemaType": {
                    properties.put("schema", this.getDisplayNameForVertex(vertex));
                    break;
                }
                case "Database": {
                    properties.put("database", this.getDisplayNameForVertex(vertex));
                    break;
                }
                case "Connection": {
                    properties.put("connection", this.getDisplayNameForVertex(vertex));
                    break;
                }
            }
        }
        return properties;
    }

    private String getDisplayNameForVertex(Vertex vertex) {
        if (vertex.properties(new String[]{"vertex--InstancePropdisplayName"}).hasNext()) {
            return (String)((VertexProperty)vertex.properties(new String[]{"vertex--InstancePropdisplayName"}).next()).value();
        }
        if (vertex.properties(new String[]{"vertex--InstancePropqualifiedName"}).hasNext()) {
            return (String)((VertexProperty)vertex.properties(new String[]{"vertex--InstancePropqualifiedName"}).next()).value();
        }
        Map vertexMap = this.graphHelper.getResult(this::getVertexPropertiesMap, vertex, this::handlePropertiesNotFound);
        if (vertexMap.containsKey("vertex--InstancePropdisplayName")) {
            return (String)((List)vertexMap.get("vertex--InstancePropdisplayName")).get(0);
        }
        if (vertexMap.containsKey("vertex--InstancePropqualifiedName")) {
            return (String)((List)vertexMap.get("vertex--InstancePropqualifiedName")).get(0);
        }
        return null;
    }

    private Map<Object, List<String>> getVertexPropertiesMap(GraphTraversalSource g, Vertex v) {
        GraphTraversal vertexMapGraphTraversal = g.V(new Object[]{v.id()}).valueMap(new String[0]);
        if (!vertexMapGraphTraversal.hasNext()) {
            return null;
        }
        return (Map)vertexMapGraphTraversal.next();
    }

    private String getDisplayNameForVertex(Map<Object, List<String>> vertex) {
        if (vertex.containsKey("vertex--InstancePropdisplayName")) {
            return vertex.get("vertex--InstancePropdisplayName").get(0);
        }
        if (vertex.containsKey("vertex--InstancePropqualifiedName")) {
            return vertex.get("vertex--InstancePropqualifiedName").get(0);
        }
        return null;
    }

    private Map<String, String> getDataFileProperties(GraphTraversalSource g, Object vertexId) {
        Map<String, String> properties = this.extractPropertiesFromNeighborhood(g, vertexId);
        if (!properties.containsKey("fileFolder")) {
            Optional<String> path = this.extractPathFromVertexProperties(g, vertexId);
            path.ifPresent(s -> properties.put("fileFolder", "/" + s.trim()));
        }
        return properties;
    }

    private Map<String, String> extractPropertiesFromNeighborhood(GraphTraversalSource g, Object vertexId) {
        HashMap<String, String> properties = new HashMap<String, String>();
        List<Vertex> folderVertices = this.getFolderVertices(g, vertexId);
        if (CollectionUtils.isEmpty(folderVertices)) {
            return properties;
        }
        Object lastFolderVertexId = folderVertices.get(folderVertices.size() - 1).id();
        properties.put("fileFolder", String.join((CharSequence)"/", this.getFoldersPath(folderVertices)));
        Optional<String> connectionDetails = this.getConnectionDetailsFromNeighborhood(g, vertexId);
        if (connectionDetails.isEmpty()) {
            connectionDetails = this.getConnectionDetailsFromNeighborhood(g, lastFolderVertexId);
        }
        connectionDetails.ifPresent(s -> properties.put("connection", (String)s));
        return properties;
    }

    private Optional<String> getConnectionDetailsFromNeighborhood(GraphTraversalSource g, Object vertexId) {
        GraphTraversal connection = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"Connection", (String[])new String[0])});
        if (connection.hasNext()) {
            return Optional.ofNullable(this.getDisplayNameForVertex((Vertex)connection.next()));
        }
        return Optional.empty();
    }

    private Optional<String> extractPathFromVertexProperties(GraphTraversalSource g, Object vertexId) {
        VertexProperty additionalProperties = ((Vertex)g.V(new Object[]{vertexId}).next()).property("vertex--InstancePropadditionalProperties");
        if (!additionalProperties.isPresent()) {
            return Optional.empty();
        }
        String additionalPropertiesValue = (String)additionalProperties.value();
        return Arrays.stream(additionalPropertiesValue.split(",")).filter(s -> s.trim().startsWith("path")).map(s -> s.split(":")[1]).findFirst();
    }

    private Map<String, String> getProcessProperties(GraphTraversalSource g, Object vertexId) {
        Map transformationProjectValueMap;
        HashMap<String, String> properties = new HashMap<String, String>();
        GraphTraversal transformationProject = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"Collection", (String[])new String[0])}).valueMap(new String[0]);
        if (transformationProject.hasNext() && (transformationProjectValueMap = (Map)transformationProject.next()).containsKey("vertex--InstancePropdisplayName")) {
            properties.put("transformationProject", (String)((List)transformationProjectValueMap.get("vertex--InstancePropdisplayName")).get(0));
        }
        return properties;
    }

    private Map<String, String> getGlossaryTermProperties(GraphTraversalSource g, Object vertexId) {
        HashMap<String, String> properties = new HashMap<String, String>();
        GraphTraversal glossary = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"Glossary", (String[])new String[0])}).valueMap(new String[]{"vertex--InstancePropdisplayName"});
        if (glossary.hasNext()) {
            properties.put("glossary", (String)((List)((Map)glossary.next()).get("vertex--InstancePropdisplayName")).get(0));
        }
        return properties;
    }

    private Map<String, String> getTopicProperties(GraphTraversalSource g, Object vertexId) {
        HashMap<String, String> properties = new HashMap<String, String>();
        GraphTraversal eventTypeList = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"EventTypeList", (String[])new String[0])});
        if (eventTypeList.hasNext()) {
            properties.put("eventTypeList", this.getDisplayNameForVertex((Vertex)eventTypeList.next()));
        }
        return properties;
    }

    private Map<String, String> getEventSchemaAttributeProperties(GraphTraversalSource g, Object vertexId) {
        GraphTraversal topic;
        GraphTraversal eventTypeList;
        HashMap<String, String> properties = new HashMap<String, String>();
        GraphTraversal eventType = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(1).or(new Traversal[]{__.hasLabel((String)"EventType", (String[])new String[0])});
        if (eventType.hasNext()) {
            properties.put("eventType", this.getDisplayNameForVertex((Vertex)eventType.next()));
        }
        if ((eventTypeList = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(2).or(new Traversal[]{__.hasLabel((String)"EventTypeList", (String[])new String[0])})).hasNext()) {
            properties.put("eventTypeList", this.getDisplayNameForVertex((Vertex)eventTypeList.next()));
        }
        if ((topic = g.V(new Object[]{vertexId}).emit().repeat((Traversal)__.bothE((String[])new String[0]).otherV().simplePath()).times(3).or(new Traversal[]{__.hasLabel((String)"Topic", (String[])new String[0])})).hasNext()) {
            properties.put("topic", this.getDisplayNameForVertex((Vertex)topic.next()));
        }
        return properties;
    }

    private void handlePropertiesNotFound(Exception e, Object vertexId) {
        log.error("Could not retrieve properties {}", vertexId, (Object)e);
    }
}

