/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.openlineage.OpenLineageQueryService;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageServerErrorCode;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageEdge;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageVertexResponse;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.GraphHelper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphQueryHelper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageGraphQueryService
implements OpenLineageQueryService {
    private static final Logger log = LoggerFactory.getLogger(LineageGraphQueryService.class);
    private final GraphHelper graphHelper;
    private final LineageGraphQueryHelper lineageGraphQueryHelper;
    private final AuditLog auditLog;

    public LineageGraphQueryService(GraphHelper graphHelper, AuditLog auditLog) {
        this.graphHelper = graphHelper;
        this.auditLog = auditLog;
        this.lineageGraphQueryHelper = new LineageGraphQueryHelper(graphHelper);
    }

    public LineageResponse lineage(Scope scope, String guid, boolean includeProcesses) {
        LineageResponse response = this.graphHelper.getResult(this::checkEntityExists, guid, this::handleGetQueriedVertexException);
        if (response != null) {
            return response;
        }
        Optional<Object> lineageVerticesAndEdges = Optional.empty();
        switch (scope) {
            case END_TO_END: {
                lineageVerticesAndEdges = this.endToEnd(guid, includeProcesses);
                break;
            }
            case ULTIMATE_SOURCE: {
                lineageVerticesAndEdges = this.ultimateSource(guid);
                break;
            }
            case ULTIMATE_DESTINATION: {
                lineageVerticesAndEdges = this.ultimateDestination(guid);
                break;
            }
            case VERTICAL: {
                lineageVerticesAndEdges = this.verticalLineage(guid);
            }
        }
        if (lineageVerticesAndEdges.isEmpty()) {
            return this.getLineageResponse(guid, OpenLineageServerErrorCode.ERROR_LINEAGE_NOT_FOUND);
        }
        return new LineageResponse((LineageVerticesAndEdges)lineageVerticesAndEdges.orElse(null));
    }

    private LineageResponse checkEntityExists(GraphTraversalSource g, String guid) {
        GraphTraversal vertexGraphTraversal = g.V(new Object[0]).has("vertex--guid", (Object)guid);
        if (!vertexGraphTraversal.hasNext()) {
            return this.getLineageResponse(guid, OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND);
        }
        return null;
    }

    private LineageResponse getLineageResponse(String guid, OpenLineageServerErrorCode errorEntityNotFound) {
        LineageResponse lineageResponse = new LineageResponse();
        lineageResponse.setRelatedHTTPCode(errorEntityNotFound.getHTTPErrorCode());
        lineageResponse.setExceptionErrorMessage(errorEntityNotFound.getFormattedErrorMessage(new String[]{guid}));
        lineageResponse.setActionDescription(errorEntityNotFound.getUserAction());
        lineageResponse.setExceptionUserAction(errorEntityNotFound.getUserAction());
        lineageResponse.setExceptionErrorMessageId(errorEntityNotFound.getErrorMessageId());
        lineageResponse.setExceptionErrorMessageId(errorEntityNotFound.getErrorMessageId());
        lineageResponse.setExceptionClassName(InvalidParameterException.class.getName());
        return lineageResponse;
    }

    public Optional<LineageVerticesAndEdges> endToEnd(String guid, boolean includeProcesses) {
        Vertex queriedVertex = this.graphHelper.getResult(this::getQueriedVertex, guid, this::handleGetQueriedVertexException);
        String label = queriedVertex.label();
        Optional<List<String>> edgeLabelsOptional = this.getEdgeLabelsForDataFlow(label);
        if (edgeLabelsOptional.isEmpty()) {
            return Optional.empty();
        }
        List<String> edgeLabels = edgeLabelsOptional.get();
        Graph endToEndGraph = (Graph)this.graphHelper.getResult(this::queryEndToEnd, guid, edgeLabels, this::handleLineageNotFoundException);
        if (endToEndGraph == null || !endToEndGraph.vertices(new Object[0]).hasNext()) {
            return Optional.empty();
        }
        LineageVerticesAndEdges lineageVerticesAndEdges = this.lineageGraphQueryHelper.getLineageVerticesAndEdges(endToEndGraph, includeProcesses);
        this.addIncompleteClassifications(lineageVerticesAndEdges);
        this.lineageGraphQueryHelper.addColumnProperties(lineageVerticesAndEdges);
        return Optional.of(lineageVerticesAndEdges);
    }

    private Graph queryEndToEnd(GraphTraversalSource g, String guid, List<String> edgeLabels) {
        String[] labels = edgeLabels.toArray(new String[0]);
        return (Graph)g.V(new Object[0]).has("vertex--guid", (Object)guid).union(new Traversal[]{__.until((Traversal)__.inE((String[])labels).count().is((Object)0)).repeat((Traversal)__.inE((String[])labels).subgraph("subGraph").outV().simplePath().dedup(new String[0])), __.until((Traversal)__.outE((String[])labels).count().is((Object)0)).repeat((Traversal)__.outE((String[])labels).subgraph("subGraph").inV().simplePath().dedup(new String[0]))}).cap("subGraph", new String[0]).next();
    }

    private void handleLineageNotFoundException(Exception e, String guid, List<String> edgeLabels) {
        this.auditLog.logException(JanusConnectorErrorCode.LINEAGE_NOT_FOUND.getFormattedErrorMessage(guid, edgeLabels.toString()), JanusConnectorErrorCode.LINEAGE_NOT_FOUND.getMessageDefinition(guid, edgeLabels.toString()), (Throwable)e);
    }

    public Optional<LineageVerticesAndEdges> ultimateSource(String guid) {
        Vertex queriedVertex = this.graphHelper.getResult(this::getQueriedVertex, guid, this::handleGetQueriedVertexException);
        String label = queriedVertex.label();
        Optional<List<String>> edgeLabelsOptional = this.getEdgeLabelsForDataFlow(label);
        if (edgeLabelsOptional.isEmpty()) {
            return Optional.empty();
        }
        List<String> edgeLabels = edgeLabelsOptional.get();
        List sourcesList = (List)this.graphHelper.getResult(this::querySources, guid, edgeLabels, this::handleLineageNotFoundException);
        Set<LineageVertex> lineageVertices = this.lineageGraphQueryHelper.getLineageVertices(sourcesList);
        return Optional.of(this.getCondensedLineage(queriedVertex, lineageVertices, "source"));
    }

    private List<Vertex> querySources(GraphTraversalSource g, String guid, List<String> edgeLabels) {
        String[] labels = edgeLabels.toArray(new String[0]);
        List sourceList = g.V(new Object[0]).has("vertex--guid", (Object)guid).until((Traversal)__.inE((String[])labels).count().is((Object)0)).repeat((Traversal)__.inE((String[])labels).outV().simplePath().dedup(new String[0])).dedup(new String[0]).toList();
        return sourceList;
    }

    public Optional<LineageVerticesAndEdges> ultimateDestination(String guid) {
        Vertex queriedVertex = this.graphHelper.getResult(this::getQueriedVertex, guid, this::handleGetQueriedVertexException);
        String label = queriedVertex.label();
        Optional<List<String>> edgeLabelsOptional = this.getEdgeLabelsForDataFlow(label);
        if (edgeLabelsOptional.isEmpty()) {
            return Optional.empty();
        }
        List<String> edgeLabels = edgeLabelsOptional.get();
        List destinationsList = (List)this.graphHelper.getResult(this::queryDestinations, guid, edgeLabels, this::handleLineageNotFoundException);
        Set<LineageVertex> lineageVertices = this.lineageGraphQueryHelper.getLineageVertices(destinationsList);
        return Optional.of(this.getCondensedLineage(queriedVertex, lineageVertices, "destination"));
    }

    private List<Vertex> queryDestinations(GraphTraversalSource g, String guid, List<String> edgeLabels) {
        String[] labels = edgeLabels.toArray(new String[0]);
        List destinationList = g.V(new Object[0]).has("vertex--guid", (Object)guid).until((Traversal)__.outE((String[])labels).count().is((Object)0)).repeat((Traversal)__.outE((String[])labels).inV().simplePath().dedup(new String[0])).dedup(new String[0]).toList();
        return destinationList;
    }

    public Optional<LineageVerticesAndEdges> verticalLineage(String guid) {
        Graph graph;
        String label;
        Vertex queriedVertex = this.graphHelper.getResult(this::getQueriedVertex, guid, this::handleGetQueriedVertexException);
        switch (label = queriedVertex.label()) {
            case "GlossaryTerm": {
                graph = this.graphHelper.getResult(this::glossaryTermVerticalLineage, guid, this::handleVerticalLineageNotFoundException);
                break;
            }
            case "RelationalColumn": {
                graph = this.graphHelper.getResult(this::relationalColumnVerticalLineage, guid, this::handleVerticalLineageNotFoundException);
                break;
            }
            case "TabularColumn": 
            case "TabularFileColumn": {
                graph = this.graphHelper.getResult(this::tabularColumnVerticalLineage, guid, this::handleVerticalLineageNotFoundException);
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        LineageVerticesAndEdges lineageVerticesAndEdges = this.lineageGraphQueryHelper.getLineageVerticesAndEdges(graph, true);
        this.addIncompleteClassifications(lineageVerticesAndEdges);
        this.lineageGraphQueryHelper.addColumnProperties(lineageVerticesAndEdges);
        return Optional.of(lineageVerticesAndEdges);
    }

    private Vertex getQueriedVertex(GraphTraversalSource g, String guid) {
        Vertex queriedVertex = (Vertex)g.V(new Object[0]).has("vertex--guid", (Object)guid).next();
        if (queriedVertex != null) {
            return queriedVertex;
        }
        return null;
    }

    private void handleGetQueriedVertexException(Exception e, String guid) {
        this.auditLog.logException(JanusConnectorErrorCode.COULD_NOT_RETRIEVE_VERTEX.getFormattedErrorMessage(guid), JanusConnectorErrorCode.COULD_NOT_RETRIEVE_VERTEX.getMessageDefinition(guid), (Throwable)e);
        throw new JanusConnectorException(this.getClass().getName(), "getQueriedVertex", JanusConnectorErrorCode.COULD_NOT_RETRIEVE_VERTEX);
    }

    private Graph glossaryTermVerticalLineage(GraphTraversalSource g, String guid) {
        return (Graph)g.V(new Object[0]).has("vertex--guid", (Object)guid).bothE(Constants.GLOSSARY_TERM_AND_CLASSIFICATION_EDGES).subgraph("s").cap("s", new String[0]).next();
    }

    private Graph relationalColumnVerticalLineage(GraphTraversalSource g, String guid) {
        return (Graph)g.V(new Object[0]).has("vertex--guid", (Object)guid).bothE(Constants.RELATIONAL_COLUMN_AND_CLASSIFICATION_EDGES).subgraph("s").cap("s", new String[0]).next();
    }

    private Graph tabularColumnVerticalLineage(GraphTraversalSource g, String guid) {
        return (Graph)g.V(new Object[0]).has("vertex--guid", (Object)guid).bothE(Constants.TABULAR_COLUMN_AND_CLASSIFICATION_EDGES).subgraph("s").bothV().inE(new String[]{"AssetSchemaType"}).subgraph("s").cap("s", new String[0]).next();
    }

    private void handleVerticalLineageNotFoundException(Exception e, String guid) {
        this.auditLog.logException(JanusConnectorErrorCode.LINEAGE_NOT_FOUND.getFormattedErrorMessage(guid), JanusConnectorErrorCode.LINEAGE_NOT_FOUND.getMessageDefinition(guid), (Throwable)e);
    }

    private LineageVerticesAndEdges getCondensedLineage(Vertex originalVertex, Set<LineageVertex> lineageVertices, String condensationType) {
        LineageVertex queriedVertex = this.lineageGraphQueryHelper.abstractVertex(originalVertex);
        Set<Object> lineageEdges = new HashSet();
        if (CollectionUtils.isNotEmpty(lineageVertices) && !Collections.singleton(queriedVertex).equals(lineageVertices)) {
            LineageVertex condensedVertex = this.getCondensedVertex(condensationType);
            lineageVertices.add(condensedVertex);
            lineageEdges = this.getCondensedLineageEdges(lineageVertices, queriedVertex, condensedVertex, condensationType);
            lineageVertices.add(queriedVertex);
        }
        LineageVerticesAndEdges lineageVerticesAndEdges = new LineageVerticesAndEdges(lineageVertices, lineageEdges);
        this.lineageGraphQueryHelper.addColumnProperties(lineageVerticesAndEdges);
        this.addIncompleteClassifications(lineageVerticesAndEdges);
        return lineageVerticesAndEdges;
    }

    private Set<LineageEdge> getCondensedLineageEdges(Set<LineageVertex> lineageVertices, LineageVertex queriedVertex, LineageVertex condensedVertex, String condensationType) {
        HashSet<LineageEdge> lineageEdges = new HashSet<LineageEdge>();
        if ("source".equalsIgnoreCase(condensationType)) {
            lineageEdges.add(new LineageEdge("condensed", condensedVertex.getNodeID(), queriedVertex.getNodeID()));
            lineageVertices.forEach(ultimateVertex -> lineageEdges.add(new LineageEdge("condensed", ultimateVertex.getNodeID(), condensedVertex.getNodeID())));
        }
        if ("destination".equalsIgnoreCase(condensationType)) {
            lineageEdges.add(new LineageEdge("condensed", queriedVertex.getNodeID(), condensedVertex.getNodeID()));
            lineageVertices.forEach(ultimateVertex -> lineageEdges.add(new LineageEdge("condensed", condensedVertex.getNodeID(), ultimateVertex.getNodeID())));
        }
        return lineageEdges;
    }

    private LineageVertex getCondensedVertex(String condensationType) {
        LineageVertex condensedVertex = new LineageVertex(this.getCondensedNodeId(condensationType), "condensedNode");
        condensedVertex.setDisplayName("...");
        condensedVertex.setQualifiedName("");
        condensedVertex.setGuid("");
        return condensedVertex;
    }

    private void addIncompleteClassifications(LineageVerticesAndEdges edgesAndVertices) {
        Set lineageVertices = edgesAndVertices.getLineageVertices();
        Set lineageEdges = edgesAndVertices.getLineageEdges();
        List ids = lineageVertices.stream().map(LineageVertex::getId).collect(Collectors.toList());
        Graph graph = this.graphHelper.getResult(this::getIncompleteClassifications, ids, this::handleIncompleteClassificationException);
        HashSet<LineageVertex> incompleteVertices = new HashSet<LineageVertex>(this.lineageGraphQueryHelper.getLineageVertices(graph));
        HashSet<LineageEdge> incompleteEdges = new HashSet<LineageEdge>(this.lineageGraphQueryHelper.getLineageEdges(graph));
        for (LineageVertex incompleteVertex : incompleteVertices) {
            Optional<LineageVertex> optionalLineageVertex = lineageVertices.stream().filter(lineageVertex -> lineageVertex.getNodeID().equals(incompleteVertex.getNodeID())).findAny();
            if (!optionalLineageVertex.isEmpty()) continue;
            lineageVertices.add(incompleteVertex);
        }
        lineageEdges.addAll(incompleteEdges);
    }

    private Graph getIncompleteClassifications(GraphTraversalSource g, List<Object> ids) {
        return (Graph)g.V(new Object[]{ids}).outE(new String[]{"Classification"}).inV().hasLabel("Incomplete", new String[0]).bothE(new String[0]).subgraph("classificationGraph").cap("classificationGraph", new String[0]).next();
    }

    private void handleIncompleteClassificationException(Exception e, List<Object> vertexIds) {
        this.auditLog.logException(JanusConnectorErrorCode.CLASSIFICATION_NOT_FOUND.getFormattedErrorMessage(vertexIds.toString()), JanusConnectorErrorCode.CLASSIFICATION_NOT_FOUND.getMessageDefinition(vertexIds.toString()), (Throwable)e);
    }

    private String getCondensedNodeId(String condensationType) {
        if ("source".equalsIgnoreCase(condensationType)) {
            return "condensedSource";
        }
        return "condensedDestination";
    }

    private Optional<List<String>> getEdgeLabelsForDataFlow(String label) {
        ArrayList<String> edgeLabels = new ArrayList<String>();
        if (Constants.ASSETS.contains(label)) {
            edgeLabels.add("LineageMapping");
        }
        switch (label) {
            case "TabularFileColumn": 
            case "TabularColumn": 
            case "RelationalColumn": 
            case "EventSchemaAttribute": {
                edgeLabels.add("ColumnDataFlow");
                break;
            }
            case "DataFile": 
            case "AvroFile": 
            case "CSVFile": 
            case "JSONFile": 
            case "KeystoreFile": 
            case "LogFile": 
            case "MediaFile": 
            case "Document": 
            case "RelationalTable": 
            case "Topic": {
                edgeLabels.add("TableDataFlow");
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        return Optional.of(edgeLabels);
    }

    public LineageVertexResponse getEntityDetails(String guid) {
        LineageVertex lineageVertex = this.graphHelper.getResult(this::getLineageVertexByGuid, guid, this::handleGetQueriedVertexException);
        if (lineageVertex.getGuid() == null) {
            LineageVertexResponse lineageResponse = new LineageVertexResponse();
            lineageResponse.setRelatedHTTPCode(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getHTTPErrorCode());
            lineageResponse.setExceptionErrorMessage(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getFormattedErrorMessage(new String[]{guid}));
            lineageResponse.setActionDescription(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getUserAction());
            lineageResponse.setExceptionUserAction(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getUserAction());
            lineageResponse.setExceptionErrorMessageId(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getErrorMessageId());
            lineageResponse.setExceptionErrorMessageId(OpenLineageServerErrorCode.ERROR_ENTITY_NOT_FOUND.getErrorMessageId());
            lineageResponse.setExceptionClassName(InvalidParameterException.class.getName());
            return lineageResponse;
        }
        return new LineageVertexResponse(lineageVertex);
    }

    LineageVertex getLineageVertexByGuid(GraphTraversalSource g, String guid) {
        GraphTraversal vertexGraphTraversal = g.V(new Object[0]).has("vertex--guid", (Object)guid);
        Map<Object, Object> properties = new HashMap();
        if (vertexGraphTraversal.hasNext()) {
            Vertex vertex = (Vertex)vertexGraphTraversal.next();
            properties = this.retrieveAllProperties(vertex);
        }
        LineageVertex lineageVertex = new LineageVertex();
        lineageVertex.setProperties(properties);
        return lineageVertex;
    }

    private Map<String, String> retrieveAllProperties(Vertex vertex) {
        HashMap<String, String> newNodeProperties = new HashMap<String, String>();
        Iterator originalProperties = vertex.properties(new String[0]);
        while (originalProperties.hasNext()) {
            Property originalProperty = (Property)originalProperties.next();
            String newPropertyKey = originalProperty.key().replace("vertex--InstanceProp", "").replace("vertex--", "");
            String newPropertyValue = originalProperty.value().toString();
            if (Constants.EMBEDDED_PROPERTIES.contains(newPropertyKey)) {
                String[] propertyPairs;
                for (String propertyPair : propertyPairs = newPropertyValue.split(", ")) {
                    String[] propertyItems = propertyPair.split(": ");
                    newNodeProperties.put(propertyItems[0], propertyItems[1]);
                }
                continue;
            }
            newNodeProperties.put(newPropertyKey, newPropertyValue);
        }
        return newNodeProperties;
    }
}

