/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageRelationship;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageSyncUpdateContext;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.openlineage.graph.LineageGraph;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.GraphHelper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphQueryService;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.GraphRelationship;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageGraphStorageService
implements LineageGraph {
    private static final Logger log = LoggerFactory.getLogger(LineageGraphStorageService.class);
    private LineageGraphQueryService helper;
    private GraphHelper graphHelper;
    private AuditLog auditLog;

    public LineageGraphStorageService(GraphHelper graphHelper, AuditLog auditLog) {
        this.graphHelper = graphHelper;
        this.auditLog = auditLog;
        this.helper = new LineageGraphQueryService(graphHelper, auditLog);
    }

    public void storeToGraph(Set<GraphContext> graphContext) {
        graphContext.stream().map(this::getGraphRelationship).forEach(this::storeRelationship);
    }

    private GraphRelationship getGraphRelationship(GraphContext entry) {
        LineageEntity fromEntity = entry.getFromVertex();
        LineageEntity toEntity = entry.getToVertex();
        return new GraphRelationship(fromEntity, toEntity, entry.getRelationshipType(), entry.getRelationshipGuid());
    }

    private void storeRelationship(GraphRelationship relationship) {
        BiConsumer<GraphTraversalSource, GraphRelationship> upsertToGraph = this::upsertToGraph;
        this.graphHelper.commit(upsertToGraph, relationship, this::handleStoreRelationshipError);
    }

    private void handleStoreRelationshipError(Exception e) throws JanusConnectorException {
        this.auditLog.logException(JanusConnectorErrorCode.VERTICES_AND_RELATIONSHIP_CREATION_EXCEPTION.getErrorMessage(), JanusConnectorErrorCode.VERTICES_AND_RELATIONSHIP_CREATION_EXCEPTION.getMessageDefinition(), (Throwable)e);
        throw new JanusConnectorException(this.getClass().getName(), "upsertToGraph", JanusConnectorErrorCode.VERTICES_AND_RELATIONSHIP_CREATION_EXCEPTION);
    }

    private void upsertToGraph(GraphTraversalSource g, GraphRelationship graphRelationship) {
        Vertex to = this.addVertex(g, graphRelationship.getToEntity());
        Vertex from = this.addVertex(g, graphRelationship.getFromEntity());
        this.addEdge(g, graphRelationship.getRelationshipLabel(), graphRelationship.getRelationshipGuid(), to, from);
    }

    private Vertex addVertex(GraphTraversalSource g, LineageEntity toEntity) {
        Map<String, Object> toEntityProperties = this.getProperties(toEntity);
        GraphTraversal objectVertexGraphTraversal = __.addV((String)toEntity.getTypeDefName());
        objectVertexGraphTraversal.property((Object)"vertex--guid", (Object)toEntity.getGuid(), new Object[0]);
        for (Map.Entry<String, Object> propertiesEntry : toEntityProperties.entrySet()) {
            objectVertexGraphTraversal.property((Object)propertiesEntry.getKey(), propertiesEntry.getValue(), new Object[0]);
        }
        return (Vertex)g.V(new Object[0]).has("vertex--guid", (Object)toEntity.getGuid()).fold().coalesce(new Traversal[]{__.unfold(), objectVertexGraphTraversal}).next();
    }

    private void addEdge(GraphTraversalSource g, String relationshipLabel, String relationshipGuid, Vertex to, Vertex from) {
        g.V(new Object[]{from.id()}).as("from", new String[0]).V(new Object[]{to.id()}).coalesce(new Traversal[]{__.inE((String[])new String[]{relationshipLabel}).where((Traversal)__.outV().as("from", new String[0])), __.addE((String)relationshipLabel).from("from")}).property((Object)"edge--guid", (Object)relationshipGuid, new Object[0]).next();
    }

    private Map<String, Object> getProperties(LineageEntity lineageEntity) {
        Map<String, Object> properties = lineageEntity.getProperties().entrySet().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)((CharSequence)e.getValue()))).collect(Collectors.toMap(e -> "vertex--InstanceProp" + (String)e.getKey(), Map.Entry::getValue));
        properties.computeIfAbsent("vertex--createTime", val -> lineageEntity.getCreateTime());
        properties.computeIfAbsent("vertex--createdBy", val -> lineageEntity.getCreatedBy());
        properties.computeIfAbsent("vertex--updateTime", val -> lineageEntity.getUpdateTime());
        properties.computeIfAbsent("vertex--updatedBy", val -> lineageEntity.getUpdatedBy());
        properties.computeIfAbsent("vertex--label", val -> lineageEntity.getTypeDefName());
        properties.computeIfAbsent("vertex--version", val -> lineageEntity.getVersion());
        properties.computeIfAbsent("vertex--metadataCollectionId", val -> lineageEntity.getMetadataCollectionId());
        return properties;
    }

    public void updateNeighbours(LineageSyncUpdateContext syncUpdateContext) {
        List existingNeighboursGUIDs = this.graphHelper.getResult(this::getAllNeighbours, syncUpdateContext.getEntityGUID(), this::handleErrorGetAllNeighbours);
        if (this.isDifferentGraphContext(syncUpdateContext.getNeighboursGUID(), existingNeighboursGUIDs)) {
            this.graphHelper.commit(this::removeObsoleteEdges, syncUpdateContext, existingNeighboursGUIDs, this::handleErrorRemoveObsoleteEdges);
        }
    }

    private List<String> getAllNeighbours(GraphTraversalSource g, String entityGUID) {
        GraphTraversal exitingVertices = g.V(new Object[0]).has("vertex--guid", (Object)entityGUID).bothE(new String[0]).otherV();
        ArrayList<String> existingGUIDs = new ArrayList<String>();
        while (exitingVertices.hasNext()) {
            Map valueMap = (Map)g.V(new Object[]{((Vertex)exitingVertices.next()).id()}).valueMap(new String[]{"vertex--guid"}).next();
            if (!valueMap.containsKey("vertex--guid")) continue;
            existingGUIDs.addAll((List)valueMap.get("vertex--guid"));
        }
        return existingGUIDs;
    }

    private void handleErrorGetAllNeighbours(Exception e, String entityGuid) {
        this.auditLog.logException(JanusConnectorErrorCode.GET_ALL_NEIGHBOURS.getErrorMessage() + " " + entityGuid, JanusConnectorErrorCode.GET_ALL_NEIGHBOURS.getMessageDefinition(), (Throwable)e);
        throw new JanusConnectorException(this.getClass().getName(), "getAllNeighbours", JanusConnectorErrorCode.GET_ALL_NEIGHBOURS);
    }

    private boolean isDifferentGraphContext(Set<String> newVertices, List<String> neighboursGUIDs) {
        return neighboursGUIDs.size() != newVertices.size() || !neighboursGUIDs.containsAll(newVertices);
    }

    private void removeObsoleteEdges(GraphTraversalSource g, LineageSyncUpdateContext context, List<String> neighboursGUIDs) {
        String entityGUID = context.getEntityGUID();
        Set newVertices = context.getNeighboursGUID();
        List obsoleteNeighbours = neighboursGUIDs.stream().filter(existingVertex -> !newVertices.contains(existingVertex)).collect(Collectors.toList());
        if (obsoleteNeighbours.isEmpty()) {
            return;
        }
        GraphTraversal existingEdges = g.V(new Object[0]).has("vertex--guid", (Object)entityGUID).bothE(new String[0]);
        while (existingEdges.hasNext()) {
            Edge edge = (Edge)existingEdges.next();
            List inVertexGuid = (List)((Map)g.V(new Object[]{edge.inVertex()}).valueMap(new String[]{"vertex--guid"}).next()).get("vertex--guid");
            List outVertexGuid = (List)((Map)g.V(new Object[]{edge.outVertex()}).valueMap(new String[]{"vertex--guid"}).next()).get("vertex--guid");
            if (!obsoleteNeighbours.containsAll(inVertexGuid) && !obsoleteNeighbours.containsAll(outVertexGuid)) continue;
            g.E(new Object[]{edge.id()}).drop().iterate();
        }
    }

    private void handleErrorRemoveObsoleteEdges(Exception e) {
        this.auditLog.logException(JanusConnectorErrorCode.ERROR_REMOVING_OBSOLETE_EDGES.getErrorMessage(), JanusConnectorErrorCode.ERROR_REMOVING_OBSOLETE_EDGES.getMessageDefinition(), (Throwable)e);
        throw new JanusConnectorException(this.getClass().getName(), "removeObsoleteEdges", JanusConnectorErrorCode.ERROR_REMOVING_OBSOLETE_EDGES);
    }

    public void updateEntity(LineageEntity lineageEntity) {
        this.graphHelper.commit(this::updateEntityInGraph, lineageEntity, this::handleUpdateEntityError);
    }

    private void updateEntityInGraph(GraphTraversalSource g, LineageEntity entity) {
        GraphTraversal vertex = g.V(new Object[0]).has("vertex--guid", (Object)entity.getGuid());
        if (!vertex.hasNext()) {
            log.debug("When trying to update, vertex with guid {} was not found  ", (Object)entity.getGuid());
            return;
        }
        this.addOrUpdatePropertiesVertex(g, (Vertex)vertex.next(), entity);
    }

    private void handleUpdateEntityError(Exception e) {
        this.auditLog.logException(JanusConnectorErrorCode.PROPERTIES_UPDATE_EXCEPTION.getErrorMessage(), JanusConnectorErrorCode.PROPERTIES_UPDATE_EXCEPTION.getMessageDefinition(), (Throwable)e);
        throw new JanusConnectorException(this.getClass().getName(), "updateEntity", JanusConnectorErrorCode.PROPERTIES_UPDATE_EXCEPTION);
    }

    private void addOrUpdatePropertiesVertex(GraphTraversalSource g, Vertex vertex, LineageEntity lineageEntity) {
        Map<String, Object> properties = this.getProperties(lineageEntity);
        g.inject((Object[])new Map[]{properties}).unfold().as("properties", new String[0]).V(new Object[]{vertex.id()}).as("v", new String[0]).sideEffect((Traversal)__.select((String)"properties").unfold().as("kv", new String[0]).select("v").property((Object)__.select((String)"kv").by((Function)Column.keys), (Object)__.select((String)"kv").by((Function)Column.values), new Object[0])).iterate();
    }

    public void upsertRelationship(LineageRelationship lineageRelationship) {
        GraphRelationship graphRelationship = new GraphRelationship(lineageRelationship);
        BiConsumer<GraphTraversalSource, GraphRelationship> upsertToGraph = this::upsertToGraph;
        this.graphHelper.commit(upsertToGraph, graphRelationship, this::handleStoreRelationshipError);
        BiConsumer<GraphTraversalSource, LineageRelationship> addOrUpdatePropertiesEdge = this::addOrUpdatePropertiesEdge;
        this.graphHelper.commit(addOrUpdatePropertiesEdge, lineageRelationship, this::handlePropertiesEdgeException);
    }

    private void addOrUpdatePropertiesEdge(GraphTraversalSource g, LineageRelationship lineageRelationship) {
        Map<String, Object> properties = lineageRelationship.getProperties().entrySet().stream().collect(Collectors.toMap(e -> "vertex--InstanceProp" + (String)e.getKey(), Map.Entry::getValue));
        properties.values().remove(null);
        properties.computeIfAbsent("vertex--createTime", val -> lineageRelationship.getCreateTime());
        properties.computeIfAbsent("vertex--createdBy", val -> lineageRelationship.getCreatedBy());
        properties.computeIfAbsent("vertex--updateTime", val -> lineageRelationship.getUpdateTime());
        properties.computeIfAbsent("vertex--updatedBy", val -> lineageRelationship.getUpdatedBy());
        properties.computeIfAbsent("vertex--label", val -> lineageRelationship.getTypeDefName());
        properties.computeIfAbsent("vertex--version", val -> lineageRelationship.getVersion());
        properties.computeIfAbsent("vertex--metadataCollectionId", val -> lineageRelationship.getMetadataCollectionId());
        g.inject((Object[])new Map[]{properties}).as("properties", new String[0]).V(new Object[]{lineageRelationship.getSourceEntity().getGuid()}).outE(new String[0]).where((Traversal)__.inV().hasId((Object)lineageRelationship.getTargetEntity().getGuid(), new Object[0])).as("edge", new String[0]).sideEffect((Traversal)__.select((String)"properties").unfold().as("kv", new String[0]).select("edge").property((Object)__.select((String)"kv").by((Function)Column.keys), (Object)__.select((String)"kv").by((Function)Column.values), new Object[0])).iterate();
    }

    private void handlePropertiesEdgeException(Exception e) {
        this.auditLog.logException(JanusConnectorErrorCode.UNABLE_TO_ADD_PROPERTIES_ON_EDGE_FROM_RELATIONSHIP_WITH_TYPE.getErrorMessage(), JanusConnectorErrorCode.UNABLE_TO_ADD_PROPERTIES_ON_EDGE_FROM_RELATIONSHIP_WITH_TYPE.getMessageDefinition(), (Throwable)e);
        throw new JanusConnectorException(this.getClass().getName(), "addOrUpdatePropertiesEdge", JanusConnectorErrorCode.UNABLE_TO_ADD_PROPERTIES_ON_EDGE_FROM_RELATIONSHIP_WITH_TYPE);
    }

    public void updateRelationship(LineageRelationship lineageRelationship) {
        BiConsumer<GraphTraversalSource, LineageRelationship> updateEdgeIfItExists = this::updateEdgeIfItExists;
        this.graphHelper.commit(updateEdgeIfItExists, lineageRelationship, this::handlePropertiesEdgeException);
    }

    private void updateEdgeIfItExists(GraphTraversalSource g, LineageRelationship lineageRelationship) {
        GraphTraversal edge = g.E(new Object[0]).has("edge--guid", (Object)lineageRelationship.getGuid());
        if (!edge.hasNext()) {
            log.debug("When trying to update, edge with guid {} was not found", (Object)lineageRelationship.getGuid());
            return;
        }
        this.addOrUpdatePropertiesEdge(g, lineageRelationship);
    }

    public void updateClassification(Set<GraphContext> classificationContext) {
        classificationContext.forEach(context -> this.graphHelper.commit(this::updateClassification, context, this::handleUpdateClassificationException));
    }

    private void updateClassification(GraphTraversalSource g, GraphContext graphContext) {
        String classificationGuid = graphContext.getToVertex().getGuid();
        GraphTraversal vertexIterator = g.V(new Object[0]).has("vertex--guid", (Object)classificationGuid);
        if (!vertexIterator.hasNext()) {
            log.debug("Classification with guid {} not found", (Object)classificationGuid);
            return;
        }
        Vertex storedClassification = (Vertex)vertexIterator.next();
        long storedClassificationVersion = (Long)((Map)g.V(new Object[]{storedClassification.id()}).elementMap(new String[]{"vertex--version"}).toList().get(0)).get("vertex--version");
        if (storedClassificationVersion < graphContext.getToVertex().getVersion()) {
            this.addOrUpdatePropertiesVertex(g, storedClassification, graphContext.getToVertex());
        }
    }

    private void handleUpdateClassificationException(Exception e) {
        this.auditLog.logException(JanusConnectorErrorCode.FAILED_TO_UPDATE_CLASSIFICATION_WITH_GUID.getErrorMessage(), JanusConnectorErrorCode.FAILED_TO_UPDATE_CLASSIFICATION_WITH_GUID.getMessageDefinition(), (Throwable)e);
        throw new JanusConnectorException(this.getClass().getName(), "updateClassification", JanusConnectorErrorCode.FAILED_TO_UPDATE_CLASSIFICATION_WITH_GUID);
    }

    public void deleteClassification(Set<GraphContext> classificationContext) {
        BiConsumer<GraphTraversalSource, GraphContext> deleteClassification = this::deleteClassification;
        classificationContext.forEach(classification -> this.graphHelper.commit(deleteClassification, classification, this::handleDeleteClassificationException));
    }

    private void deleteClassification(GraphTraversalSource g, GraphContext context) {
        Graph entityAndClassificationsGraph = (Graph)g.V(new Object[0]).has("vertex--guid", (Object)context.getFromVertex().getGuid()).bothE(new String[]{"Classification"}).subgraph("s").cap("s", new String[0]).next();
        Iterator edges = entityAndClassificationsGraph.edges(new Object[0]);
        while (edges.hasNext()) {
            Edge edge = (Edge)edges.next();
            String storedClassificationGuid = (String)((Map)g.E(new Object[]{edge.id()}).inV().elementMap(new String[]{"vertex--guid"}).toList().get(0)).get("vertex--guid");
            if (!context.getToVertex().getGuid().equals(storedClassificationGuid)) continue;
            this.dropEdge(g, edge, storedClassificationGuid);
            break;
        }
    }

    private void handleDeleteClassificationException(Exception e) {
        this.auditLog.logException(JanusConnectorErrorCode.DELETE_CLASSIFICATION_EXCEPTION.getErrorMessage(), JanusConnectorErrorCode.DELETE_CLASSIFICATION_EXCEPTION.getMessageDefinition(), (Throwable)e);
        throw new JanusConnectorException(this.getClass().getName(), "deleteClassification", JanusConnectorErrorCode.DELETE_CLASSIFICATION_EXCEPTION);
    }

    private void dropEdge(GraphTraversalSource g, Edge edge, String storedClassificationGuid) {
        g.V(new Object[0]).has("vertex--guid", (Object)storedClassificationGuid).drop().iterate();
        g.E(new Object[]{edge.id()}).drop().iterate();
    }

    public void deleteRelationship(String guid) {
        BiConsumer<GraphTraversalSource, String> deleteRelationship = (g, edgeGuid) -> {
            GraphTraversal edge = g.E(new Object[0]).has("edge--guid", edgeGuid);
            if (!edge.hasNext()) {
                log.debug("Edge with guid did not delete {}", edgeGuid);
                return;
            }
            g.E(new Object[]{((Edge)edge.next()).id()}).drop().iterate();
            log.debug("Edge with guid {} deleted", edgeGuid);
        };
        this.graphHelper.commit(deleteRelationship, guid, this::handleDeleteRelationshipException);
    }

    private void handleDeleteRelationshipException(Exception e) {
        this.auditLog.logException(JanusConnectorErrorCode.DELETE_RELATIONSHIP_EXCEPTION.getErrorMessage(), JanusConnectorErrorCode.DELETE_RELATIONSHIP_EXCEPTION.getMessageDefinition(), (Throwable)e);
        throw new JanusConnectorException(this.getClass().getName(), "deleteRelationship", JanusConnectorErrorCode.DELETE_RELATIONSHIP_EXCEPTION);
    }

    public void deleteEntity(String guid, Object version) {
        BiConsumer<GraphTraversalSource, String> deleteEntity = this::deleteEntity;
        this.graphHelper.commit(deleteEntity, guid, this::handleDeleteEntityException);
        log.debug("Vertex with guid {} deleted", (Object)guid);
    }

    private void deleteEntity(GraphTraversalSource g, String guid) {
        GraphTraversal vertex = g.V(new Object[0]).has("vertex--guid", (Object)guid);
        if (!vertex.hasNext()) {
            log.debug("Vertex with guid is not present {}", (Object)guid);
            return;
        }
        g.V(new Object[0]).has("vertex--guid", (Object)guid).drop().iterate();
    }

    private void handleDeleteEntityException(Exception e) {
        this.auditLog.logException(JanusConnectorErrorCode.DELETE_ENTITY_EXCEPTION.getErrorMessage(), JanusConnectorErrorCode.DELETE_ENTITY_EXCEPTION.getMessageDefinition(), (Throwable)e);
        throw new JanusConnectorException(this.getClass().getName(), "deleteEntity", JanusConnectorErrorCode.DELETE_ENTITY_EXCEPTION);
    }

    public void saveAssetLineageUpdateTime(Long lastUpdateTime) {
        BiConsumer<GraphTraversalSource, Long> saveUpdateTime = this::saveUpdateTime;
        this.graphHelper.commit(saveUpdateTime, lastUpdateTime, this::handleSaveAssetLineageUpdateTimeException);
    }

    public void handleSaveAssetLineageUpdateTimeException(Exception e) {
        this.auditLog.logException(JanusConnectorErrorCode.COULD_NOT_SAVE_LAST_UPDATE_TIME.getErrorMessage(), JanusConnectorErrorCode.COULD_NOT_SAVE_LAST_UPDATE_TIME.getMessageDefinition(), (Throwable)e);
        throw new JanusConnectorException(this.getClass().getName(), "saveAssetLineageUpdateTime", JanusConnectorErrorCode.COULD_NOT_SAVE_LAST_UPDATE_TIME);
    }

    private void saveUpdateTime(GraphTraversalSource g, Long updateTime) {
        GraphTraversal lineageVariables = g.V(new Object[0]).has("vertex--label", (Object)"ASSET_LINEAGE_VARIABLES");
        if (!lineageVariables.hasNext()) {
            g.addV("ASSET_LINEAGE_VARIABLES").property((Object)"vertex--label", (Object)"ASSET_LINEAGE_VARIABLES", new Object[0]).property((Object)"assetLineageLastUpdateTimestamp", (Object)updateTime, new Object[0]).next();
        } else {
            g.V(new Object[]{((Vertex)lineageVariables.next()).id()}).property((Object)"assetLineageLastUpdateTimestamp", (Object)updateTime, new Object[0]).next();
        }
    }

    public Optional<Long> getAssetLineageUpdateTime() {
        Function<GraphTraversalSource, Optional> getUpdateTime = this::getUpdateTime;
        return this.graphHelper.getResult(getUpdateTime, this::handleRetrievingError);
    }

    private Optional<Long> getUpdateTime(GraphTraversalSource g) {
        GraphTraversal lineageVariables = g.V(new Object[0]).has("vertex--label", (Object)"ASSET_LINEAGE_VARIABLES").valueMap(new String[0]);
        if (lineageVariables.hasNext()) {
            Map next = (Map)lineageVariables.next();
            if (next.containsKey("assetLineageLastUpdateTimestamp")) {
                return Optional.of((Long)((List)next.get("assetLineageLastUpdateTimestamp")).get(0));
            }
        } else {
            return this.getLineageUpdateTimeFromGraphVariables(g);
        }
        return Optional.empty();
    }

    private Optional<Long> getLineageUpdateTimeFromGraphVariables(GraphTraversalSource g) {
        try {
            return g.getGraph().variables().get("assetLineageLastUpdateTimestamp");
        }
        catch (UnsupportedOperationException e) {
            return Optional.empty();
        }
    }

    public Boolean isEntityInGraph(String guid) {
        return this.graphHelper.getResult(this::entityExists, guid, this::handleRetrievingError);
    }

    private boolean entityExists(GraphTraversalSource g, String guid) {
        return !g.V(new Object[0]).has("vertex--guid", (Object)guid).toList().isEmpty();
    }

    private void handleRetrievingError(Exception e) {
        log.error(JanusConnectorErrorCode.COULD_NOT_RETRIEVE_LAST_UPDATE_TIME.getErrorMessage(), (Object)JanusConnectorErrorCode.COULD_NOT_RETRIEVE_LAST_UPDATE_TIME.getMessageDefinition(), (Object)e);
    }

    private void handleRetrievingError(Exception e, String guid) {
        log.error(JanusConnectorErrorCode.ENTITY_NOT_FOUND.getFormattedErrorMessage(guid), (Object)JanusConnectorErrorCode.ENTITY_NOT_FOUND.getMessageDefinition(), (Object)e);
    }
}

