/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.util.function.TriConsumer;
import org.apache.tinkerpop.gremlin.util.function.TriFunction;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory.GraphFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.GraphDetails;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHelper {
    private AuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(GraphHelper.class);
    private GraphFactory graphFactory;
    private GraphDetails graphDetails;

    public void openGraph(String providerClass, Map<String, Object> configurationProperties, AuditLog auditLog) throws JanusConnectorException, OpenLineageException {
        this.graphFactory = new GraphFactory();
        this.auditLog = auditLog;
        this.graphDetails = this.graphFactory.openGraph(providerClass, configurationProperties);
    }

    public GraphTraversalSource getGraphTraversalSource() {
        return this.graphDetails.getGraphTraversalSource();
    }

    public boolean isSupportingTransactions() {
        return this.graphDetails.isSupportingTransactions();
    }

    public void closeGraph() {
        this.graphFactory.closeGraph();
    }

    public <U> void commit(BiConsumer<GraphTraversalSource, U> consumer, U argument, Consumer<Exception> errorHandler) {
        GraphTraversalSource g = this.getGraphTraversalSource();
        try {
            consumer.accept(g, argument);
            if (this.isSupportingTransactions()) {
                g.tx().commit();
            }
        }
        catch (Exception e) {
            g.tx().rollback();
            errorHandler.accept(e);
        }
    }

    public <V, U> void commit(TriConsumer<GraphTraversalSource, V, U> consumer, V argument1, U argument2, Consumer<Exception> errorHandler) {
        GraphTraversalSource g = this.getGraphTraversalSource();
        try {
            consumer.accept((Object)g, argument1, argument2);
            if (this.isSupportingTransactions()) {
                g.tx().commit();
            }
        }
        catch (Exception e) {
            g.tx().rollback();
            errorHandler.accept(e);
        }
    }

    public <U> U getResult(Function<GraphTraversalSource, U> function, Consumer<Exception> errorHandler) {
        GraphTraversalSource g = this.getGraphTraversalSource();
        U result = null;
        try {
            result = function.apply(g);
            if (this.isSupportingTransactions()) {
                g.tx().commit();
            }
        }
        catch (Exception e) {
            g.tx().rollback();
            errorHandler.accept(e);
        }
        return result;
    }

    public <U, V> U getResult(BiFunction<GraphTraversalSource, V, U> function, V argument, BiConsumer<Exception, V> errorHandler) {
        GraphTraversalSource g = this.getGraphTraversalSource();
        U result = null;
        try {
            result = function.apply(g, argument);
            if (this.isSupportingTransactions()) {
                g.tx().commit();
            }
        }
        catch (Exception e) {
            g.tx().rollback();
            errorHandler.accept(e, argument);
        }
        return result;
    }

    public <U, V, T> U getResult(TriFunction<GraphTraversalSource, V, T, U> function, V argument1, T argument2, TriConsumer<Exception, V, T> errorHandler) {
        GraphTraversalSource g = this.getGraphTraversalSource();
        Object result = null;
        try {
            result = function.apply((Object)g, argument1, argument2);
            if (this.isSupportingTransactions()) {
                g.tx().commit();
            }
        }
        catch (Exception e) {
            g.tx().rollback();
            errorHandler.accept((Object)e, argument1, argument2);
        }
        return (U)result;
    }
}

