/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.remote.DriverRemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.AnonymousTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.util.system.ConfigurationUtil;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory.OpenLineageSchemaHelper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphConnectorProvider;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.graph.LineageGraphRemoteConnectorProvider;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.GraphDetails;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphFactory {
    private static final Logger log = LoggerFactory.getLogger(GraphFactory.class);
    private Graph graph;
    private boolean supportingTransactions;
    private Cluster cluster;
    private Client client;
    private OpenLineageSchemaHelper<Element> openLineageSchemaHelper;

    public GraphDetails openGraph(String providerClass, Map<String, Object> configurationProperties) throws JanusConnectorException {
        this.openLineageSchemaHelper = new OpenLineageSchemaHelper();
        GraphTraversalSource graphTraversalSource = null;
        boolean supportingTransactions = false;
        boolean isRemoteGraph = false;
        if (providerClass.equals(LineageGraphConnectorProvider.class.getName())) {
            graphTraversalSource = this.openEmbeddedGraph(configurationProperties);
            supportingTransactions = true;
            isRemoteGraph = false;
        }
        if (providerClass.equals(LineageGraphRemoteConnectorProvider.class.getName())) {
            graphTraversalSource = this.openRemoteGraph(configurationProperties);
            supportingTransactions = false;
            isRemoteGraph = true;
        }
        return new GraphDetails(graphTraversalSource, supportingTransactions, isRemoteGraph);
    }

    private GraphTraversalSource openEmbeddedGraph(Map<String, Object> properties) throws JanusConnectorException {
        String methodName = "openEmbeddedGraph";
        try {
            this.graph = JanusGraphFactory.open((Configuration)ConfigurationUtil.loadMapConfiguration(properties));
            JanusGraph janusGraph = (JanusGraph)this.graph;
            this.initializeGraph(janusGraph);
            return janusGraph.traversal();
        }
        catch (Exception e) {
            log.error("A connection with the graph database could not be established with the provided configuration", (Throwable)e);
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.CANNOT_OPEN_GRAPH_DB;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(e.getMessage(), "openEmbeddedGraph", GraphFactory.class.getName());
            throw this.mapConnectorException("openEmbeddedGraph", errorMessage, errorCode);
        }
    }

    private GraphTraversalSource openRemoteGraph(Map<String, Object> properties) throws JanusConnectorException {
        String methodName = "openRemoteGraph";
        this.supportingTransactions = false;
        try {
            this.cluster = this.openCluster(properties);
            this.client = this.cluster.connect();
            if (this.isSchemaManagementEnabled(properties)) {
                this.initializeRemoteGraph(this.client);
            }
            return (GraphTraversalSource)AnonymousTraversalSource.traversal().withRemote((RemoteConnection)DriverRemoteConnection.using((Cluster)this.cluster, (String)properties.getOrDefault("gremlin.remote.driver.sourceName", "g").toString()));
        }
        catch (Exception e) {
            log.error("A connection with the graph database could not be established with the provided configuration", (Throwable)e);
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.CANNOT_OPEN_GRAPH_DB;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(e.getMessage(), methodName, GraphFactory.class.getName());
            throw this.mapConnectorException(methodName, errorMessage, errorCode);
        }
    }

    private boolean isSchemaManagementEnabled(Map<String, Object> properties) {
        return properties.get("remote.schemaManagement.enable") != null && "true".equalsIgnoreCase(properties.get("remote.schemaManagement.enable").toString());
    }

    private void initializeGraph(JanusGraph janusGraph) throws JanusConnectorException {
        String methodName = "initializeGraph";
        log.debug("Initializing graph. Updating schema, if necessary.");
        try {
            this.openLineageSchemaHelper.createSchemas(janusGraph);
            this.openLineageSchemaHelper.createIndexes(janusGraph);
        }
        catch (Exception e) {
            log.error("Failed  during graph initialize operation", (Throwable)e);
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.GRAPH_INITIALIZATION_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(e.getMessage(), "initializeGraph", GraphFactory.class.getName());
            throw this.mapConnectorException("initializeGraph", errorMessage, errorCode);
        }
    }

    private void initializeRemoteGraph(Client client) throws JanusConnectorException {
        String methodName = "initializeRemoteGraph";
        log.debug("Initializing graph remotely. Updating schema, if necessary.");
        try {
            this.openLineageSchemaHelper.createLabels(client);
            this.openLineageSchemaHelper.createIndexes(client);
        }
        catch (Exception e) {
            log.error("Failed  during graph initialize operation ", (Throwable)e);
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.GRAPH_INITIALIZATION_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(e.getMessage(), "initializeRemoteGraph", GraphFactory.class.getName());
            throw this.mapConnectorException("initializeRemoteGraph", errorMessage, errorCode);
        }
    }

    private Cluster openCluster(Map configurationProperties) {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)configurationProperties);
        Configuration config = ConfigurationConverter.getConfiguration((Properties)p);
        return Cluster.open((Configuration)config);
    }

    public void closeGraph() {
        try {
            if (this.graph != null) {
                this.graph.close();
            }
            if (this.cluster != null) {
                this.cluster.close();
            }
        }
        catch (Exception e) {
            log.error("Exception while closing the graph.", (Throwable)e);
        }
        finally {
            this.graph = null;
            this.client = null;
            this.cluster = null;
        }
    }

    private JanusConnectorException mapConnectorException(String methodName, String errorMessage, JanusConnectorErrorCode errorCode) {
        return new JanusConnectorException(GraphFactory.class.getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

