/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.util;

import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;

public class OpenLineageExceptionHandler
extends RESTExceptionHandler {
    public void captureOpenLineageException(FFDCResponseBase response, OpenLineageException e) {
        response.setRelatedHTTPCode(e.getReportedHTTPCode());
        response.setExceptionClassName(((Object)((Object)e)).getClass().getName());
        response.setExceptionErrorMessage(e.getReportedErrorMessage());
        response.setExceptionSystemAction(e.getReportedSystemAction());
        response.setExceptionUserAction(e.getReportedUserAction());
    }

    public void detectAndThrowOpenLineageException(String methodName, FFDCResponseBase restResult) throws OpenLineageException {
        String exceptionClassName = OpenLineageException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new OpenLineageException(restResult.getRelatedHTTPCode(), ((Object)((Object)this)).getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        }
    }
}

