/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.client;

import java.security.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.openlineage.model.GraphName;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.model.View;
import org.odpi.openmetadata.governanceservers.openlineage.responses.VoidResponse;
import org.springframework.web.client.RestTemplate;

public class OpenLineage {
    private String serverName;
    private String serverURL;
    private RestTemplate restTemplate;

    public OpenLineage(String serverName, String newServerURL) {
        this.serverName = serverName;
        this.serverURL = newServerURL;
        this.restTemplate = new RestTemplate();
    }

    public String lineage(String userId, GraphName graphName, Scope scope, View view, String guid) throws InvalidParameterException {
        String methodName = "lineage";
        String url = "/servers/{0}/open-metadata/open-lineage/users/{1}/lineage/sources/{2}/scopes/{3}/views/{4}/entities/{5}";
        return this.getRestCall(url, String.class, this.serverName, userId, graphName.getText(), scope.getValue(), view.getValue(), guid);
    }

    public VoidResponse dumpGraph(String userId, GraphName graphName) throws InvalidParameterException {
        String methodName = "dumpGraph";
        String url = "/servers/{0}/open-metadata/open-lineage/users/{1}/dump/graphs/{2}";
        return this.getRestCall(url, VoidResponse.class, this.serverName, userId, graphName.getText());
    }

    public String exportGraph(String userId, GraphName graphName) throws InvalidParameterException {
        String methodName = "exportGraph";
        String url = "/servers/{0}/open-metadata/open-lineage/users/{1}/export/graphs/{2}";
        return this.getRestCall(url, String.class, this.serverName, userId, graphName.getText());
    }

    public String generateMockGraph(String userId) throws InvalidParameterException {
        String methodName = "generateMockGraph";
        String url = "/servers/{0}/open-metadata/open-lineage/users/{1}/generate-mock-graph";
        return this.getRestCall(url, String.class, this.serverName, userId);
    }

    private <T> T getRestCall(String url, Class<T> clazz, Object ... params) {
        return (T)this.restTemplate.getForObject(this.serverURL + url, clazz, params);
    }
}

