/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.client;

import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.governanceservers.openlineage.client.OpenLineageInterface;
import org.odpi.openmetadata.governanceservers.openlineage.model.GraphName;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.model.View;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;

public class OpenLineageClient
extends FFDCRESTClient
implements OpenLineageInterface {
    private static final String BASE_PATH = "/servers/{0}/open-metadata/open-lineage/users/{1}";
    private static final String LINEAGE = "/lineage/";
    private static final String LINEAGE_SOURCES = "/sources/{2}";
    private static final String LINEAGE_SCOPES = "/scopes/{3}";
    private static final String LINEAGE_VIEWS = "/views/{4}";
    private static final String LINEAGE_ENTITIES = "/entities/{5}";
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public OpenLineageClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public OpenLineageClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    @Override
    public LineageVerticesAndEdges lineage(String userId, GraphName graphName, Scope scope, View view, String guid) throws InvalidParameterException, PropertyServerException {
        String methodName = "lineage";
        LineageResponse lineageResponse = (LineageResponse)this.callGetRESTCall(methodName, LineageResponse.class, this.serverPlatformURLRoot + BASE_PATH + LINEAGE + LINEAGE_SOURCES + LINEAGE_SCOPES + LINEAGE_VIEWS + LINEAGE_ENTITIES, new Object[]{this.serverName, userId, graphName.getText(), scope.getValue(), view.getValue(), guid});
        this.detectExceptions(methodName, lineageResponse);
        LineageVerticesAndEdges lineageVerticesAndEdges = lineageResponse.getLineageVerticesAndEdges();
        return lineageVerticesAndEdges;
    }

    private void detectExceptions(String methodName, LineageResponse response) throws InvalidParameterException, PropertyServerException {
        this.exceptionHandler.detectAndThrowInvalidParameterException(methodName, (FFDCResponseBase)response);
        this.exceptionHandler.detectAndThrowPropertyServerException(methodName, (FFDCResponseBase)response);
    }
}

