/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.client;

import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.governanceservers.openlineage.client.OpenLineageInterface;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageQueryParameters;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageVertexResponse;
import org.odpi.openmetadata.governanceservers.openlineage.util.OpenLineageExceptionHandler;

public class OpenLineageClient
extends FFDCRESTClient
implements OpenLineageInterface {
    private static final String BASE_PATH = "/servers/{0}/open-metadata/open-lineage/users/{1}";
    private static final String LINEAGE = "/lineage/";
    private static final String ENTITIES = "/entities/{2}";
    private static final String DETAILS = "/details";
    private OpenLineageExceptionHandler openLineageExceptionHandler = new OpenLineageExceptionHandler();

    public OpenLineageClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
    }

    public OpenLineageClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password);
    }

    @Override
    public LineageVerticesAndEdges lineage(String userId, Scope scope, String guid, String displayNameMustContain, boolean includeProcesses) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        String methodName = "OpenLineageClient.lineage";
        LineageQueryParameters postBody = new LineageQueryParameters(scope, displayNameMustContain, includeProcesses);
        LineageResponse lineageResponse = (LineageResponse)this.callPostRESTCall(methodName, LineageResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/open-lineage/users/{1}/lineage//entities/{2}", postBody, new Object[]{this.serverName, userId, guid});
        this.detectExceptions(methodName, (FFDCResponseBase)lineageResponse);
        LineageVerticesAndEdges lineageVerticesAndEdges = lineageResponse.getLineageVerticesAndEdges();
        return lineageVerticesAndEdges;
    }

    public LineageVertex getEntityDetails(String userId, String guid) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        String methodName = "OpenLineageClient.getEntityDetails";
        LineageVertexResponse lineageVertexResponse = (LineageVertexResponse)this.callGetRESTCall(methodName, LineageVertexResponse.class, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/open-lineage/users/{1}/lineage//entities/{2}/details", new Object[]{this.serverName, userId, guid});
        this.detectExceptions(methodName, (FFDCResponseBase)lineageVertexResponse);
        LineageVertex entityDetails = lineageVertexResponse.getLineageVertex();
        return entityDetails;
    }

    private void detectExceptions(String methodName, FFDCResponseBase response) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        this.openLineageExceptionHandler.detectAndThrowInvalidParameterException((FFDCResponse)response);
        this.openLineageExceptionHandler.detectAndThrowPropertyServerException((FFDCResponse)response);
        this.openLineageExceptionHandler.detectAndThrowOpenLineageException(methodName, response);
    }
}

