/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.listeners;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.odpi.openmetadata.accessservices.assetlineage.model.assetContext.AssetLineageEvent;
import org.odpi.openmetadata.accessservices.assetlineage.model.event.AssetLineageEntityEvent;
import org.odpi.openmetadata.accessservices.assetlineage.model.event.DeletePurgedRelationshipEvent;
import org.odpi.openmetadata.accessservices.assetlineage.model.event.RelationshipEvent;
import org.odpi.openmetadata.governanceservers.openlineage.responses.ffdc.OpenLineageErrorCode;
import org.odpi.openmetadata.governanceservers.openlineage.services.GraphStoringServices;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InTopicListener
implements OpenMetadataTopicListener {
    private static final Logger log = LoggerFactory.getLogger(InTopicListener.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final OMRSAuditLog auditLog;
    private GraphStoringServices graphStoringServices;

    public InTopicListener(GraphStoringServices graphStoringServices, OMRSAuditLog auditLog) {
        this.graphStoringServices = graphStoringServices;
        this.auditLog = auditLog;
    }

    public void processEvent(String eventAsString) {
        AssetLineageEvent event = null;
        try {
            event = (AssetLineageEvent)OBJECT_MAPPER.readValue(eventAsString, AssetLineageEvent.class);
            log.info("Started processing OpenLineageEvent");
        }
        catch (Exception e) {
            log.error("Exception processing event from in topic", (Throwable)e);
            OpenLineageErrorCode auditCode = OpenLineageErrorCode.PROCESS_EVENT_EXCEPTION;
            this.auditLog.logException("processEvent", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(new String[]{eventAsString, e.getMessage()}), e.getMessage(), auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
        }
        try {
            switch (event.getOmrsInstanceEventType()) {
                case NEW_ENTITY_EVENT: {
                    AssetLineageEntityEvent newEntityEvent = (AssetLineageEntityEvent)OBJECT_MAPPER.readValue(eventAsString, AssetLineageEntityEvent.class);
                    break;
                }
                case NEW_RELATIONSHIP_EVENT: {
                    RelationshipEvent relationshipEvent = (RelationshipEvent)OBJECT_MAPPER.readValue(eventAsString, RelationshipEvent.class);
                    break;
                }
                case DELETE_PURGED_RELATIONSHIP_EVENT: {
                    DeletePurgedRelationshipEvent deletePurgedRelationshipEvent = (DeletePurgedRelationshipEvent)OBJECT_MAPPER.readValue(eventAsString, DeletePurgedRelationshipEvent.class);
                }
            }
        }
        catch (IOException e) {
            log.debug(e.getMessage());
        }
    }
}

