/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.listeners;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.assetlineage.model.event.LineageEvent;
import org.odpi.openmetadata.governanceservers.openlineage.responses.ffdc.OpenLineageErrorCode;
import org.odpi.openmetadata.governanceservers.openlineage.services.GraphStoringServices;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InTopicListener
implements OpenMetadataTopicListener {
    private static final Logger log = LoggerFactory.getLogger(InTopicListener.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final OMRSAuditLog auditLog;
    private GraphStoringServices graphStoringServices;

    public InTopicListener(GraphStoringServices graphStoringServices, OMRSAuditLog auditLog) {
        this.graphStoringServices = graphStoringServices;
        this.auditLog = auditLog;
    }

    public void processEvent(String eventAsString) {
        LineageEvent event = null;
        try {
            event = (LineageEvent)OBJECT_MAPPER.readValue(eventAsString, LineageEvent.class);
            log.info("Started processing OpenLineageEvent");
            this.processEventBasedOnType(event);
        }
        catch (Exception e) {
            log.error("Exception processing event from in topic", (Throwable)e);
            OpenLineageErrorCode auditCode = OpenLineageErrorCode.PROCESS_EVENT_EXCEPTION;
            this.auditLog.logException("processEvent", auditCode.getErrorMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, auditCode.getFormattedErrorMessage(new String[]{eventAsString, e.getMessage()}), e.getMessage(), auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
        }
    }

    private void processEventBasedOnType(LineageEvent event) {
        switch (event.getAssetLineageEventType()) {
            case PROCESS_CONTEXT_EVENT: 
            case TECHNICAL_ELEMENT_CONTEXT_EVENT: {
                this.graphStoringServices.addEntity(event);
                break;
            }
        }
    }
}

