/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.scheduler;

import org.odpi.openmetadata.governanceservers.openlineage.buffergraphstore.BufferGraph;
import org.odpi.openmetadata.governanceservers.openlineage.scheduler.BufferGraphJob;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JobConfiguration.class);
    private static Scheduler scheduler;
    private static BufferGraph bufferGraph;

    public JobConfiguration(BufferGraph bufferGraph) {
        JobConfiguration.bufferGraph = bufferGraph;
        this.schedule();
    }

    public void schedule() {
        String methodName = "schedule";
        log.debug(" QuartzSchedulerApp main thread: {}", (Object)Thread.currentThread().getName());
        try {
            scheduler = new StdSchedulerFactory().getScheduler();
            scheduler.start();
        }
        catch (SchedulerException e) {
            log.error("{} could not run the job for bufferGraph", (Object)"schedule");
        }
        Trigger trigger = JobConfiguration.buildSimpleSchedulerTrigger();
        try {
            JobConfiguration.scheduleJob(trigger);
        }
        catch (Exception e) {
            log.error("The job did not start because of an error with message: {}", (Object)e.getMessage());
        }
    }

    private static void scheduleJob(Trigger trigger) throws Exception {
        JobDetail jobDetail = JobBuilder.newJob(BufferGraphJob.class).withIdentity("BufferGraphJob", "group").build();
        jobDetail.getJobDataMap().put("openLineageGraphStore", (Object)bufferGraph);
        scheduler.scheduleJob(jobDetail, trigger);
    }

    private static Trigger buildSimpleSchedulerTrigger() {
        int INTERVAL_SECONDS = 15;
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("BufferGraphJob", "group").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(INTERVAL_SECONDS).repeatForever()).build();
        return trigger;
    }
}

