/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.server;

import org.odpi.openmetadata.governanceservers.openlineage.responses.ffdc.OpenLineageErrorCode;
import org.odpi.openmetadata.governanceservers.openlineage.responses.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.governanceservers.openlineage.server.OpenLineageServicesInstance;
import org.odpi.openmetadata.governanceservers.openlineage.server.OpenLineageServicesInstanceMap;
import org.odpi.openmetadata.governanceservers.openlineage.services.GraphQueryingServices;

class OpenLineageInstanceHandler {
    private static OpenLineageServicesInstanceMap instanceMap = new OpenLineageServicesInstanceMap();

    OpenLineageInstanceHandler() {
    }

    public GraphQueryingServices queryHandler(String serverName) throws PropertyServerException {
        OpenLineageServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getGraphQueryingServices();
        }
        String methodName = "queryHandler";
        this.throwError(serverName, "queryHandler");
        return null;
    }

    private void throwError(String serverName, String methodName) throws PropertyServerException {
        OpenLineageErrorCode errorCode = OpenLineageErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
        throw new PropertyServerException(this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

