/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.server;

import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.handlers.OpenLineageHandler;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.model.View;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;
import org.odpi.openmetadata.governanceservers.openlineage.server.OpenLineageInstanceHandler;
import org.odpi.openmetadata.governanceservers.openlineage.util.OpenLineageExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLineageRestServices {
    private static final Logger log = LoggerFactory.getLogger(OpenLineageRestServices.class);
    private final OpenLineageInstanceHandler instanceHandler = new OpenLineageInstanceHandler();
    private OpenLineageExceptionHandler openLineageExceptionHandler = new OpenLineageExceptionHandler();

    public VoidResponse dumpGraph(String serverName, String userId) {
        VoidResponse response = new VoidResponse();
        String methodName = "OpenLineageRestServices.dumpGraph";
        try {
            OpenLineageHandler openLineageHandler = this.instanceHandler.getOpenLineageHandler(userId, serverName, "OpenLineageRestServices.dumpGraph");
            openLineageHandler.dumpMainGraph();
        }
        catch (InvalidParameterException error) {
            this.openLineageExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.openLineageExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.openLineageExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.openLineageExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "OpenLineageRestServices.dumpGraph");
        }
        return response;
    }

    public String exportMainGraph(String serverName, String userId) {
        String response;
        String methodName = "OpenLineageRestServices.exportGraph";
        try {
            OpenLineageHandler graphServices = this.instanceHandler.getOpenLineageHandler(userId, serverName, "OpenLineageRestServices.exportGraph");
            response = graphServices.exportMainGraph();
        }
        catch (Exception e) {
            response = e.getMessage();
        }
        return response;
    }

    public LineageResponse lineage(String serverName, String userId, Scope scope, View view, String guid, String displayNameMustContain, boolean includeProcesses) {
        LineageResponse response = new LineageResponse();
        String methodName = "OpenLineageRestServices.lineage";
        try {
            OpenLineageHandler openLineageHandler = this.instanceHandler.getOpenLineageHandler(userId, serverName, "OpenLineageRestServices.lineage");
            response = openLineageHandler.lineage(scope, view, guid, displayNameMustContain, includeProcesses);
        }
        catch (InvalidParameterException error) {
            this.openLineageExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.openLineageExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.openLineageExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OpenLineageException error) {
            this.openLineageExceptionHandler.captureOpenLineageException(response, error);
        }
        catch (Throwable error) {
            this.openLineageExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "OpenLineageRestServices.lineage");
        }
        return response;
    }
}

