/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.admin;

import org.odpi.openmetadata.adminservices.configuration.properties.OpenLineageServerConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.openlineage.OpenLineageGraphConnector;
import org.odpi.openmetadata.governanceservers.openlineage.auditlog.OpenLineageServerAuditCode;
import org.odpi.openmetadata.governanceservers.openlineage.buffergraph.BufferGraph;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageServerErrorCode;
import org.odpi.openmetadata.governanceservers.openlineage.handlers.OpenLineageHandler;
import org.odpi.openmetadata.governanceservers.openlineage.listeners.OpenLineageInTopicListener;
import org.odpi.openmetadata.governanceservers.openlineage.maingraph.MainGraph;
import org.odpi.openmetadata.governanceservers.openlineage.server.OpenLineageServerInstance;
import org.odpi.openmetadata.governanceservers.openlineage.services.StoringServices;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLineageServerOperationalServices {
    private static final Logger log = LoggerFactory.getLogger(OpenLineageServerOperationalServices.class);
    private String localServerName;
    private String localServerUserId;
    private String localServerPassword;
    private int maxPageSize;
    private OpenLineageServerConfig openLineageServerConfig;
    private OpenLineageServerInstance openLineageServerInstance = null;
    private OMRSAuditLog auditLog = null;
    private BufferGraph bufferGraphConnector;
    private MainGraph mainGraphConnector;
    private OpenMetadataTopicConnector inTopicConnector;

    public OpenLineageServerOperationalServices(String localServerName, String localServerUserId, String localServerPassword, int maxPageSize) {
        this.localServerName = localServerName;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
        this.maxPageSize = maxPageSize;
    }

    public void initialize(OpenLineageServerConfig openLineageServerConfig, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        this.openLineageServerConfig = openLineageServerConfig;
        this.auditLog = auditLog;
        String methodName = "initialize";
        String actionDescription = "Initialize Open lineage Services";
        this.logRecord(OpenLineageServerAuditCode.SERVER_INITIALIZING, "Initialize Open lineage Services");
        if (openLineageServerConfig == null) {
            this.throwOMAGConfigurationErrorException(OpenLineageServerErrorCode.NO_CONFIG_DOC, "initialize", OpenLineageServerAuditCode.NO_CONFIG_DOC, "Initialize Open lineage Services");
        }
        try {
            this.initializeOLS(openLineageServerConfig);
        }
        catch (OMAGConfigurationErrorException e) {
            throw e;
        }
        catch (Exception e) {
            this.exceptionToOMAGConfigurationError(e, OpenLineageServerErrorCode.ERROR_INITIALIZING_OLS, "initialize", OpenLineageServerAuditCode.ERROR_INITIALIZING_OLS, "Initialize Open lineage Services");
        }
    }

    private void initializeOLS(OpenLineageServerConfig openLineageServerConfig) throws OMAGConfigurationErrorException {
        String actionDescription = "Initialize Open lineage Services";
        Connection bufferGraphConnection = openLineageServerConfig.getOpenLineageBufferGraphConnection();
        Connection mainGraphConnection = openLineageServerConfig.getOpenLineageMainGraphConnection();
        Connection inTopicConnection = openLineageServerConfig.getInTopicConnection();
        this.bufferGraphConnector = (BufferGraph)this.getConnector(bufferGraphConnection, OpenLineageServerErrorCode.ERROR_OBTAINING_BUFFER_GRAPH_CONNECTOR, OpenLineageServerAuditCode.ERROR_OBTAINING_BUFFER_GRAPH_CONNNECTOR);
        this.mainGraphConnector = (MainGraph)this.getConnector(mainGraphConnection, OpenLineageServerErrorCode.ERROR_OBTAINING_MAIN_GRAPH_CONNECTOR, OpenLineageServerAuditCode.ERROR_OBTAINING_MAIN_GRAPH_CONNNECTOR);
        this.inTopicConnector = (OpenMetadataTopicConnector)this.getConnector(inTopicConnection, OpenLineageServerErrorCode.ERROR_OBTAINING_IN_TOPIC_CONNECTOR, OpenLineageServerAuditCode.ERROR_OBTAINING_IN_TOPIC_CONNECTOR);
        this.initializeAndStartConnectors();
        OpenLineageHandler openLineageHandler = new OpenLineageHandler(this.mainGraphConnector);
        this.openLineageServerInstance = new OpenLineageServerInstance(this.localServerName, GovernanceServicesDescription.OPEN_LINEAGE_SERVICES.getServiceName(), this.maxPageSize, openLineageHandler);
        this.logRecord(OpenLineageServerAuditCode.SERVER_INITIALIZED, "Initialize Open lineage Services");
    }

    private Connector getConnector(Connection connection, OpenLineageServerErrorCode errorCode, OpenLineageServerAuditCode auditCode) throws OMAGConfigurationErrorException {
        String actionDescription = "Obtaining graph database connector";
        String methodName = "getGraphConnector";
        Connector connector = null;
        try {
            connector = new ConnectorBroker().getConnector(connection);
        }
        catch (OCFCheckedExceptionBase e) {
            this.OCFCheckedExceptionToOMAGConfigurationError(e, auditCode, "Obtaining graph database connector");
        }
        catch (Exception e) {
            this.exceptionToOMAGConfigurationError(e, errorCode, "getGraphConnector", auditCode, "Obtaining graph database connector");
        }
        return connector;
    }

    private void initializeAndStartConnectors() throws OMAGConfigurationErrorException {
        this.initializeGraphConnectorDB((OpenLineageGraphConnector)this.bufferGraphConnector, OpenLineageServerErrorCode.ERROR_INITIALIZING_BUFFER_GRAPH_CONNECTOR_DB, OpenLineageServerAuditCode.ERROR_INITIALIZING_BUFFER_GRAPH_CONNNECTOR_DB, "initializeBufferGraphConnector");
        this.initializeGraphConnectorDB((OpenLineageGraphConnector)this.mainGraphConnector, OpenLineageServerErrorCode.ERROR_INITIALIZING_MAIN_GRAPH_CONNECTOR_DB, OpenLineageServerAuditCode.ERROR_INITIALIZING_MAIN_GRAPH_CONNECTOR_DB, "initializeMainGraphConnector");
        Object mainGraph = this.mainGraphConnector.getMainGraph();
        this.bufferGraphConnector.setMainGraph(mainGraph);
        this.startGraphConnector((OpenLineageGraphConnector)this.bufferGraphConnector, OpenLineageServerErrorCode.ERROR_STARTING_BUFFER_GRAPH_CONNECTOR, OpenLineageServerAuditCode.ERROR_STARTING_BUFFER_GRAPH_CONNECTOR, "startBufferGraphConnector");
        this.startGraphConnector((OpenLineageGraphConnector)this.mainGraphConnector, OpenLineageServerErrorCode.ERROR_OBTAINING_MAIN_GRAPH_CONNECTOR, OpenLineageServerAuditCode.ERROR_STARTING_MAIN_GRAPH_CONNECTOR, "startMainGraphConnector");
        this.startIntopicConnector();
    }

    private void initializeGraphConnectorDB(OpenLineageGraphConnector connector, OpenLineageServerErrorCode errorCode, OpenLineageServerAuditCode auditCode, String actionDescription) throws OMAGConfigurationErrorException {
        String methodName = "initializeGraphConnectorDB";
        try {
            connector.initializeGraphDB();
        }
        catch (OCFCheckedExceptionBase e) {
            this.OCFCheckedExceptionToOMAGConfigurationError(e, auditCode, actionDescription);
        }
        catch (Exception e) {
            this.exceptionToOMAGConfigurationError(e, errorCode, "initializeGraphConnectorDB", auditCode, actionDescription);
        }
    }

    private void startGraphConnector(OpenLineageGraphConnector connector, OpenLineageServerErrorCode errorCode, OpenLineageServerAuditCode auditCode, String actionDescription) throws OMAGConfigurationErrorException {
        String methodName = "startGraphConnector";
        try {
            connector.start();
        }
        catch (OCFCheckedExceptionBase e) {
            this.OCFCheckedExceptionToOMAGConfigurationError(e, auditCode, actionDescription);
        }
        catch (Exception e) {
            this.exceptionToOMAGConfigurationError(e, errorCode, "startGraphConnector", auditCode, actionDescription);
        }
    }

    private void startIntopicConnector() throws OMAGConfigurationErrorException {
        String actionDescription = "Start the Open Lineage Services in-topic listener";
        String methodName = "startIntopicConnector";
        OpenLineageServerAuditCode auditCode = OpenLineageServerAuditCode.ERROR_STARTING_IN_TOPIC_CONNECTOR;
        this.inTopicConnector.setAuditLog((AuditLog)this.auditLog);
        StoringServices storingServices = new StoringServices(this.bufferGraphConnector);
        OpenLineageInTopicListener openLineageInTopicListener = new OpenLineageInTopicListener(storingServices, this.auditLog);
        this.inTopicConnector.registerListener((OpenMetadataTopicListener)openLineageInTopicListener);
        try {
            this.inTopicConnector.start();
        }
        catch (OCFCheckedExceptionBase e) {
            this.OCFCheckedExceptionToOMAGConfigurationError(e, auditCode, "Start the Open Lineage Services in-topic listener");
        }
        catch (Exception e) {
            this.exceptionToOMAGConfigurationError(e, OpenLineageServerErrorCode.ERROR_STARTING_IN_TOPIC_CONNECTOR, "startIntopicConnector", auditCode, "Start the Open Lineage Services in-topic listener");
        }
        this.logRecord(OpenLineageServerAuditCode.SERVER_REGISTERED_WITH_IN_TOPIC, "Start the Open Lineage Services in-topic listener");
    }

    private void throwOMAGConfigurationErrorException(OpenLineageServerErrorCode errorCode, String methodName, OpenLineageServerAuditCode auditCode, String actionDescription) throws OMAGConfigurationErrorException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.localServerName});
        OMAGConfigurationErrorException e = new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        this.logException(auditCode, actionDescription, (Exception)((Object)e));
        throw e;
    }

    private void exceptionToOMAGConfigurationError(Exception e, OpenLineageServerErrorCode errorCode, String methodName, OpenLineageServerAuditCode auditCode, String actionDescription) throws OMAGConfigurationErrorException {
        this.logException(auditCode, actionDescription, e);
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.localServerName});
        throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void exceptionToPropertyServerException(Exception e, OpenLineageServerErrorCode errorCode, String methodName, OpenLineageServerAuditCode auditCode, String actionDescription) throws PropertyServerException {
        this.logException(auditCode, actionDescription, e);
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.localServerName});
        throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void OCFCheckedExceptionToOMAGConfigurationError(OCFCheckedExceptionBase e, OpenLineageServerAuditCode auditCode, String actionDescription) throws OMAGConfigurationErrorException {
        this.logException(auditCode, actionDescription, (Exception)((Object)e));
        throw new OMAGConfigurationErrorException(e.getReportedHTTPCode(), e.getReportingClassName(), e.getReportingActionDescription(), e.getErrorMessage(), e.getReportedSystemAction(), e.getReportedUserAction());
    }

    public boolean shutdown() throws PropertyServerException {
        String actionDescription = "Shutting down the open lineage Services server.";
        this.logRecord(OpenLineageServerAuditCode.SERVER_SHUTTING_DOWN, actionDescription);
        this.disconnectInTopicConnector();
        this.disconnectGraphConnector((OpenLineageGraphConnector)this.bufferGraphConnector, OpenLineageServerErrorCode.ERROR_DISCONNECTING_BUFFER_GRAPH_CONNECTOR, OpenLineageServerAuditCode.ERROR_DISCONNECTING_BUFFER_GRAPH_CONNECTOR, "Disconnecting the Buffergraph connection.");
        this.disconnectGraphConnector((OpenLineageGraphConnector)this.mainGraphConnector, OpenLineageServerErrorCode.ERROR_DISCONNECTING_MAIN_GRAPH_CONNECTOR, OpenLineageServerAuditCode.ERROR_DISCONNECTING_MAIN_GRAPH_CONNECTOR, "Disconnecting the Maingraph connection.");
        if (this.openLineageServerInstance != null) {
            this.openLineageServerInstance.shutdown();
        }
        this.logRecord(OpenLineageServerAuditCode.SERVER_SHUTDOWN, actionDescription);
        return true;
    }

    private void disconnectGraphConnector(OpenLineageGraphConnector connector, OpenLineageServerErrorCode errorCode, OpenLineageServerAuditCode auditCode, String actionDescription) throws PropertyServerException {
        String methodName = "disconnectGraphConnector";
        if (connector == null) {
            return;
        }
        try {
            connector.disconnect();
        }
        catch (Exception e) {
            this.exceptionToPropertyServerException(e, errorCode, "disconnectGraphConnector", auditCode, actionDescription);
        }
    }

    private void disconnectInTopicConnector() throws PropertyServerException {
        String methodName = "disconnectInTopicConnector";
        String actionDescription = "Disconnecting the Open Lineage Services in-topic listener";
        if (this.inTopicConnector == null) {
            return;
        }
        try {
            this.inTopicConnector.disconnect();
        }
        catch (Exception e) {
            this.exceptionToPropertyServerException(e, OpenLineageServerErrorCode.ERROR_DISCONNECTING_IN_TOPIC_CONNECTOR, "disconnectInTopicConnector", OpenLineageServerAuditCode.ERROR_DISCONNECTING_IN_TOPIC_CONNECTOR, "Disconnecting the Open Lineage Services in-topic listener");
        }
    }

    private void logRecord(OpenLineageServerAuditCode auditCode, String actionDescription) {
        this.auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        log.info(auditCode.getSystemAction());
    }

    private void logException(OpenLineageServerAuditCode auditCode, String actionDescription, Exception e) {
        this.auditLog.logException(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.localServerName, this.openLineageServerConfig.toString()), null, auditCode.getSystemAction(), auditCode.getUserAction(), (Throwable)e);
        log.error(auditCode.getSystemAction(), (Throwable)e);
    }
}

