/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.scheduler;

import java.time.LocalDateTime;
import org.odpi.openmetadata.governanceservers.openlineage.graph.LineageGraph;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public class LineageGraphJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(LineageGraphJob.class);

    public void execute(JobExecutionContext context) {
        LocalDateTime localTime = LocalDateTime.now();
        log.debug("Run QuartzJob at {}", (Object)localTime);
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        LineageGraph lineageGraph = (LineageGraph)dataMap.get((Object)"openLineageGraphStore");
        this.performTask(lineageGraph);
    }

    private void performTask(LineageGraph lineageGraph) {
        lineageGraph.schedulerTask();
    }
}

