/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.server;

import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.handlers.OpenLineageHandler;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;
import org.odpi.openmetadata.governanceservers.openlineage.server.OpenLineageInstanceHandler;
import org.odpi.openmetadata.governanceservers.openlineage.util.OpenLineageExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLineageRestServices {
    private static final Logger log = LoggerFactory.getLogger(OpenLineageRestServices.class);
    private final OpenLineageInstanceHandler instanceHandler = new OpenLineageInstanceHandler();
    private OpenLineageExceptionHandler openLineageExceptionHandler = new OpenLineageExceptionHandler();

    public LineageResponse lineage(String serverName, String userId, Scope scope, String guid, String displayNameMustContain, boolean includeProcesses) {
        LineageResponse response = new LineageResponse();
        String methodName = "OpenLineageRestServices.lineage";
        String debugMessage = "An exception occurred during a lineage HTTP request";
        try {
            OpenLineageHandler openLineageHandler = this.instanceHandler.getOpenLineageHandler(userId, serverName, "OpenLineageRestServices.lineage");
            response = openLineageHandler.lineage(scope, guid, displayNameMustContain, includeProcesses);
        }
        catch (InvalidParameterException e) {
            this.openLineageExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, e);
            log.debug("An exception occurred during a lineage HTTP request", (Throwable)e);
        }
        catch (PropertyServerException e) {
            this.openLineageExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, e);
            log.debug("An exception occurred during a lineage HTTP request", (Throwable)e);
        }
        catch (UserNotAuthorizedException e) {
            this.openLineageExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, e);
            log.debug("An exception occurred during a lineage HTTP request", (Throwable)e);
        }
        catch (OpenLineageException e) {
            this.openLineageExceptionHandler.captureOpenLineageException(response, e);
            log.debug("An exception occurred during a lineage HTTP request", (Throwable)e);
        }
        catch (Exception e) {
            this.openLineageExceptionHandler.captureThrowable((FFDCResponseBase)response, (Throwable)e, "OpenLineageRestServices.lineage");
            log.debug("An exception occurred during a lineage HTTP request", (Throwable)e);
        }
        return response;
    }
}

