/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.services;

import java.util.HashMap;
import java.util.HashSet;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageEvent;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageRelationshipEvent;
import org.odpi.openmetadata.governanceservers.openlineage.graph.LineageGraph;
import org.odpi.openmetadata.governanceservers.openlineage.scheduler.JobConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoringServices {
    private static final Logger log = LoggerFactory.getLogger(StoringServices.class);
    private LineageGraph lineageGraph;
    private JobConfiguration jobConfiguration;

    public StoringServices(LineageGraph graphStore, int jobIntervalInSeconds) {
        this.lineageGraph = graphStore;
        this.jobConfiguration = new JobConfiguration(graphStore, jobIntervalInSeconds);
    }

    public void addEntity(LineageEvent lineageEvent) {
        HashSet verticesToBeAdded = new HashSet();
        lineageEvent.getAssetContext().forEach((key, value) -> {
            if (value.size() > 1) {
                verticesToBeAdded.addAll(value);
            } else {
                verticesToBeAdded.add(value.stream().findFirst().get());
            }
        });
        this.lineageGraph.storeToGraph(verticesToBeAdded);
    }

    public void updateEntity(LineageEvent lineageEvent) {
        log.debug("Open Lineage Services is processing a UpdateEntity event which contains the following entity with guid : {}", (Object)lineageEvent.getLineageEntity().getGuid());
        this.lineageGraph.updateEntity(lineageEvent.getLineageEntity());
    }

    public void updateRelationship(LineageRelationshipEvent lineageRelationshipEvent) {
        log.debug("Open Lineage Services is processing a UpdateRelationshipEvent event which contains the following relantionhsip with guid: {}", (Object)lineageRelationshipEvent.getLineageRelationship().getGuid());
        this.lineageGraph.updateRelationship(lineageRelationshipEvent.getLineageRelationship());
    }

    public void updateClassification(LineageEvent lineageEvent) {
        log.debug("Open Lineage Services is processing an UpdateClassificationEvent event");
        this.lineageGraph.updateClassification(lineageEvent.getAssetContext());
    }

    public void deleteEntity(LineageEvent lineageEvent) {
        this.lineageGraph.deleteEntity(lineageEvent.getLineageEntity().getGuid(), (Object)lineageEvent.getLineageEntity().getVersion());
    }

    public void deleteRelationship(LineageRelationshipEvent lineageRelationshipEvent) {
        this.lineageGraph.deleteRelationship(lineageRelationshipEvent.getLineageRelationship().getGuid());
    }

    public void upsertRelationship(LineageRelationshipEvent lineageRelationshipEvent) {
        this.lineageGraph.upsertRelationship(lineageRelationshipEvent.getLineageRelationship());
    }

    public void deleteClassification(LineageEvent lineageEvent) {
        log.debug("Open Lineage Services is processing an UpdateClassificationEvent event");
        HashMap empty = new HashMap();
        this.lineageGraph.deleteClassification(lineageEvent.getLineageEntity().getGuid(), lineageEvent.getAssetContext() == null ? empty : lineageEvent.getAssetContext());
    }
}

