/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.scheduler;

import org.odpi.openmetadata.governanceservers.openlineage.graph.LineageGraph;
import org.odpi.openmetadata.governanceservers.openlineage.scheduler.LineageGraphJob;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JobConfiguration.class);
    private static Scheduler scheduler;
    private static LineageGraph lineageGraph;
    private static int jobInterval;
    private static JobDetail jobDetail;

    public JobConfiguration(LineageGraph lineageGraph, int jobInterval) {
        JobConfiguration.lineageGraph = lineageGraph;
        JobConfiguration.jobInterval = jobInterval;
        this.schedule();
    }

    public void schedule() {
        String methodName = "schedule";
        log.debug(" QuartzSchedulerApp main thread: {}", (Object)Thread.currentThread().getName());
        try {
            scheduler = new StdSchedulerFactory().getScheduler();
            scheduler.start();
        }
        catch (SchedulerException e) {
            log.error("{} could not run the job for LineageGraph", (Object)"schedule");
        }
        Trigger trigger = JobConfiguration.buildSimpleSchedulerTrigger();
        try {
            JobConfiguration.scheduleJob(trigger);
        }
        catch (Exception e) {
            log.error("The job did not start because of an error with message: {}", (Object)e.getMessage());
        }
    }

    public void stop() {
        try {
            if (scheduler != null) {
                scheduler.shutdown();
            }
        }
        catch (SchedulerException e) {
            log.error("Exception while attempting to shutdown the scheduler instance, the message is: {}", (Object)e.getMessage());
        }
    }

    private static void scheduleJob(Trigger trigger) throws Exception {
        if (lineageGraph != null) {
            jobDetail = JobBuilder.newJob(LineageGraphJob.class).withIdentity("LineageGraphJob", "group").build();
            jobDetail.getJobDataMap().put("openLineageGraphStore", (Object)lineageGraph);
            scheduler.scheduleJob(jobDetail, trigger);
        }
    }

    private static Trigger buildSimpleSchedulerTrigger() {
        return TriggerBuilder.newTrigger().withIdentity("LineageGraphJob", "group").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(jobInterval).repeatForever()).build();
    }
}

