/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.services;

import org.odpi.openmetadata.accessservices.assetlineage.event.LineageEntityEvent;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageRelationshipEvent;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageRelationshipsEvent;
import org.odpi.openmetadata.accessservices.assetlineage.event.ProcessLineageEvent;
import org.odpi.openmetadata.governanceservers.openlineage.graph.LineageGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoringServices {
    private static final Logger log = LoggerFactory.getLogger(StoringServices.class);
    private LineageGraph lineageGraph;

    public StoringServices(LineageGraph graphStore) {
        this.lineageGraph = graphStore;
    }

    public void addEntityContext(ProcessLineageEvent processLineageEvent) {
        this.lineageGraph.storeToGraph(processLineageEvent.getContext());
    }

    public void addEntityContext(LineageRelationshipsEvent lineageRelationshipsEvent) {
        this.lineageGraph.storeToGraph(lineageRelationshipsEvent.getRelationshipsContext().getRelationships());
    }

    public void updateEntity(LineageEntityEvent lineageEntityEvent) {
        log.debug("Open Lineage Services is processing a UpdateEntity event which contains the following entity with guid : {}", (Object)lineageEntityEvent.getLineageEntity().getGuid());
        this.lineageGraph.updateEntity(lineageEntityEvent.getLineageEntity());
    }

    public void updateRelationship(LineageRelationshipEvent lineageRelationshipEvent) {
        log.debug("Open Lineage Services is processing a UpdateRelationshipEvent event which contains the following relationship with guid: {}", (Object)lineageRelationshipEvent.getLineageRelationship().getGuid());
        this.lineageGraph.updateRelationship(lineageRelationshipEvent.getLineageRelationship());
    }

    public void updateClassification(LineageRelationshipsEvent lineageRelationshipsEvent) {
        log.debug("Open Lineage Services is processing an UpdateClassificationEvent event");
        this.lineageGraph.updateClassification(lineageRelationshipsEvent.getRelationshipsContext().getRelationships());
    }

    public void deleteEntity(LineageEntityEvent lineageEntityEvent) {
        this.lineageGraph.deleteEntity(lineageEntityEvent.getLineageEntity().getGuid(), (Object)lineageEntityEvent.getLineageEntity().getVersion());
    }

    public void deleteRelationship(LineageRelationshipEvent lineageRelationshipEvent) {
        this.lineageGraph.deleteRelationship(lineageRelationshipEvent.getLineageRelationship().getGuid());
    }

    public void upsertRelationship(LineageRelationshipEvent lineageRelationshipEvent) {
        this.lineageGraph.upsertRelationship(lineageRelationshipEvent.getLineageRelationship());
    }

    public void deleteClassification(LineageRelationshipsEvent lineageRelationshipsEvent) {
        log.debug("Open Lineage Services is processing an DeleteClassificationEvent event");
        this.lineageGraph.deleteClassification(lineageRelationshipsEvent.getRelationshipsContext().getRelationships());
    }
}

