/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetlineage.event.AssetLineageEventHeader;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageEntityEvent;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageRelationshipEvent;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageRelationshipsEvent;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.openlineage.auditlog.OpenLineageServerAuditCode;
import org.odpi.openmetadata.governanceservers.openlineage.handlers.OpenLineageAssetContextHandler;
import org.odpi.openmetadata.governanceservers.openlineage.services.StoringServices;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLineageInTopicListener
implements OpenMetadataTopicListener {
    private static final Logger log = LoggerFactory.getLogger(OpenLineageInTopicListener.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final OMRSAuditLog auditLog;
    private final StoringServices storingServices;
    private final OpenLineageAssetContextHandler assetContextHandler;

    public OpenLineageInTopicListener(StoringServices storingServices, OpenLineageAssetContextHandler assetContextHandler, OMRSAuditLog auditLog) {
        this.storingServices = storingServices;
        this.assetContextHandler = assetContextHandler;
        this.auditLog = auditLog;
    }

    public void processEvent(String assetLineageEvent) {
        try {
            log.debug("Started processing OpenLineageEvent {}", (Object)assetLineageEvent);
            if (!assetLineageEvent.isEmpty()) {
                this.processEventBasedOnType(assetLineageEvent);
            }
        }
        catch (JsonProcessingException e) {
            this.logException(assetLineageEvent, (Exception)((Object)e));
        }
        catch (Throwable e) {
            log.error("Exception processing the in topic event", e);
            OpenLineageServerAuditCode auditCode = OpenLineageServerAuditCode.PROCESS_EVENT_EXCEPTION;
            this.auditLog.logException("processEvent", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(assetLineageEvent, e.getMessage()), e.getMessage(), auditCode.getSystemAction(), auditCode.getUserAction(), e);
        }
    }

    private void processEventBasedOnType(String assetLineageEvent) throws JsonProcessingException {
        AssetLineageEventHeader assetLineageEventHeader = (AssetLineageEventHeader)OBJECT_MAPPER.readValue(assetLineageEvent, AssetLineageEventHeader.class);
        if (assetLineageEventHeader == null) {
            return;
        }
        switch (assetLineageEventHeader.getAssetLineageEventType()) {
            case CLASSIFICATION_CONTEXT_EVENT: 
            case SEMANTIC_ASSIGNMENTS_EVENT: 
            case TERM_CATEGORIZATIONS_EVENT: 
            case TERM_ANCHORS_EVENT: 
            case CATEGORY_ANCHORS_EVENT: 
            case LINEAGE_MAPPINGS_EVENT: 
            case PROCESS_CONTEXT_EVENT: {
                LineageRelationshipsEvent lineageRelationshipsEvent = (LineageRelationshipsEvent)OBJECT_MAPPER.readValue(assetLineageEvent, LineageRelationshipsEvent.class);
                this.storingServices.addEntityContext(lineageRelationshipsEvent);
                break;
            }
            case COLUMN_CONTEXT_EVENT: {
                LineageRelationshipsEvent lineageRelationshipsEvent = (LineageRelationshipsEvent)OBJECT_MAPPER.readValue(assetLineageEvent, LineageRelationshipsEvent.class);
                this.requestAssetContext(lineageRelationshipsEvent);
                this.storingServices.addEntityContext(lineageRelationshipsEvent);
                break;
            }
            case ASSET_CONTEXT_EVENT: {
                LineageRelationshipsEvent lineageRelationshipsEvent = (LineageRelationshipsEvent)OBJECT_MAPPER.readValue(assetLineageEvent, LineageRelationshipsEvent.class);
                this.storeAssetContext(lineageRelationshipsEvent);
                break;
            }
            case NEW_RELATIONSHIP_EVENT: {
                LineageRelationshipEvent lineageRelationshipEvent = (LineageRelationshipEvent)OBJECT_MAPPER.readValue(assetLineageEvent, LineageRelationshipEvent.class);
                this.storingServices.upsertRelationship(lineageRelationshipEvent);
                break;
            }
            case UPDATE_ENTITY_EVENT: {
                LineageEntityEvent lineageEntityEvent = (LineageEntityEvent)OBJECT_MAPPER.readValue(assetLineageEvent, LineageEntityEvent.class);
                this.storingServices.updateEntity(lineageEntityEvent);
                break;
            }
            case UPDATE_RELATIONSHIP_EVENT: {
                LineageRelationshipEvent lineageRelationshipEvent = (LineageRelationshipEvent)OBJECT_MAPPER.readValue(assetLineageEvent, LineageRelationshipEvent.class);
                this.storingServices.updateRelationship(lineageRelationshipEvent);
                break;
            }
            case RECLASSIFIED_ENTITY_EVENT: {
                LineageRelationshipsEvent lineageRelationshipsEvent = (LineageRelationshipsEvent)OBJECT_MAPPER.readValue(assetLineageEvent, LineageRelationshipsEvent.class);
                this.storingServices.updateClassification(lineageRelationshipsEvent);
                break;
            }
            case DELETE_ENTITY_EVENT: {
                LineageEntityEvent lineageEntityEvent = (LineageEntityEvent)OBJECT_MAPPER.readValue(assetLineageEvent, LineageEntityEvent.class);
                this.storingServices.deleteEntity(lineageEntityEvent);
                break;
            }
            case DELETE_RELATIONSHIP_EVENT: {
                LineageRelationshipEvent lineageRelationshipEvent = (LineageRelationshipEvent)OBJECT_MAPPER.readValue(assetLineageEvent, LineageRelationshipEvent.class);
                this.storingServices.deleteRelationship(lineageRelationshipEvent);
                break;
            }
            case DECLASSIFIED_ENTITY_EVENT: {
                LineageRelationshipsEvent lineageRelationshipsEvent = (LineageRelationshipsEvent)OBJECT_MAPPER.readValue(assetLineageEvent, LineageRelationshipsEvent.class);
                this.storingServices.deleteClassification(lineageRelationshipsEvent);
                break;
            }
        }
    }

    private void storeAssetContext(LineageRelationshipsEvent lineageRelationshipsEvent) {
        Set relationships = lineageRelationshipsEvent.getRelationshipsContext().getRelationships();
        if (!CollectionUtils.isEmpty((Collection)relationships)) {
            this.storingServices.addEntityContext(relationships);
            String entityGuid = lineageRelationshipsEvent.getRelationshipsContext().getEntityGuid();
            this.auditLog.logMessage("storing Asset Context information for entity", OpenLineageServerAuditCode.ASSET_CONTEXT_INFO.getMessageDefinition(entityGuid));
        }
    }

    private void requestAssetContext(LineageRelationshipsEvent lineageRelationshipsEvent) {
        LineageEntity entity;
        String guid;
        Optional<LineageEntity> optionalEntity = this.assetContextHandler.getAssetLineageEntity(lineageRelationshipsEvent);
        if (optionalEntity.isPresent() && !this.storingServices.isEntityInGraph(guid = (entity = optionalEntity.get()).getGuid())) {
            try {
                List<String> guids = this.assetContextHandler.getAssetContextForEntity(guid, entity.getTypeDefName());
                this.auditLog.logMessage("requested the entity's Asset Context for entity", OpenLineageServerAuditCode.ASSET_CONTEXT_REQUEST.getMessageDefinition(guid, guids.toString()));
            }
            catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
                OpenLineageServerAuditCode errorCode = OpenLineageServerAuditCode.ASSET_CONTEXT_EXCEPTION;
                this.auditLog.logException("retrieving Asset Context exception", errorCode.getLogMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, errorCode.getFormattedLogMessage(guid, e.getMessage()), e.getMessage(), errorCode.getSystemAction(), errorCode.getUserAction(), e);
            }
        }
    }

    private void logException(String assetLineageEvent, Exception e) {
        log.debug("Exception parsing event from AssetLineage out Topic", (Throwable)e);
        OpenLineageServerAuditCode errorCode = OpenLineageServerAuditCode.PROCESS_EVENT_EXCEPTION;
        this.auditLog.logException("parsing Asset Lineage event exception", errorCode.getLogMessageId(), OMRSAuditLogRecordSeverity.EXCEPTION, errorCode.getFormattedLogMessage(assetLineageEvent, e.getMessage()), e.getMessage(), errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)e);
    }
}

