/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.scheduler;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.odpi.openmetadata.accessservices.assetlineage.AssetLineage;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.openlineage.graph.LineageGraph;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public class AssetLineageUpdateJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageUpdateJob.class);
    private static final String GLOSSARY_TERM = "GlossaryTerm";
    private static final String RUN_ASSET_LINEAGE_UPDATE_JOB = "Run AssetLineageUpdateJob task at {} GMT";
    private static final String RUNNING_FAILURE = "AssetLineageUpdateJob task execution at {} GMT failed because of the following exception {}";
    private static final String ASSET_LINEAGE_CONFIG_DEFAULT_VALUE_ERROR = "AssetLineageUpdateJob default value from config was defined as '{}' and it should have an ISO-8601 format such as '{}'. The job will shutdown and won't start again. Restart OLS with new value.";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LocalDateTime localDateTime = LocalDateTime.now(ZoneId.of("GMT"));
        log.debug(RUN_ASSET_LINEAGE_UPDATE_JOB, (Object)localDateTime);
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        this.performTask(localDateTime, dataMap);
    }

    private void performTask(LocalDateTime localDateTime, JobDataMap dataMap) throws JobExecutionException {
        AssetLineage assetLineageClient = (AssetLineage)dataMap.get((Object)"assetLineageClient");
        String localServerName = (String)dataMap.get((Object)"assetLineageServerName");
        String localServerUserId = (String)dataMap.get((Object)"localServerUserId");
        try {
            LineageGraph lineageGraph = (LineageGraph)dataMap.get((Object)"openLineageGraphStore");
            String configAssetLineageDefaultTime = (String)dataMap.get((Object)"configAssetLineageLastUpdateTime");
            Optional<LocalDateTime> assetLineageLastUpdateTime = this.getAssetLineageLastUpdateTime(configAssetLineageDefaultTime, lineageGraph, localDateTime);
            assetLineageClient.publishEntities(localServerName, localServerUserId, GLOSSARY_TERM, assetLineageLastUpdateTime);
            lineageGraph.saveAssetLineageUpdateTime(localDateTime);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.warn(RUNNING_FAILURE, (Object)localDateTime, (Object)e.getMessage());
        }
    }

    private Optional<LocalDateTime> getAssetLineageLastUpdateTime(String configAssetLineageDefaultTime, LineageGraph lineageGraph, LocalDateTime localDateTime) throws JobExecutionException {
        Optional<LocalDateTime> assetLineageLastUpdateTime = lineageGraph.getAssetLineageUpdateTime();
        if (!assetLineageLastUpdateTime.isPresent() && StringUtils.isNotEmpty((CharSequence)configAssetLineageDefaultTime)) {
            try {
                assetLineageLastUpdateTime = Optional.of(LocalDateTime.parse(configAssetLineageDefaultTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            }
            catch (DateTimeParseException exception) {
                log.error(ASSET_LINEAGE_CONFIG_DEFAULT_VALUE_ERROR, (Object)configAssetLineageDefaultTime, (Object)localDateTime);
                JobExecutionException jobExecutionException = new JobExecutionException((Throwable)exception);
                jobExecutionException.setUnscheduleAllTriggers(true);
                throw jobExecutionException;
            }
        }
        return assetLineageLastUpdateTime;
    }
}

