/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.scheduler;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.odpi.openmetadata.accessservices.assetlineage.AssetLineage;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.openlineage.graph.LineageGraph;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public class AssetLineageUpdateJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(AssetLineageUpdateJob.class);
    private static final String GLOSSARY_TERM = "GlossaryTerm";
    private static final String RUN_ASSET_LINEAGE_UPDATE_JOB = "Polling AssetLineage OMAS for changes as of time {} {}";
    private static final String RUNNING_FAILURE = "AssetLineageUpdateJob task execution at {} {} failed because of the following exception {}";
    private static final String ASSET_LINEAGE_CONFIG_DEFAULT_VALUE_ERROR = "AssetLineageUpdateJob default value was defined as '{}' and it should have an ISO-8601 format such as yyyy-MM-ddTHH:mm:ss. The job will shutdown and won't start again. Correct the default value and restart the server instance.";
    private static final String LAST_UPDATE_TIME_UNKNOWN = "Last update time unknown";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Date now = Calendar.getInstance().getTime();
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        this.performTask(now, dataMap);
    }

    private void performTask(Date date, JobDataMap dataMap) throws JobExecutionException {
        AssetLineage assetLineageClient = (AssetLineage)dataMap.get((Object)"assetLineageClient");
        String localServerName = (String)dataMap.get((Object)"assetLineageServerName");
        String localServerUserId = (String)dataMap.get((Object)"localServerUserId");
        try {
            LineageGraph lineageGraph = (LineageGraph)dataMap.get((Object)"openLineageGraphStore");
            String configAssetLineageDefaultTime = (String)dataMap.get((Object)"configAssetLineageLastUpdateTime");
            Optional storedAssetLineageUpdateTime = lineageGraph.getAssetLineageUpdateTime();
            Optional<Date> assetLineageLastUpdateTime = this.getAssetLineageLastUpdateTime(configAssetLineageDefaultTime, storedAssetLineageUpdateTime);
            assetLineageLastUpdateTime.ifPresent(lastUpdateTime -> log.debug(RUN_ASSET_LINEAGE_UPDATE_JOB, lastUpdateTime, (Object)ZoneId.systemDefault().getId()));
            assetLineageClient.publishEntities(localServerName, localServerUserId, GLOSSARY_TERM, assetLineageLastUpdateTime);
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.warn(RUNNING_FAILURE, new Object[]{date, ZoneId.systemDefault(), e.getMessage()});
        }
    }

    private Optional<Date> getAssetLineageLastUpdateTime(String configAssetLineageDefaultTime, Optional<Long> storedUpdateTime) throws JobExecutionException {
        if (storedUpdateTime.isPresent()) {
            return Optional.of(new Date(storedUpdateTime.get()));
        }
        if (StringUtils.isNotEmpty((CharSequence)configAssetLineageDefaultTime)) {
            try {
                Instant configAssetLineageAsInstant = LocalDateTime.parse(configAssetLineageDefaultTime, DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneId.systemDefault()).toInstant();
                return Optional.of(Date.from(configAssetLineageAsInstant));
            }
            catch (Exception exception) {
                log.error(ASSET_LINEAGE_CONFIG_DEFAULT_VALUE_ERROR, (Object)configAssetLineageDefaultTime);
                JobExecutionException jobExecutionException = new JobExecutionException((Throwable)exception);
                jobExecutionException.setUnscheduleAllTriggers(true);
                throw jobExecutionException;
            }
        }
        log.debug(LAST_UPDATE_TIME_UNKNOWN);
        return Optional.empty();
    }
}

