/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.server;

import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.handlers.OpenLineageHandler;
import org.odpi.openmetadata.governanceservers.openlineage.model.NodeNamesSearchCriteria;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.requests.LineageSearchRequest;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageNodeNamesResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageSearchResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageTypesResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageVertexResponse;
import org.odpi.openmetadata.governanceservers.openlineage.server.OpenLineageInstanceHandler;
import org.odpi.openmetadata.governanceservers.openlineage.util.OpenLineageExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLineageRestServices {
    private static final Logger log = LoggerFactory.getLogger(OpenLineageRestServices.class);
    private final OpenLineageInstanceHandler instanceHandler = new OpenLineageInstanceHandler();
    private OpenLineageExceptionHandler openLineageExceptionHandler = new OpenLineageExceptionHandler();

    public LineageResponse lineage(String serverName, String userId, Scope scope, String guid, boolean includeProcesses) {
        LineageResponse response = new LineageResponse();
        String methodName = "OpenLineageRestServices.lineage";
        String debugMessage = "An exception occurred during a lineage HTTP request";
        try {
            OpenLineageHandler openLineageHandler = this.instanceHandler.getOpenLineageHandler(userId, serverName, "OpenLineageRestServices.lineage");
            response = openLineageHandler.lineage(scope, guid, includeProcesses);
        }
        catch (InvalidParameterException e) {
            this.openLineageExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
            log.debug("An exception occurred during a lineage HTTP request", (Throwable)e);
        }
        catch (PropertyServerException e) {
            this.openLineageExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
            log.debug("An exception occurred during a lineage HTTP request", (Throwable)e);
        }
        catch (UserNotAuthorizedException e) {
            this.openLineageExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
            log.debug("An exception occurred during a lineage HTTP request", (Throwable)e);
        }
        catch (OpenLineageException e) {
            this.openLineageExceptionHandler.captureOpenLineageException((FFDCResponseBase)response, e);
            log.debug("An exception occurred during a lineage HTTP request", (Throwable)e);
        }
        catch (Exception e) {
            this.openLineageExceptionHandler.captureExceptions((FFDCResponse)response, e, "OpenLineageRestServices.lineage");
            log.debug("An exception occurred during a lineage HTTP request", (Throwable)e);
        }
        return response;
    }

    public LineageVertexResponse getEntityDetails(String serverName, String userId, String guid) {
        LineageVertexResponse response = new LineageVertexResponse();
        String methodName = "OpenLineageRestServices.getEntityDetails";
        String debugMessage = "An exception occurred during a getEntityDetails HTTP request";
        try {
            OpenLineageHandler openLineageHandler = this.instanceHandler.getOpenLineageHandler(userId, serverName, "OpenLineageRestServices.getEntityDetails");
            response = openLineageHandler.getEntityDetails(guid);
        }
        catch (InvalidParameterException e) {
            this.openLineageExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
            log.debug("An exception occurred during a getEntityDetails HTTP request", (Throwable)e);
        }
        catch (PropertyServerException e) {
            this.openLineageExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
            log.debug("An exception occurred during a getEntityDetails HTTP request", (Throwable)e);
        }
        catch (UserNotAuthorizedException e) {
            this.openLineageExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
            log.debug("An exception occurred during a getEntityDetails HTTP request", (Throwable)e);
        }
        catch (OpenLineageException e) {
            this.openLineageExceptionHandler.captureOpenLineageException((FFDCResponseBase)response, e);
            log.debug("An exception occurred during a getEntityDetails HTTP request", (Throwable)e);
        }
        catch (Exception e) {
            this.openLineageExceptionHandler.captureExceptions((FFDCResponse)response, e, "OpenLineageRestServices.getEntityDetails");
            log.debug("An exception occurred during a getEntityDetails HTTP request", (Throwable)e);
        }
        return response;
    }

    public LineageTypesResponse getTypes(String serverName, String userId) {
        LineageTypesResponse response = new LineageTypesResponse();
        String methodName = "OpenLineageRestServices.getTypes";
        String debugMessage = "An exception occurred during a getTypes HTTP request";
        try {
            OpenLineageHandler openLineageHandler = this.instanceHandler.getOpenLineageHandler(userId, serverName, "OpenLineageRestServices.getTypes");
            response = openLineageHandler.getTypes();
        }
        catch (InvalidParameterException e) {
            this.openLineageExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
            log.debug("An exception occurred during a getTypes HTTP request", (Throwable)e);
        }
        catch (PropertyServerException e) {
            this.openLineageExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
            log.debug("An exception occurred during a getTypes HTTP request", (Throwable)e);
        }
        catch (UserNotAuthorizedException e) {
            this.openLineageExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
            log.debug("An exception occurred during a getTypes HTTP request", (Throwable)e);
        }
        catch (OpenLineageException e) {
            this.openLineageExceptionHandler.captureOpenLineageException((FFDCResponseBase)response, e);
            log.debug("An exception occurred during a getTypes HTTP request", (Throwable)e);
        }
        catch (Exception e) {
            this.openLineageExceptionHandler.captureExceptions((FFDCResponse)response, e, "OpenLineageRestServices.getTypes");
            log.debug("An exception occurred during a getTypes HTTP request", (Throwable)e);
        }
        return response;
    }

    public LineageNodeNamesResponse getNodes(String serverName, String userId, NodeNamesSearchCriteria searchCriteria) {
        LineageNodeNamesResponse response = new LineageNodeNamesResponse();
        String methodName = "OpenLineageRestServices.getNodes";
        String debugMessage = "An exception occurred during a getNodes HTTP request";
        try {
            OpenLineageHandler openLineageHandler = this.instanceHandler.getOpenLineageHandler(userId, serverName, "OpenLineageRestServices.getNodes");
            response = openLineageHandler.getNodes(searchCriteria);
        }
        catch (InvalidParameterException e) {
            this.openLineageExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
            log.debug("An exception occurred during a getNodes HTTP request", (Throwable)e);
        }
        catch (PropertyServerException e) {
            this.openLineageExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
            log.debug("An exception occurred during a getNodes HTTP request", (Throwable)e);
        }
        catch (UserNotAuthorizedException e) {
            this.openLineageExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
            log.debug("An exception occurred during a getNodes HTTP request", (Throwable)e);
        }
        catch (OpenLineageException e) {
            this.openLineageExceptionHandler.captureOpenLineageException((FFDCResponseBase)response, e);
            log.debug("An exception occurred during a getNodes HTTP request", (Throwable)e);
        }
        catch (Exception e) {
            this.openLineageExceptionHandler.captureExceptions((FFDCResponse)response, e, "OpenLineageRestServices.getNodes");
            log.debug("An exception occurred during a getNodes HTTP request", (Throwable)e);
        }
        return response;
    }

    public LineageSearchResponse search(String serverName, String userId, LineageSearchRequest lineageSearchRequest) {
        LineageSearchResponse response = new LineageSearchResponse();
        String methodName = "OpenLineageRestServices.search";
        String debugMessage = "An exception occurred during a getEntityDetails HTTP request";
        try {
            OpenLineageHandler openLineageHandler = this.instanceHandler.getOpenLineageHandler(userId, serverName, "OpenLineageRestServices.search");
            response = openLineageHandler.search(lineageSearchRequest);
        }
        catch (InvalidParameterException e) {
            this.openLineageExceptionHandler.captureInvalidParameterException((FFDCResponse)response, e);
            log.debug("An exception occurred during a getEntityDetails HTTP request", (Throwable)e);
        }
        catch (PropertyServerException e) {
            this.openLineageExceptionHandler.capturePropertyServerException((FFDCResponse)response, e);
            log.debug("An exception occurred during a getEntityDetails HTTP request", (Throwable)e);
        }
        catch (UserNotAuthorizedException e) {
            this.openLineageExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, e);
            log.debug("An exception occurred during a getEntityDetails HTTP request", (Throwable)e);
        }
        catch (OpenLineageException e) {
            this.openLineageExceptionHandler.captureOpenLineageException((FFDCResponseBase)response, e);
            log.debug("An exception occurred during a getEntityDetails HTTP request", (Throwable)e);
        }
        catch (Exception e) {
            this.openLineageExceptionHandler.captureExceptions((FFDCResponse)response, e, "OpenLineageRestServices.search");
            log.debug("An exception occurred during a getEntityDetails HTTP request", (Throwable)e);
        }
        return response;
    }
}

