/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.server;

import org.odpi.openmetadata.commonservices.multitenant.OMAGServerServiceInstance;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageServerErrorCode;
import org.odpi.openmetadata.governanceservers.openlineage.handlers.OpenLineageHandler;

public class OpenLineageServerInstance
extends OMAGServerServiceInstance {
    private OpenLineageHandler openLineageHandler;

    public OpenLineageServerInstance(String serverName, String serviceName, int maxPageSize, OpenLineageHandler openLineageHandler) {
        super(serverName, serviceName, maxPageSize);
        this.openLineageHandler = openLineageHandler;
    }

    OpenLineageHandler getOpenLineageHandler() throws OpenLineageException {
        String methodName = "getOpenLineageHandler";
        if (this.openLineageHandler == null) {
            OpenLineageServerErrorCode errorCode = OpenLineageServerErrorCode.OPEN_LINEAGE_HANDLER_NOT_INSTANTIATED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.serverName});
            throw new OpenLineageException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getOpenLineageHandler", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return this.openLineageHandler;
    }
}

