/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.scheduler;

import org.odpi.openmetadata.governanceservers.openlineage.OpenLineageGraphConnector;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JobConfiguration.class);
    private static final String SCHEDULER_STARTING = "QuartzSchedulerApp main thread: {}";
    private static final String SCHEDULER_RUNNING_ERROR = "{} could not start the scheduler";
    private static final String JOB_RUNNING_ERROR = "The job did not start because of an error with message: {}";
    private static final String SCHEDULER_SHUTDOWN_ERROR = "Exception while attempting to shutdown the scheduler instance, the message is: {}";
    private final OpenLineageGraphConnector openLineageGraphConnector;
    private final int jobInterval;
    private final String jobName;
    private final Class<? extends Job> jobClass;
    private Scheduler scheduler;
    final JobDetail jobDetail;

    public JobConfiguration(OpenLineageGraphConnector openLineageGraphConnector, String jobName, Class<? extends Job> jobClass, int jobInterval) {
        this.openLineageGraphConnector = openLineageGraphConnector;
        this.jobName = jobName;
        this.jobClass = jobClass;
        this.jobInterval = jobInterval;
        this.jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, "group").build();
    }

    public void schedule() {
        String methodName = "schedule";
        log.debug(SCHEDULER_STARTING, (Object)Thread.currentThread().getName());
        try {
            this.scheduler = new StdSchedulerFactory().getScheduler();
            this.scheduler.startDelayed(10);
        }
        catch (SchedulerException e) {
            log.error(SCHEDULER_RUNNING_ERROR, (Object)"schedule");
        }
        Trigger trigger = this.buildSimpleSchedulerTrigger();
        try {
            this.scheduleJob(trigger);
        }
        catch (Exception e) {
            log.error(JOB_RUNNING_ERROR, (Object)e.getMessage());
        }
    }

    public void stop() {
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
        }
        catch (SchedulerException e) {
            log.error(SCHEDULER_SHUTDOWN_ERROR, (Object)e.getMessage());
        }
    }

    private void scheduleJob(Trigger trigger) throws SchedulerException {
        if (this.openLineageGraphConnector != null) {
            this.jobDetail.getJobDataMap().put("openLineageGraphStore", (Object)this.openLineageGraphConnector);
            this.scheduler.scheduleJob(this.jobDetail, trigger);
        }
    }

    private Trigger buildSimpleSchedulerTrigger() {
        return TriggerBuilder.newTrigger().withIdentity(this.jobName, "group").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(this.jobInterval).repeatForever()).build();
    }
}

