/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.odpi.openmetadata.accessservices.assetlineage.AssetLineage;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageRelationshipsEvent;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class OpenLineageAssetContextHandler {
    private static final String DATA_FILE = "DataFile";
    private static final String AVRO_FILE = "AvroFile";
    private static final String CSV_FILE = "CSVFile";
    private static final String JSON_FILE = "JSONFile";
    private static final String KEYSTORE_FILE = "KeystoreFile";
    private static final String LOG_FILE = "LogFile";
    private static final String MEDIA_FILE = "MediaFile";
    private static final String DOCUMENT = "Document";
    private static final List<String> DATA_FILE_TYPES = Arrays.asList("DataFile", "AvroFile", "CSVFile", "JSONFile", "KeystoreFile", "LogFile", "MediaFile", "Document");
    private static final String RELATIONAL_TABLE = "RelationalTable";
    private static final String NESTED_SCHEMA_ATTRIBUTE = "NestedSchemaAttribute";
    private static final String ASSET_SCHEMA_TYPE = "AssetSchemaType";
    private final String localServerUserId;
    private final AssetLineage assetLineageClient;

    public OpenLineageAssetContextHandler(String localServerUserId, AssetLineage assetLineageClient) {
        this.localServerUserId = localServerUserId;
        this.assetLineageClient = assetLineageClient;
    }

    public List<String> getAssetContextForEntity(String guid, String typeDefName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.assetLineageClient.publishAssetContext(this.localServerUserId, guid, typeDefName);
    }

    public Optional<LineageEntity> getAssetLineageEntity(LineageRelationshipsEvent lineageRelationshipsEvent) {
        Set relationships = lineageRelationshipsEvent.getRelationshipsContext().getRelationships();
        Optional<LineageEntity> entity = this.getEntityByEntityTypeFromRelationships(relationships, NESTED_SCHEMA_ATTRIBUTE, Collections.singletonList(RELATIONAL_TABLE));
        if (!entity.isPresent()) {
            entity = this.getEntityByEntityTypeFromRelationships(relationships, ASSET_SCHEMA_TYPE, DATA_FILE_TYPES);
        }
        return entity;
    }

    private Optional<LineageEntity> getEntityByEntityTypeFromRelationships(Set<GraphContext> relationships, String relationshipType, List<String> entityTypes) {
        return relationships.stream().filter(relationship -> relationshipType.equals(relationship.getRelationshipType())).map(relationship -> this.getEntityByEntityType(entityTypes, (GraphContext)relationship)).findFirst();
    }

    private LineageEntity getEntityByEntityType(List<String> entityTypes, GraphContext relationship) {
        return entityTypes.contains(relationship.getToVertex().getTypeDefName()) ? relationship.getToVertex() : relationship.getFromVertex();
    }
}

