/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.server.spring;

import java.beans.PropertyEditor;
import org.odpi.openmetadata.governanceservers.openlineage.converters.ScopeEnumConverter;
import org.odpi.openmetadata.governanceservers.openlineage.converters.ViewEnumConverter;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.model.View;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.VoidResponse;
import org.odpi.openmetadata.governanceservers.openlineage.server.OpenLineageRestServices;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/open-lineage/users/{userId}"})
public class OpenLineageResource {
    private final OpenLineageRestServices restAPI = new OpenLineageRestServices();

    @GetMapping(path={"/lineage/sources/{graph}/scopes/{scope}/views/{view}/entities/{guid}"}, produces={"application/json"})
    public LineageResponse lineage(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="graph") String graph, @PathVariable(value="scope") Scope scope, @PathVariable(value="view") View view, @PathVariable(value="guid") String guid) {
        return this.restAPI.lineage(serverName, userId, graph, scope, view, guid);
    }

    @GetMapping(path={"/dump/sources/{graph}"})
    public VoidResponse dumpGraph(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @PathVariable(value="graph") String graph) {
        return this.restAPI.dumpGraph(serverName, userId, graph);
    }

    @GetMapping(path={"/export/sources/{graph}"}, produces={"application/json"})
    public String exportGraph(@PathVariable(value="userId") String userId, @PathVariable(value="serverName") String serverName, @PathVariable(value="graph") String graph) {
        return this.restAPI.exportGraph(serverName, userId, graph);
    }

    @InitBinder
    public void initBinder(WebDataBinder webdataBinder) {
        webdataBinder.registerCustomEditor(View.class, (PropertyEditor)new ViewEnumConverter());
        webdataBinder.registerCustomEditor(Scope.class, (PropertyEditor)new ScopeEnumConverter());
    }
}

