/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.governanceservers.openlineage.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageQueryParameters;
import org.odpi.openmetadata.governanceservers.openlineage.model.NodeNamesSearchCriteria;
import org.odpi.openmetadata.governanceservers.openlineage.requests.ElementHierarchyRequest;
import org.odpi.openmetadata.governanceservers.openlineage.requests.LineageSearchRequest;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageNodeNamesResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageSearchResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageTypesResponse;
import org.odpi.openmetadata.governanceservers.openlineage.responses.LineageVertexResponse;
import org.odpi.openmetadata.governanceservers.openlineage.server.OpenLineageRestServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/open-lineage/users/{userId}"})
@Tag(name="Open Lineage Services", description="The Open Lineage Services provides a historic reporting warehouse for lineage. It listens to events that are sent out by the Asset Lineage OMAS, and stores lineage data in a database. ", externalDocs=@ExternalDocumentation(description="Open Lineage Services", url="https://egeria-project.org/services/open-lineage-services/"))
public class OpenLineageResource {
    private final OpenLineageRestServices restAPI = new OpenLineageRestServices();

    @PostMapping(path={"/lineage/entities/{guid}"}, produces={"application/json"})
    public LineageResponse lineage(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="guid") String guid, @RequestBody LineageQueryParameters params) {
        return this.restAPI.lineage(serverName, userId, params.getScope(), guid, params.isIncludeProcesses());
    }

    @GetMapping(path={"/lineage/entities/{guid}/details"}, produces={"application/json"})
    public LineageVertexResponse getEntityDetails(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="guid") String guid) {
        return this.restAPI.getEntityDetails(serverName, userId, guid);
    }

    @GetMapping(path={"/lineage/types"}, produces={"application/json"})
    public LineageTypesResponse getTypes(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId) {
        return this.restAPI.getTypes(serverName, userId);
    }

    @GetMapping(path={"/lineage/nodes"}, produces={"application/json"})
    public LineageNodeNamesResponse getNodes(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestParam(value="type") String type, @RequestParam(value="name") String searchValue, @RequestParam(value="limit") int limit) {
        return this.restAPI.getNodes(serverName, userId, new NodeNamesSearchCriteria(type, searchValue, limit));
    }

    @PostMapping(path={"lineage/search"}, produces={"application/json"})
    public LineageSearchResponse getSearchResults(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestBody LineageSearchRequest lineageSearchRequest) {
        return this.restAPI.search(serverName, userId, lineageSearchRequest);
    }

    @PostMapping(path={"elements/hierarchy"}, produces={"application/json"})
    public LineageResponse getElementHierarchy(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestBody ElementHierarchyRequest elementHierarchyRequest) {
        return this.restAPI.getElementHierarchy(serverName, userId, elementHierarchyRequest);
    }
}

