/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveStoreConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedOpenMetadataArchiveStoreConnector
extends OpenMetadataArchiveStoreConnector {
    private static final String defaultFilename = "open.metadata.archive";
    private String archiveStoreName = null;
    private static final Logger log = LoggerFactory.getLogger(FileBasedOpenMetadataArchiveStoreConnector.class);

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.archiveStoreName = endpoint.getAddress();
        }
        if (this.archiveStoreName == null) {
            this.archiveStoreName = defaultFilename;
        }
    }

    public OpenMetadataArchive getArchiveContents() {
        OpenMetadataArchive newOpenMetadataArchive;
        File archiveStoreFile = new File(this.archiveStoreName);
        try {
            log.debug("Retrieving server configuration properties");
            String configStoreFileContents = FileUtils.readFileToString((File)archiveStoreFile, (String)"UTF-8");
            ObjectMapper objectMapper = new ObjectMapper();
            newOpenMetadataArchive = (OpenMetadataArchive)objectMapper.readValue(configStoreFileContents, OpenMetadataArchive.class);
        }
        catch (IOException ioException) {
            log.debug("New server config Store", (Throwable)ioException);
            newOpenMetadataArchive = new OpenMetadataArchive();
        }
        return newOpenMetadataArchive;
    }

    public void setArchiveContents(OpenMetadataArchive archiveContents) {
        File archiveStoreFile = new File(this.archiveStoreName);
        try {
            log.debug("Writing open metadata archive store properties: " + archiveContents);
            if (archiveContents == null) {
                archiveStoreFile.delete();
            } else {
                ObjectMapper objectMapper = new ObjectMapper();
                String archiveStoreFileContents = objectMapper.writeValueAsString((Object)archiveContents);
                FileUtils.writeStringToFile((File)archiveStoreFile, (String)archiveStoreFileContents, (boolean)false);
            }
        }
        catch (IOException ioException) {
            log.debug("Unusable Server config Store :(", (Throwable)ioException);
        }
    }

    public void start() throws ConnectorCheckedException {
        super.start();
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        log.debug("Closing Config Store.");
    }
}

