/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file.ffdc.FileBasedOpenMetadataArchiveStoreConnectorAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveStoreConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedOpenMetadataArchiveStoreConnector
extends OpenMetadataArchiveStoreConnector {
    private static final String defaultFilename = "open.metadata.archive";
    private String archiveStoreName = null;
    private static final Logger log = LoggerFactory.getLogger(FileBasedOpenMetadataArchiveStoreConnector.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writer();
    private static final ObjectReader OBJECT_READER = OBJECT_MAPPER.reader();

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.archiveStoreName = endpoint.getAddress();
        }
        if (this.archiveStoreName == null) {
            this.archiveStoreName = defaultFilename;
        }
    }

    public OpenMetadataArchive getArchiveContents() {
        OpenMetadataArchive newOpenMetadataArchive;
        File archiveStoreFile = new File(this.archiveStoreName);
        try {
            log.debug("Retrieving open metadata archive from file");
            if (this.auditLog != null) {
                String actionDescription = "Opening open metadata archive";
                this.auditLog.logMessage("Opening open metadata archive", FileBasedOpenMetadataArchiveStoreConnectorAuditCode.OPENING_FILE.getMessageDefinition(this.archiveStoreName));
            }
            String configStoreFileContents = FileUtils.readFileToString((File)archiveStoreFile, (String)"UTF-8");
            newOpenMetadataArchive = (OpenMetadataArchive)OBJECT_READER.readValue(configStoreFileContents, OpenMetadataArchive.class);
        }
        catch (IOException ioException) {
            if (this.auditLog != null) {
                String actionDescription = "Unable to open file";
                this.auditLog.logException("Unable to open file", FileBasedOpenMetadataArchiveStoreConnectorAuditCode.BAD_FILE.getMessageDefinition(this.archiveStoreName, ioException.getClass().getName(), ioException.getMessage()), (Throwable)ioException);
            }
            log.debug("Create empty archive", (Throwable)ioException);
            newOpenMetadataArchive = new OpenMetadataArchive();
        }
        return newOpenMetadataArchive;
    }

    public void setArchiveContents(OpenMetadataArchive archiveContents) {
        File archiveStoreFile = new File(this.archiveStoreName);
        try {
            log.debug("Writing open metadata archive store properties: " + archiveContents);
            if (archiveContents == null) {
                archiveStoreFile.delete();
            } else {
                String archiveStoreFileContents = OBJECT_WRITER.writeValueAsString((Object)archiveContents);
                FileUtils.writeStringToFile((File)archiveStoreFile, (String)archiveStoreFileContents, (String)null, (boolean)false);
            }
        }
        catch (IOException ioException) {
            log.debug("Unusable Server config Store :(", (Throwable)ioException);
        }
    }

    public void start() throws ConnectorCheckedException {
        super.start();
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        log.debug("Closing Config Store.");
    }
}

