/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum FileBasedOpenMetadataArchiveStoreConnectorAuditCode implements AuditLogMessageSet
{
    OPENING_FILE("FILE-OPEN-METADATA-ARCHIVE-STORE-CONNECTOR-0001", AuditLogRecordSeverityLevel.STARTUP, "Opening file {0} for Open Metadata Archive Store", "The local server is requesting the contents of the open metadata archive store which is located in the named file.", "Validate that the file name is correct.  Look particularly for extraneous quotes, incorrect directory name (relative files are read from the perspective of the server's home directory) or incorrect characters.  Once the file name is corrected (either in the server's configuration or the command that loaded the archive) then retry themechanism that loads the archive."),
    BAD_FILE("FILE-OPEN-METADATA-ARCHIVE-STORE-CONNECTOR-0002", AuditLogRecordSeverityLevel.ERROR, "Unable to open file {0}.  Message from {1} exception was {2}", "The server is is unable to open an open metadata archive store.", "Use the information from the exception to determine the cause of the error.  For example, is the filename correct?  Does this runtime have permission to access the file?  Once the cause of the error is corrected, restart the caller.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private FileBasedOpenMetadataArchiveStoreConnectorAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "AuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

