/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum OpenMetadataConformanceStatus implements Serializable
{
    UNKNOWN_STATUS(0, "Unknown status", "There is not enough evidence to determine the conformance of the technology under test."),
    CONFORMANT_FULL_SUPPORT(1, "Conformant with full support", "The technology provides correctly functioning support for all features in this profile."),
    CONFORMANT_PARTIAL_SUPPORT(2, "Conformant with partial support", "The technology provides correctly functioning support for some of the features in this profile and responds appropriately for features it does not support."),
    CONFORMANT_NO_SUPPORT(3, "Conformant with no support", "The technology provides correctly functioning responses that indicate it has no support for the features in this profile."),
    NOT_CONFORMANT(4, "Not Conformant", "The technology is not functioning according to the open metadata specifications.");

    private static final long serialVersionUID = 1L;
    private int ordinal;
    private String name;
    private String description;

    private OpenMetadataConformanceStatus(int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "OpenMetadataConformanceProfilePriority{ordinal=" + this.ordinal + ", name='" + this.name + '\'' + ", description='" + this.description + '}';
    }
}

