/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.conformance.beans;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceTestLabResults;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceWorkbenchResults;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceWorkbenchStatus;
import org.odpi.openmetadata.conformance.beans.OpenMetadataConformanceWorkbenchWorkPad;
import org.odpi.openmetadata.conformance.beans.OpenMetadataTestCaseResult;
import org.odpi.openmetadata.conformance.ffdc.ConformanceSuiteErrorCode;
import org.odpi.openmetadata.conformance.ffdc.exception.InvalidParameterException;

public class TechnologyUnderTestWorkPad {
    private OpenMetadataConformanceTestLabResults testLabResults = new OpenMetadataConformanceTestLabResults();
    private List<OpenMetadataConformanceWorkbenchWorkPad> workbenchWorkPads;

    public TechnologyUnderTestWorkPad(List<OpenMetadataConformanceWorkbenchWorkPad> workbenchWorkPads) {
        this.workbenchWorkPads = workbenchWorkPads;
        this.testLabResults.setTestRunDate(new Date());
    }

    public OpenMetadataTestCaseResult getTestCaseReport(String testCaseId) throws InvalidParameterException {
        String methodName = "getTestCaseReport";
        String parameterName = "testCaseId";
        if (this.workbenchWorkPads != null) {
            for (OpenMetadataConformanceWorkbenchWorkPad workBenchWorkPad : this.workbenchWorkPads) {
                if (workBenchWorkPad == null) continue;
                try {
                    return workBenchWorkPad.getTestCaseResult(testCaseId);
                }
                catch (InvalidParameterException invalidParameterException) {
                }
            }
        }
        ConformanceSuiteErrorCode errorCode = ConformanceSuiteErrorCode.UNKNOWN_TEST_CASE_ID;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(testCaseId);
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getTestCaseReport", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "testCaseId");
    }

    public List<OpenMetadataTestCaseResult> getFailedTestCaseReport() {
        ArrayList<OpenMetadataTestCaseResult> failedTestCases = new ArrayList<OpenMetadataTestCaseResult>();
        if (this.workbenchWorkPads != null) {
            for (OpenMetadataConformanceWorkbenchWorkPad workBenchWorkPad : this.workbenchWorkPads) {
                List<OpenMetadataTestCaseResult> failedTestCasesFromWorkbench;
                if (workBenchWorkPad == null || (failedTestCasesFromWorkbench = workBenchWorkPad.getFailedTestCases()) == null) continue;
                failedTestCases.addAll(failedTestCasesFromWorkbench);
            }
        }
        if (failedTestCases.isEmpty()) {
            return null;
        }
        return failedTestCases;
    }

    public OpenMetadataConformanceWorkbenchResults getWorkbenchReport(String workbenchId) throws InvalidParameterException {
        String methodName = "getWorkbenchReport";
        String parameterName = "workbenchId";
        if (this.workbenchWorkPads != null) {
            for (OpenMetadataConformanceWorkbenchWorkPad workBenchWorkPad : this.workbenchWorkPads) {
                if (workBenchWorkPad == null || !workBenchWorkPad.getWorkbenchId().equals(workbenchId)) continue;
                return workBenchWorkPad.getWorkbenchResults();
            }
        }
        ConformanceSuiteErrorCode errorCode = ConformanceSuiteErrorCode.UNKNOWN_WORKBENCH_ID;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(workbenchId);
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getWorkbenchReport", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "workbenchId");
    }

    public OpenMetadataConformanceWorkbenchStatus getWorkbenchStatus(String workbenchId) throws InvalidParameterException {
        String methodName = "getWorkbenchStatus";
        String parameterName = "workbenchId";
        if (this.workbenchWorkPads != null) {
            for (OpenMetadataConformanceWorkbenchWorkPad workBenchWorkPad : this.workbenchWorkPads) {
                if (workBenchWorkPad == null || !workBenchWorkPad.getWorkbenchId().equals(workbenchId)) continue;
                return workBenchWorkPad.getWorkbenchStatus();
            }
        }
        ConformanceSuiteErrorCode errorCode = ConformanceSuiteErrorCode.UNKNOWN_WORKBENCH_ID;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(workbenchId);
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getWorkbenchStatus", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "workbenchId");
    }

    public OpenMetadataConformanceTestLabResults getTestLabResults() {
        ArrayList<OpenMetadataConformanceWorkbenchResults> workbenchResults = new ArrayList<OpenMetadataConformanceWorkbenchResults>();
        if (this.workbenchWorkPads != null) {
            for (OpenMetadataConformanceWorkbenchWorkPad workBenchWorkPad : this.workbenchWorkPads) {
                if (workBenchWorkPad == null) continue;
                workbenchResults.add(workBenchWorkPad.getWorkbenchResults());
            }
        }
        if (!workbenchResults.isEmpty()) {
            this.testLabResults.setTestResultsFromWorkbenches(workbenchResults);
        }
        return this.testLabResults;
    }

    public String toString() {
        return "TechnologyUnderTestWorkPad{testLabResults=" + this.testLabResults + ", workbenchWorkPads=" + this.workbenchWorkPads + ", failedTestCaseReport=" + this.getFailedTestCaseReport() + '}';
    }
}

